Attribute VB_Name = "TypeDescriptions"
Option Explicit

Private Function adTypeName(lngType As DataTypeEnum) As String

    Select Case lngType
    Case adBigInt
        adTypeName = "adBigInt"
    Case adBinary
        adTypeName = "adBinary"
    Case adBoolean
        adTypeName = "adBoolean"
    Case adBSTR
        adTypeName = "adBSTR"
    Case adChapter
        adTypeName = "adChapterr"
    Case adChar
        adTypeName = "adChar"
    Case adCurrency
        adTypeName = "adCurrency"
    Case adDate
        adTypeName = "adDate"
    Case adDBDate
        adTypeName = "adDBDate"
    Case adDBFileTime
        adTypeName = "adDBFileTime"
    Case adDBTime
        adTypeName = "adDBTime"
    Case adDBTimeStamp
        adTypeName = "adDBTimeStamp"
    Case adDecimal
        adTypeName = "adDecimal"
    Case adDouble
        adTypeName = "adDouble"
    Case adEmpty
        adTypeName = "adEmpty"
    Case adError
        adTypeName = "adError"
    Case adFileTime
        adTypeName = "adFileTime"
    Case adGUID
        adTypeName = "adGUID"
    Case adIDispatch
        adTypeName = "adIDispatch"
    Case adInteger
        adTypeName = "adInteger"
    Case adIUnknown
        adTypeName = "adIUnknown"
    Case adLongVarBinary
        adTypeName = "adLongVarBinary"
    Case adLongVarChar
        adTypeName = "adLongVarChar"
    Case adLongVarWChar
        adTypeName = "adLongVarWChar"
    Case adNumeric
        adTypeName = "adNumeric"
    Case adPropVariant
        adTypeName = "adPropVariant"
    Case adSingle
        adTypeName = "adSingle"
    Case adSmallInt
        adTypeName = "adSmallInt"
    Case adTinyInt
        adTypeName = "adTinyInt"
    Case adUnsignedBigInt
        adTypeName = "adUnsignedBigInt"
    Case adUnsignedInt
        adTypeName = "adUnsignedInt"
    Case adUnsignedSmallInt
        adTypeName = "adUnsignedSmallInt"
    Case adUnsignedTinyInt
        adTypeName = "adUnsignedTinyInt"
    Case adUserDefined
        adTypeName = "adUserDefined"
    Case adVarBinary
        adTypeName = "adVarBinary"
    Case adVarChar
        adTypeName = "adVarChar"
    Case adVariant
        adTypeName = "adVariant"
    Case adVarNumeric
        adTypeName = "adVarNumeric"
    Case adVarWChar
        adTypeName = "adVarWChar"
    Case adWChar
        adTypeName = "adWChar"
    Case Else
        adTypeName = "other"
    End Select
    
End Function


Private Function CursorTypeDesc(ByVal iCT As CursorTypeEnum) As String

    ' return the description for the cursor type
    
    Select Case iCT
    Case adOpenForwardOnly
        CursorTypeDesc = "adOpenForwardOnly"
    Case adOpenKeyset
        CursorTypeDesc = "adOpenKeyset"
    Case adOpenStatic
        CursorTypeDesc = "adOpenStatic"
    Case adOpenDynamic
        CursorTypeDesc = "adOpenDynamic"
    End Select

End Function

Private Function LockTypeDesc(ByVal iLT As LockTypeEnum) As String

    ' return the description for the lock type

    Select Case iLT
    Case adLockReadOnly
        LockTypeDesc = "adLockReadOnly"
    Case adLockPessimistic
        LockTypeDesc = "adLockPessimistic"
    Case adLockOptimistic
        LockTypeDesc = "adLockOptimistic"
    Case adLockBatchOptimistic
        LockTypeDesc = "adLockBatchOptimistic"
    End Select

End Function

Private Function CursorLocationDesc(ByVal iCL As CursorLocationEnum) As String

    ' return the description for the cursor location

    Select Case iCL
    Case adUseServer
        CursorLocationDesc = "adUseServer"
    Case adUseClient
        CursorLocationDesc = "adUseClient"
    End Select

End Function

Private Function CommandTypeDesc(ByVal iCT As CommandTypeEnum) As String

    ' return the description for the command type

    Select Case iCT
    Case (adCmdText And m_iadExecuteNoRecords)
        CommandTypeDesc = "adCmdText + NoRecs"
    Case (adCmdStoredProc And m_iadExecuteNoRecords)
        CommandTypeDesc = "adCmdStoredProc + NoRecs"
    Case adCmdText
        CommandTypeDesc = "adCmdText"
    Case adCmdStoredProc
        CommandTypeDesc = "adCmdStoredProc"
    Case adCmdTable
        CommandTypeDesc = "adCmdTable"
    Case m_iadCmdTableDirect
        CommandTypeDesc = "adCmdTableDirect"
    Case adCmdUnknown
        CommandTypeDesc = "adCmdUnknown"
    End Select

End Function

