VERSION 5.00
Object = "{E1797C92-33FE-11D1-A2FF-444553540000}#1.3#0"; "ccrpFileDialogs.ocx"
Begin VB.Form frmConnect 
   Caption         =   "ADO Performance Harness"
   ClientHeight    =   2790
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   9150
   LinkTopic       =   "Form1"
   ScaleHeight     =   2790
   ScaleWidth      =   9150
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox txtLogDB 
      Height          =   285
      Left            =   960
      TabIndex        =   16
      Top             =   2400
      Width           =   4215
   End
   Begin VB.CommandButton cmdLogDB 
      Caption         =   "..."
      Height          =   255
      Left            =   5280
      TabIndex        =   14
      Top             =   2400
      Width           =   375
   End
   Begin ccrpCommonDialogs.ccrpFileDialogs ccrpFileDialogs1 
      Left            =   240
      Top             =   1200
      _ExtentX        =   1085
      _ExtentY        =   1138
      Flags           =   2101248
      ExtendedMode    =   0   'False
   End
   Begin VB.CommandButton cmdCancel 
      Caption         =   "&Cancel"
      Height          =   375
      Left            =   6600
      TabIndex        =   13
      Top             =   2280
      Width           =   1095
   End
   Begin VB.CommandButton cmdConnect 
      Caption         =   "Co&nnect"
      Enabled         =   0   'False
      Height          =   375
      Left            =   7920
      TabIndex        =   12
      Top             =   2280
      Width           =   1095
   End
   Begin VB.Frame fraConnection 
      Caption         =   "Data Store"
      Height          =   1815
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   8895
      Begin VB.TextBox txtDatabase 
         Height          =   285
         Left            =   1680
         TabIndex        =   6
         Top             =   840
         Width           =   2415
      End
      Begin VB.CommandButton cmdFind 
         Caption         =   "..."
         Enabled         =   0   'False
         Height          =   255
         Left            =   4200
         TabIndex        =   5
         Top             =   840
         Width           =   375
      End
      Begin VB.ComboBox cboDrivers 
         Enabled         =   0   'False
         Height          =   315
         Left            =   5640
         Sorted          =   -1  'True
         TabIndex        =   4
         Top             =   840
         Width           =   3135
      End
      Begin VB.TextBox txtConnectString 
         Height          =   285
         Left            =   1680
         TabIndex        =   3
         Top             =   1320
         Width           =   7095
      End
      Begin VB.ComboBox cboDSN 
         Enabled         =   0   'False
         Height          =   315
         Left            =   5640
         Sorted          =   -1  'True
         TabIndex        =   2
         Top             =   360
         Width           =   3135
      End
      Begin VB.ComboBox cboProvider 
         Height          =   315
         Left            =   1680
         TabIndex        =   1
         Top             =   360
         Width           =   2895
      End
      Begin VB.Label lblDatabase 
         Caption         =   "Database:"
         Height          =   255
         Left            =   240
         TabIndex        =   11
         Top             =   840
         Width           =   975
      End
      Begin VB.Label lblDrivers 
         Caption         =   "Drivers:"
         Enabled         =   0   'False
         Height          =   255
         Left            =   4800
         TabIndex        =   10
         Top             =   840
         Width           =   735
      End
      Begin VB.Label lblConnectString 
         Caption         =   "Connect String:"
         Height          =   255
         Left            =   240
         TabIndex        =   9
         Top             =   1320
         Width           =   1215
      End
      Begin VB.Label lblDSN 
         Caption         =   "DSN:"
         Enabled         =   0   'False
         Height          =   255
         Left            =   4800
         TabIndex        =   8
         Top             =   360
         Width           =   735
      End
      Begin VB.Label lblProvider 
         Caption         =   "Provider:"
         Height          =   255
         Left            =   240
         TabIndex        =   7
         Top             =   360
         Width           =   975
      End
   End
   Begin VB.Label lblLogTo 
      Caption         =   "Log To:"
      Height          =   255
      Left            =   240
      TabIndex        =   15
      Top             =   2400
      Width           =   615
   End
End
Attribute VB_Name = "frmConnect"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' default connection details - used as placeholders when
' creating the connection string
Private Const SERVER_NAME       As String = "server_name"
Private Const USER_NAME         As String = "user_name"
Private Const USER_PWD          As String = "user_password"
Private Const DATABASE_NAME     As String = "database_name"

Private Const DSN_LESS          As String = "(DSN-less)"
Private Const ODBC_PROVIDER     As String = "MSDASQL"

' logging database - default directory
' can be overwritten at run time
Private Const m_cPerfLog        As String = "C:\Temp\ADOPerfLog.mdb"

' globals
Private m_bLogDB                As Boolean  ' true if selecting the loggin database

' list of oledb providers
' ideally this shouls query the system for installed providers, but
' VB doesn't provide a way to do this.
Private m_avProviders           As Variant


Private Sub cboDrivers_Click()

    ' set the driver selected
    g_sDriver = cboDrivers

    ' enable the find button, to allow the access database to be picked
    cmdFind.Enabled = (g_sDriver = ACCESS_DRIVER)

    ConnectString

End Sub

Private Sub cboDSN_Click()

    ' OLEDB Provider for ODBC, using a DSN
    
    Dim bEn        As Boolean

    If cboDSN.ListIndex = -1 Then
        Exit Sub
    End If

    ' default to a blank connect string if DSN less
    If cboDSN = DSN_LESS Then
        bEn = True
        txtConnectString = ""
    Else
        bEn = False
        txtConnectString = "DSN=" & cboDSN
    End If

    ' enable/disable the odbc drivers combo
    lblDrivers.Enabled = bEn
    cboDrivers.Enabled = bEn

    ConnectString

End Sub

Private Sub cboProvider_Click()

    ' oledb provider selected
    
    Dim bEn         As Boolean

    If cboProvider.ListIndex = -1 Then
        Exit Sub
    End If

    ' set global provider string
    g_sProvider = m_avProviders(cboProvider.ListIndex)

    'enable/disable the the DSN combo, and the find button if Access selected
    bEn = (g_sProvider = ODBC_PROVIDER)
    lblDSN.Enabled = bEn
    cboDSN.Enabled = bEn

    cmdFind.Enabled = (g_sProvider = ACCESS_PROVIDER)

    ConnectString

End Sub


Private Sub ccrpFileDialogs1_FileSelected(ByVal sFilename As String)

    ' find the database - either the logging db or the test db
    If m_bLogDB Then
        txtLogDB = ccrpFileDialogs1.filename
    Else
        txtDatabase = ccrpFileDialogs1.filename
    End If

End Sub

Private Sub cmdCancel_Click()

    End

End Sub

Private Sub cmdConnect_Click()

    ' open the actual performance form
    Me.Visible = False
    frmPerf.Show

End Sub

Private Sub cmdFind_Click()

    ' find an access database
    With ccrpFileDialogs1
        .DialogTitle = "Find Access Database"
        .Filter = "Access Databases (*.mdb)|*.mdb"
        .ShowOpen
    End With

End Sub

Private Sub cmdLogDB_Click()

    ' find the logging database
    m_bLogDB = True
    With ccrpFileDialogs1
        .DialogTitle = "Find Logging Database"
        .Filter = "Access Databases (*.mdb)|*.mdb"
        .ShowOpen
    End With
    m_bLogDB = False

End Sub

Private Sub Form_Load()

    ' fill the combo boxes
    ProvidersComboFill
    DSNComboFill
    ODBCDriversComboFill

    txtLogDB = m_cPerfLog
    
End Sub


Private Sub ConnectString()

    ' build a default connection string
    
    Dim sDB     As String
    Dim sConn   As String

    ' database name entered
    If Trim(txtDatabase) = "" Then
        sDB = DATABASE_NAME
    Else
        sDB = txtDatabase
    End If

    ' build the string
    Select Case g_sProvider
    Case ODBC_PROVIDER
        sConn = "Driver={" & g_sDriver & "}; "
        ' TODO: Add other odbc connect strings
        Select Case g_sDriver
        Case ACCESS_DRIVER
            sConn = sConn & " DBQ=" & sDB
        Case Else
            sConn = sConn & " Server=" & SERVER_NAME & _
                "; Database=" & sDB & _
                "; UID=" & USER_NAME & _
                "; PWD=" & USER_PWD
        End Select

    Case "SQLOLEDB"
        sConn = "Data Source=" & SERVER_NAME & _
            "; Initial Catalog=" & sDB & _
                "; User Id=" & USER_NAME & _
                "; Password=" & USER_PWD

    Case ACCESS_PROVIDER
        sConn = sDB

    End Select

    If cboDSN.Enabled And cboDSN <> DSN_LESS Then
        sConn = "DSN=" & cboDSN
    End If

    g_sConnectString = sConn
    txtConnectString = g_sConnectString

End Sub


Private Sub ProvidersComboFill()

    ' fill the oledb providers combo
    ' ideally, should query for installed providers
    With cboProvider
        .AddItem "Microsoft Provider for ODBC"
        .AddItem "Microsoft Provider for SQL Server"
        .AddItem ACCESS_PROV_DESC
    End With

    m_avProviders = Array(ODBC_PROVIDER, "SQLOLEDB", ACCESS_PROVIDER)

End Sub

Private Sub DSNComboFill()

    ' fill the odbc data source names combo

    Dim asDSN()     As String
    Dim iDSN        As Integer

    ODBCDataSources asDSN

    cboDSN.AddItem DSN_LESS
    For iDSN = 0 To UBound(asDSN) - 1
        cboDSN.AddItem asDSN(iDSN)
    Next

End Sub

Private Sub ODBCDriversComboFill()

    ' fill the odbc drivers combo
    
    Dim asDrivers() As String
    Dim iDriver     As Integer

    ODBCDrivers asDrivers

    For iDriver = 0 To UBound(asDrivers) - 1
        cboDrivers.AddItem asDrivers(iDriver)
    Next

End Sub

Private Sub txtConnectString_Change()

    ' set global connect string if manually changed
    cmdConnect.Enabled = (Trim(txtConnectString) <> "")
    g_sConnectString = txtConnectString

End Sub

Private Sub txtDatabase_Change()

    ConnectString

End Sub

Private Sub txtLogDB_Change()

    g_sLogdb = txtLogDB

End Sub
