﻿/*
# Apprendre à programmer en ActionScript
# A. Tasso
# Chapitre 10 : Le traitement de données multimédias
# Projet   : Portfolio Multimédia
# Fichier : ProjetChapitre10.fla
# Classe : Item.as, Menu.as, Vignette.as, BarreNavigation.as, controleurSimple.as et Infos.as
*/

//Définition de la classe Menu
class BarreNavigation extends MovieClip {
 // Définition des attributs de la classe	
 private var listeVignettes:Array;
 
  
 private function aGauche(btnG:MovieClip, btnD:MovieClip,lm:Number, ltv:Number):Void{
  for(var i:Number = 0; i < listeVignettes.length; i++) {
    listeVignettes[i].seDeplaceAGauche(i,btnG,btnD, lm, ltv );
  }
 }

 private function aDroite(btnG:MovieClip, btnD:MovieClip, lm:Number, ltv:Number):Void{
  for(var i:Number = 0; i < listeVignettes.length; i++) {
    listeVignettes[i].seDeplaceADroite(i,btnG, btnD, lm, ltv );
  }
 }

 private function arreterTout():Void{
  for(var i:Number = 0; i < listeVignettes.length; i++) {
    listeVignettes[i].arreterLeDeplacement();
  }
 }

 // La vignette doit connaitre la rubrique et le format du fichier
 function ajouterUneVignette(cible:MovieClip, p:Number, c:String, n:Number, r:String, f:String):Void{
  var nvelleVignette:Vignette = new Vignette(cible, p, c, n, r, f);
  listeVignettes.push(nvelleVignette);
 
 }

 // Définition de la fonction constructeur r = rubrique f = format du fichier
 public function BarreNavigation(cible:MovieClip, p:Number, nx:Number, ny:Number, c:String, n:Number, r:String, f:String) {
  var cetteBarre:BarreNavigation = this;
  var tmp:MovieClip;
  var nbVignettes:Number = n;
  var niveau:Number = p;

  var mask:MovieClip = cible.attachMovie("MaskNavigationClp","mask", niveau);
  mask._x = nx ;
  mask._y = ny;
  cible.setMask(mask);
  var largeurMask:Number = mask._width;
  var largeurTotalVignette:Number = Vignette.largeur*nbVignettes;

  niveau++;
 
  var  btnD:MovieClip = cible.attachMovie("BtnDroitClp", "adroite", niveau );
  btnD._x = 2*mask._width / 3 ;
  btnD._y = 4*Vignette.largeur/ 3;
  // S'il y a moins de 3 vignettes, le bouton droit ne s'affiche pas
  if (nbVignettes <=3) btnD._visible = false;
  btnD.onRollOver = function():Void {
   this.gotoAndStop(2);
   cetteBarre.aGauche(btnG, this,largeurMask, largeurTotalVignette);
  }
  btnD.onRollOut = function():Void {
   this.gotoAndStop(1);
   cetteBarre.arreterTout();
  }
  

  niveau++;
 
  var  btnG:MovieClip = cible.attachMovie("BtnGcheClp", "agauche", niveau );
  btnG._x = mask._width / 3 ;
  btnG._y = 4*Vignette.largeur/3 ;
  btnG._visible = false;
  btnG.onRollOver = function () {
   this.gotoAndStop(2);
   cetteBarre.aDroite(this, btnD, largeurMask, largeurTotalVignette);
  }
  btnG.onRollOut = function():Void {
   this.gotoAndStop(1);
   cetteBarre.arreterTout();
  }
  niveau++;
  listeVignettes = new Array();
  var j:Number = 0;
  // Supprimer toutes les vignettes précédentes
  do {
    tmp = cible.getInstanceAtDepth(niveau+j);
    j++;
    tmp.removeMovieClip();
  } while (tmp != undefined);

  // Afficher les nouvelles vignettes
  for(var i:Number = 0; i < nbVignettes; i++) {
    cetteBarre.ajouterUneVignette(cible, niveau+i , c, i, r, f);
    cetteBarre.listeVignettes[i].sAffiche(Vignette.largeur*i+nx, ny);
  }
 }

}
