﻿/*
# Apprendre à programmer en ActionScript
# A. Tasso
# Chapitre 10 : Le traitement de données multimédias
# Projet   : Portfolio Multimédia
# Fichier : ProjetChapitre10.fla
# Classe : Item.as, Menu.as, Vignette.as, BarreNavigation.as, controleurSimple.as et Infos.as
*/

//Définition de la classe Item
class Item extends MovieClip{

 private var info:Array;
 private var cetItem:MovieClip;
 private static var  vitesseItem:Number = 12;
  
 public function afficher(yMax:Number) {  
  cetItem._visible=true;
  cetItem.onEnterFrame = function() {
     this._y +=vitesseItem ;
     if (this._y >=  yMax) {
         this._y =  yMax;
	 delete this.onEnterFrame;
     }
   }
 }

 public function effacer(yMin:Number) { 
  cetItem.onEnterFrame = function() {
     this._y -=vitesseItem ;
     if (this._y <=  yMin) {
	 this._y = yMin;                      
	 delete this.onEnterFrame;
         this._visible = false;
     }
   }
 }

 public function setCheminPhoto(l:Array):String {
   return "../"+l[0]+"/"+l[2]+"/";
 }

 public function Item(nom:String, cible:MovieClip, profondeur:Number, x:Number, y:Number,  l:Array) {

   cetItem = cible.attachMovie("ItemMenuClp", nom+profondeur, profondeur);
   cetItem._x = x;
   cetItem._y = y;
   cetItem._visible = false;
   cetItem.chemin = setCheminPhoto(l);
   cetItem.label = l[2];
   cetItem.labelOut.text=l[2];
   cetItem.nbElt = l[3];
   cetItem.format=l[1];
    
   cetItem.onRollOver = function():Void {
     this._alpha = 40;
   };

   cetItem.onRollOut = function():Void {
     this._alpha = 100;
   };

   cetItem.onPress = function():Void {
    // Dès qu'un item est sélectionné, arrêter le flux vidéo
    _global.unFluxVideo.pause(true);
    _global.unFluxVideo.seek(0);
      
    var bNav:BarreNavigation;
    bNav = new BarreNavigation(_global.FdNav, _global.niveauNavigation+1,  0, 0, this.chemin, this.nbElt, this.label, this.format);
    // Afficher le texte associé à la première vignette 
    var texte:Infos = new Infos(_global.FdTxt ,this.chemin+"Infos0.txt", 5, 10)
    
    // Traiter la vidéo
    if (this.format == ".flv") {
         // Le fond Photo devient invisible et le fond Vidéo visible
         _global.FdPho._visible=false    
         _global.FdVideo._visible=true;
         // Charger la vidéo associée à la première vignette
         var cheminVideo:String = this.chemin+this.label+"0"+this.format;
         var ctrl:ControleurSimple = new ControleurSimple(cheminVideo);
 
     }
     // Traiter les animations ou les photos
       else  {    
          // Le fond Vidéo devient invisible et le fond Photo visible
          _global.FdPho._visible=true;
          _global.FdVideo._visible=false;
          // Charger la photo associée à la première vignette
          _global.FdPho.loadMovie(this.chemin+this.label+"0"+this.format);     
       }
   };
 }

}
 
