﻿/*
# Apprendre à programmer en ActionScript
# A. Tasso
# Chapitre 10 : Le traitement de données multimédias
# Projet   : Portfolio Multimédia
# Fichier : ProjetChapitre10.fla
# Classe : Item.as, Menu.as, Vignette.as, BarreNavigation.as, controleurSimple.as et Infos.as
*/

//Définition de la classe Menu 
class Menu extends MovieClip {
        // Définition des attributs de la classe
	private var entete:MovieClip;
        private var listeItems:Array;
        public var estVisible:Boolean = false;

 private function aDerouler(nbr:Number):Void{
  var x:Number =  entete._x;
  var y:Number =  entete._y;
  var h:Number =  entete._height;
  for(var i:Number = 0; i < nbr; i++) {
    listeItems[i].afficher(h*(i+1)+y );
  }
 }

 private function aEnrouler(nbr:Number, p:Number):Void{
  var x:Number =  entete._x;
  var y:Number =  entete._y;
  var h:Number =  entete._height;

  for(var i:Number = 0; i < nbr ; i++){
    listeItems[i].effacer(y);
  }
 }

 function ajouterUnItem(cible:MovieClip, np:Number, rubrique:Array):Void{
  var x:Number =  entete._x;
  var y:Number =  entete._y;
  var h:Number =  entete._height;

  var profondeur:Number = np - (listeItems.length +1);
  var nvelItem:Item = new Item(rubrique[2], cible,  profondeur, x,y, rubrique);
  listeItems.push(nvelItem);
 }

 // Définition de la fonction constructeur 
 public function Menu(nom:String, p:Number, cible:MovieClip,  nx:Number, ny:Number, l:Array) {
  
  var ceMenu:Menu = this;
  Mouse.addListener(ceMenu);

  var nbRubrique:Number = l.length;
  var profondeur =  p+nbRubrique;

  var clicSurEntete:Boolean = false;
  entete = cible.attachMovie("ItemMenuClp", nom+profondeur, profondeur);
  entete._x = nx;
  entete._y = ny;
  entete.labelOut.text = nom;
  
  listeItems = new Array();
  for(var i:Number = 0; i < nbRubrique; i++) {
    ceMenu.ajouterUnItem(cible,profondeur, l[i]);
  }

  entete.onPress = function ():Void {
   if(clicSurEntete) ceMenu.estVisible = true;
    if( !ceMenu.estVisible) {
    ceMenu.aDerouler(nbRubrique);
    ceMenu.estVisible = true;
   }
   else {
     ceMenu.aEnrouler(nbRubrique, ny);
     ceMenu.estVisible = false;
   } 
   if( clicSurEntete ) clicSurEntete = false;
      else clicSurEntete = true;
  }

 entete.onRollOver = function():Void {
   this._alpha = 40;
  }

 entete.onRollOut = function():Void {
   this._alpha = 100;
  }

 ceMenu.onMouseDown = function():Void {
      if(!this.estVisible && clicSurEntete) clicSurEntete = false;
      this.aEnrouler(nbRubrique, ny);
      this.estVisible = false;
  };
 }

}
