﻿/*
# Apprendre à programmer en ActionScript
# A. Tasso
# Chapitre 8 : Classes et Objets
# Construire et utiliser ses propres classes
# Fichier : Personne.as
*/

//Définition de la classe Personne
class Personne {
   // Définition des attributs de la classe
   public var prenom:String;
   public var nom:String;
   public var dateNaissance:Date;
	
  // Définition de la fonction constructeur 
   public function Personne( p:String, n:String, j:Number, m:Number, a:Number) {
	  prenom = p;
	  nom = n
	  dateNaissance = new Date(a, m, j);
	  if ( ! verifDateNaissance()) { 
	    dateNaissance = new Date();
	  }
   }

  // Une méthode pour vérifier le validité de la date de naissance
  public function verifDateNaissance ():Boolean {	
    var aujourdHui:Date = new Date();
    var cetteAnnee:Number  = aujourdHui.getFullYear();
    var anneeNaissance:Number = dateNaissance.getFullYear();
	if (cetteAnnee  < anneeNaissance) return false;
    else return true;
  }

  // Définition du comportement jeMePresente()
  public function jeMePresente():String {
	  var age:Number = getAge()
	  return "Je m'appelle " + prenom + " " + nom + "\nJ'ai " +
          age + " ans ";
  }
	
  // Définition de la méthode calculant l’âge de la personne
  public function getAge():Number {
    var aujourdHui:Date = new Date();
    var age:Number = aujourdHui.getFullYear() - dateNaissance.getFullYear();
    return age;
  }
}
