﻿/*
# Apprendre à programmer en ActionScript
# A. Tasso
# Chapitre 9 : Les principes du concept objet
# Exemple : L'héritage
# Fichier : CreerDesPersonnesControlees.fla
# Classe :  Personne.as 
*/

//Définition de la classe Personne
class Personne {
        // Définition des attributs de la classe
	private var prenom:String;
	private var nom:String;
	private var dateNaissance:Date;

 public function getPrenom():String {
	return prenom;
 }
	
 public function getNom():String {
 	return nom;
 }
	
 public function getDateNaissance():String {
	return dateNaissance.getDate()+"/" + dateNaissance.getMonth() + "/" +dateNaissance.getYear();
 }
	
 public function setPrenom(p:String):Void {
	 prenom = p;
 }
 public function setNom(n:String):Void {
	 nom = n;
 }


 public function setDateNaissance(dn:String):Void {
   var tmp:Array=new Array();
   tmp = dn.split("/",3);

    dateNaissance = new Date(tmp[2], tmp[1], tmp[0]);
   if ( ! valideDateNaissance()) { 
	  dateNaissance = new Date();
   }
 }
	
 // Définition de la fonction constructeur 
 public function Personne( p:String, n:String, dn:String) {
   setNom(p);
   setPrenom(n);
   setDateNaissance(dn);
 }

 
 // Méthode invisible (métier) pour vérifier la validité de la date de naissance
 private function valideDateNaissance ():Boolean {	
    var aujourdHui:Date = new Date();
    var cetteAnnee:Number  = aujourdHui.getFullYear();
    var anneeNaissance:Number = dateNaissance.getFullYear();
	if (cetteAnnee  < anneeNaissance) return false;
    else return true;
 }

 // Définition du comportement sePresente()
 public function sePresente():String {
    var age:Number = getAge()
    return "Je m'appelle " + prenom + " " + nom + "\nJ'ai " + age + " ans ";
 }
	
  // Définition de la méthode calculant l’âge de la personne
  public function getAge():Number {
    var aujourdHui:Date = new Date();
    var age:Number = aujourdHui.getFullYear() - dateNaissance.getFullYear();
    return age;
  }
}
