﻿/*
# Apprendre à programmer en ActionScript
# A. Tasso
# Chapitre 9 : Les principes du concept objet
# Exercice : Une barre de navigation
# Fichier : Exercice 9_11.fla
# Classe : BarreNavigation.as 
*/

//Définition de la classe Menu extends MovieClip
class BarreNavigation extends MovieClip {
    private var listeVignettes:Array;
  
 private function aGauche(btnG:MovieClip, btnD:MovieClip,lm:Number, ltv:Number):Void{
   for(var i:Number = 0; i < listeVignettes.length; i++) {
    listeVignettes[i].seDeplaceAGauche(i,btnG,btnD, lm, ltv );
   }
 }

 private function aDroite(btnG:MovieClip, btnD:MovieClip, lm:Number, ltv:Number):Void{
  for(var i:Number = 0; i < listeVignettes.length; i++) {
    listeVignettes[i].seDeplaceADroite(i,btnG, btnD, lm, ltv );
  }
}

 private function arreterTout():Void{
  for(var i:Number = 0; i < listeVignettes.length; i++) {
    listeVignettes[i].arreterLeDeplacement();
  }
 }

 function ajouterUneVignette(cible:MovieClip, p:Number, c:String, n:Number, r:String):Void{
   var nvelleVignette:Vignette = new Vignette(cible, p, c, n, r);
   listeVignettes.push(nvelleVignette);
 }

 // Définition de la fonction constructeur 
 public function BarreNavigation(cible:MovieClip, p:Number, nx:Number, ny:Number, c:String, n:Number, r:String) {
  var cetteBarre:BarreNavigation = this;
  var nbVignettes:Number = n;
  var niveau = p;

  // Créer un masque
  var mask:MovieClip = cible.attachMovie("MaskNavigationClp","mask", niveau);
  mask._x = nx ;
  mask._y = ny;
  cible.setMask(mask);
  var largeurMask:Number = mask._width;
  var largeurTotalVignette:Number = Vignette.largeur*nbVignettes;
  
  // Passer au niveau supérieur 
  niveau++;
  // a. Créer le bouton droit
  var  btnD:MovieClip = cible.attachMovie("BtnDroitClp", "adroite", niveau );
  btnD._x = 2*mask._width / 3 + nx;
  btnD._y = 4*Vignette.largeur/ 3 + ny;
  btnD.onRollOver = function():Void {
    this.gotoAndStop(2);
    // b. Les vignettes se déplacent vers la gauche
    cetteBarre.aGauche(btnG, this,largeurMask, largeurTotalVignette);
  }
  btnD.onRollOut = function():Void {
    this.gotoAndStop(1);
    // d. Les vignettes s'arrêtent
    cetteBarre.arreterTout();
  }

  // Passer au niveau supérieur 
  niveau++;
  // a. Créer le bouton gauche
  var  btnG:MovieClip = cible.attachMovie("BtnGcheClp", "agauche", niveau );
  btnG._x = mask._width / 3 + nx ;
  btnG._y = 4*Vignette.largeur/3 +ny ;
  btnG._visible = false;
  btnG.onRollOver = function():Void {
   this.gotoAndStop(2);
    // b. Les vignettes se déplacent vers la droite
   cetteBarre.aDroite(this, btnD, largeurMask, largeurTotalVignette);
  }
  btnG.onRollOut = function():Void {
   this.gotoAndStop(1);
   // d. Les vignettes s'arrêtent
   cetteBarre.arreterTout();
  }
 
  // Passer au niveau supérieur 
  niveau++;
 
  listeVignettes = new Array();
  for(var i:Number = 0; i < nbVignettes; i++) {
    cetteBarre.ajouterUneVignette(cible, niveau+i , c, i, r);
  }

  for(var i:Number = 0; i < nbVignettes; i++) {
    cetteBarre.listeVignettes[i].sAffiche(Vignette.largeur*i+nx, ny);
  }
 }
}
