﻿/*
# Apprendre à programmer en ActionScript
# A. Tasso
# Chapitre 9 : Les principes du concept objet
# Exercice : Un menu déroulant
# Fichier : Exercice 9_4.fla
# Classe : Menu.as
*/

//Définition de la classe Menu extends MovieClip
class Menu extends MovieClip {
   // Définition des attributs de la classe
   private var entete:MovieClip;
   private var listeItems:Array;
   public var estVisible:Boolean = false;



  private function aDerouler(nbr:Number):Void{
  // Le menu déroule les items et devient visible
  }

  private function aEnrouler(nbr:Number, p:Number):Void{
  // Le menu enroule les items et devient invisible (sauf l’entete)

  }

  // c. Ajoute un item dans le tableau listeItems
  function ajouterUnItem(cible:MovieClip, np:Number, rubrique:Array):Void{
    var x:Number =  entete._x;
    var y:Number =  entete._y;
    var h:Number =  entete._height;
    var profondeur:Number = np - (listeItems.length +1);
    // Le consrtucteur Item crée les items et les places sous l'entête
    var nvelItem:Item = new Item(rubrique[0], cible,  profondeur, x,y, rubrique);
    listeItems.push(nvelItem);
  }

  // Définition de la fonction constructeur 
  public function Menu(nom:String, cible:MovieClip, nx:Number, ny:Number, l:Array) {
    var ceMenu:Menu = this;
    var nbRubrique:Number = l.length;
    var profondeur =  cible.getNextHighestDepth()+nbRubrique;
    // b. Créer l'entête
    entete = cible.attachMovie("ItemMenuClp", nom+profondeur, profondeur);
    entete._x = nx;
    entete._y = ny;
    entete.labelOut.text = nom;
    
    // b. Créer la liste des items
    listeItems = new Array();
    for(var i:Number = 0; i < nbRubrique; i++) {
      ceMenu.ajouterUnItem(cible, profondeur, l[i]);
    }
  }
}
