﻿/*
# Apprendre à programmer en ActionScript
# A. Tasso
# Chapitre 9 : Les principes du concept objet
# Exercice : Un menu déroulant
# Fichier : Exercice 9_7.fla
# Classe : Item.as
*/

//Définition de la classe Item
class Item extends MovieClip{

 private var info:Array;
 private var cetItem:MovieClip;
 private var vitesse:Number = 12;
  
 
 public function afficher(yMax:Number):Void {  
  cetItem._visible=true;
  cetItem.onEnterFrame = function():Void {
     this._y +=vitesse ;
     if (this._y >=  yMax) {
         this._y =  yMax;
	 delete this.onEnterFrame;
     }
   }
 }
 
 // b. L'item devient s'efface en se déplaçant avec l'événement onEnterFrame
 public function effacer(yMin:Number):Void { 
  cetItem.onEnterFrame = function() {
     this._y -=vitesse ;
     // L'item se déplace jusqu'à yMin 
     if (this._y <=  yMin) {
	 this._y = yMin;                      
	 delete this.onEnterFrame;
         this._visible = false;
     }
   }
 }

 public function Item(nom:String, cible:MovieClip, profondeur:Number, x:Number, y:Number,  l:Array) {
 
   cetItem = cible.attachMovie("ItemMenuClp", nom+profondeur, profondeur);
   cetItem._x = x;
   cetItem._y = y;
   // La ligne suivante permet de rendre les items invisibles au moment de leur création.
   cetItem._visible = false;
   cetItem.label = l[0];
   cetItem.labelOut.text=l[0];
   cetItem.nbElt = l[1];


   cetItem.onRollOver = function():Void {
     this._alpha = 40;
   };

   cetItem.onRollOut = function():Void {
     this._alpha = 100;
   };

   cetItem.onPress = function():Void {
     trace("j'affiche les " + this.nbElt + " éléments de la rubrique " + this.label);  
   };

 }

}
 
