﻿/*
# Apprendre à programmer en ActionScript
# A. Tasso
# Chapitre 9 : Les principes du concept objet
# Exemple : L'héritage
# Fichier : CreerDesPersonnesControlees.fla
# Classe :  Lecteur.as
*/

//Définition de la classe Lecteur à partir de la classe Personne
class Lecteur extends Personne{
  
  // Définition des attributs de la classe
  private var numAbonne:String;
  private var listeLivres:Array;

  public function getNumAbonne():String {
	   return numAbonne;
  }
	
  public function getListeLivres():Array {
    return listeLivres;
  }
	
  public function setNumAbonne(n:String):Void {
    numAbonne = n;
  }

  public function setListeLivres(l1:String, l2:String, l3:String):Void {
   listeLivres = new Array(l1, l2, l3);
  }
   
  public function Lecteur( p:String, n:String, dn:String, num:String, l1:String,l2:String, l3:String) {
   super(p, n ,dn);
   setNumAbonne(num);
   setListeLivres(l1, l2, l3);
 }


 // Définition du comportement sePresente()
 public function sePresente():String {	
    var annonce:String = super.sePresente() ;
    annonce+= "\nNuméro : " + numAbonne ;
    annonce += "\nListe des livres empruntés : ";
    for(var i:Number = 0; i < listeLivres.length; i++) 
      annonce += "\n\t"+listeLivres[i];
    return annonce;
 }
}
