﻿/*
# Apprendre à programmer en ActionScript
# A. Tasso
# Chapitre 9 : Les principes du concept objet
# Exemple : Les méthodes get et set
# Fichier : CreerDesPersonnes.fla
# Classe :  Personne.as
*/

//Définition de la classe Personne
class Personne {
 // Définition des attributs de la classe
 public var prenom:String;
 public var nom:String;
 public var dateNaissance:Date;
	
 // Définition de la fonction constructeur 
 public function Personne ( p:String, n:String, j:Number, m:Number, a:Number) {
	  prenom = p;
	  nom = n
	  dateNaissance = new Date(a, m, j);
 }

 // Définition du comportement sePresente()
 public function sePresente():String {
     var age:Number = getAge()
     return "Je m'appelle " + prenom + " " + nom + "\nJ'ai " + age + " ans ";
 }
	
 // Définition de la méthode calculant l’âge de la personne
 public function getAge():Number {
    var aujourdHui:Date = new Date();
    var age:Number = 
    aujourdHui.getFullYear() - dateNaissance.getFullYear();
    return age;
 }

 //  Méthode d’accès en lecture (get)
 //  récupérer le prénom
 public function getPrenom():String {
	  return prenom;
 }
 //  récupérer le nom
 public function getNom():String {
	  return nom;
 }
 //  récupérer la date de naissance
 public function getDateNaissance():String {
	return dateNaissance.getDate()+"/" + dateNaissance.getMonth() + "/" +dateNaissance.getYear();
 }
	
 //  Méthode d’accès en écriture (set)
 //  Modifier le prénom
 public function setPrenom(p:String):Void {
    prenom = p;
 }
 // Modifier le nom
 public function setNom(n:String):Void {
    nom = n;
 }
 // Modifier la date de naissance
 public function setDateNaissance(dn:String):Void {
   var tmp:Array=new Array();
   tmp = dn.split("/",3);
   dateNaissance = new Date(tmp[2], tmp[1], tmp[0]);
 }
}