﻿/*
# Apprendre à programmer en ActionScript
# A. Tasso
# Chapitre 9 : Les principes du concept objet
# Une personne se présente avec sa photo
# Fichier : UnePersonneEtSaPhoto.fla
# Classe :  Personne.as
*/

//Définition de la classe Personne extends MovieClip
class Personne extends MovieClip {
// Définition des attributs de la classe
	private var prenom:String;
	private var nom:String;
	private var dateNaissance:Date;
        private var photo:MovieClip;
        private var cettePersonne:Personne;


 public function getPrenom():String {
	return prenom;
 }
	
 public function getNom():String {
 	return nom;
 }
	
 public function getDateNaissance():String {
	return dateNaissance.getDate()+"/" + dateNaissance.getMonth() + "/" +dateNaissance.getYear();
 }
	
 public function setPrenom(p:String):Void {
	 prenom = p;
 }
 public function setNom(n:String):Void {
	 nom = n;
 }


 public function setDateNaissance(dn:String):Void {
   var tmp:Array=new Array();
   tmp = dn.split("/",3);
   dateNaissance = new Date(tmp[2], tmp[1], tmp[0]);
   if ( ! valideDateNaissance()) { 
	  dateNaissance = new Date();
   }
 }
	
 // Définition de la fonction constructeur 
 public function Personne ( p:String, n:String, dn:String , cible :MovieClip) {
   cettePersonne = this;
   var profondeur:Number = cible.getNextHighestDepth();
   //cettePersonne.photo = cible.attachMovie("PhotoClp", p+profondeur , profondeur);
   
   cettePersonne.photo= cible.createEmptyMovieClip(p+profondeur, profondeur)
   cettePersonne.setPrenom(p);
   cettePersonne.setNom(n);
   cettePersonne.setDateNaissance(dn);
 }


 // Méthode invisible (métier) pour vérifier la validité de la date de naissance
 private function valideDateNaissance ():Boolean {	
    var aujourdHui:Date = new Date();
    var cetteAnnee:Number  = aujourdHui.getFullYear();
    var anneeNaissance:Number = dateNaissance.getFullYear();
	if (cetteAnnee  < anneeNaissance) return false;
    else return true;
 }

 // Définition du comportement sePresente()
 public function sePresente():String {
   var age:Number = cettePersonne.getAge()
   return "Je m'appelle " + cettePersonne.prenom + " " + cettePersonne.nom + "\nJ'ai " + age + " ans ";
 }
	
 // Définition de la méthode calculant l’âge de la personne
 public function getAge():Number {
    var aujourdHui:Date = new Date();
    var age:Number = aujourdHui.getFullYear() - dateNaissance.getFullYear();
    return age;
 }

 // Afficher la photo 
 public function sAffiche(nx:Number, ny:Number):Void {  
   cettePersonne.photo._x = nx;;
   cettePersonne.photo._y = ny ;
   // Créer un chargeur d'images
   var chargeurImage:MovieClipLoader = new MovieClipLoader();
   chargeurImage.loadClip("../../Photos/"+cettePersonne.prenom+".jpg", cettePersonne.photo);

   var ecouteur:Object = new Object();
   ecouteur = cettePersonne;
   chargeurImage.addListener(ecouteur);
   // Ecouter si la photo est enfin chargée
   ecouteur.onLoadInit = function(laPhoto:MovieClip):Void {
     var tmp:Personne = this;

     var cetteBulle:MovieClip;
     // Afficher la bulle d'info lorsque le curseur survole la photo
     laPhoto.onRollOver = function() {
       var niv:Number  = _parent.getNextHighestDepth();
       cetteBulle = _parent.attachMovie("BulleClp","texte"+niv, niv);  
       cetteBulle._x = this._x + 2*this._width/3;
       cetteBulle._y = this._y +this._height/4;
       cetteBulle.labelOut.text = tmp.sePresente();
     }
   
     laPhoto.onRollOut = function()  {     
       cetteBulle.removeMovieClip();
     }
   }
 }
}


