﻿/*
# Apprendre à programmer en ActionScript
# A. Tasso
# Chapitre 9 : Les principes du concept objet
# Exercice : Une barre de navigation
# Fichier : Exercice 9_11.fla
# Classe : Vignette.as 
*/

class Vignette extends MovieClip {
        private var photo:MovieClip;     
        private var numero:Number;
        private var rubrique:String;
        private var chemin:String;
        private var cetteVignette:Vignette;
        public static var largeur:Number = 70;
        private static var vitesseVignette:Number = 6;
        private static var niveauCadre = 6000;
	
 // Définition de la fonction constructeur 
 public function Vignette( cible:MovieClip, p:Number, c:String, n:Number, r:String) {
   cetteVignette = this;
   cetteVignette.photo = cible.attachMovie("FondVignetteClp", "vignette"+p , p);
   cetteVignette.numero = n;
   cetteVignette.rubrique = r;
   cetteVignette.chemin = c;
 
 }
 // e. Pour arrêter une vignette
 public function arreterLeDeplacement():Void {
  delete this.photo.onEnterFrame;
 }

 // c. Une vignette se déplace vers la gauche en fonction de sa position dans la barre
 public function seDeplaceAGauche(numVignette:Number,btnG:MovieClip, btnD:MovieClip, lm:Number, ltv:Number ):Void {
   this.photo.onEnterFrame = function():Void {
     if (this._x < 0) 
        btnG._visible = true;
     if (this._x <= lm - ltv + numVignette*largeur ) {
	 delete this.onEnterFrame;
	 this._x  = lm - ltv+ numVignette*largeur ;
	 btnD._visible = false;
      }
      else {
         this._x -= vitesseVignette;
      }
    } // fin onEnterFrame

 }

// c. Une vignette se déplace vers la droite en fonction de sa position dans la barre
 public function seDeplaceADroite(numVignette:Number,btnG:MovieClip, btnD:MovieClip, lm:Number, ltv:Number ):Void {
   this.photo.onEnterFrame = function():Void {
     if (this._x < 0) btnD._visible = true;
     if (this._x >  largeur*numVignette ) {
	  delete this.onEnterFrame;
	  this._x  = largeur*numVignette;
          btnG._visible = false;
     }
     else {
        this._x += vitesseVignette;
     }
   } // fin onEnterFrame

 }

 public function sAffiche(nx:Number, ny:Number):Void {
   cetteVignette .photo._x = nx;;
   cetteVignette.photo._y = ny ;


   var chargeurImage:MovieClipLoader = new MovieClipLoader();
   chargeurImage.loadClip(cetteVignette.chemin+"Vignette"+cetteVignette.numero+".jpg", cetteVignette.photo);

   var ecouteur:Object = new Object();
   ecouteur = cetteVignette;
   chargeurImage.addListener(ecouteur);

   ecouteur.onLoadInit = function(laPhoto:MovieClip):Void {
     var tmp:Vignette = this;
     var cadre:MovieClip;
     laPhoto.onRollOver = function():Void {
       cadre = _parent.attachMovie("BordVignetteClp","cadre", niveauCadre);  
       cadre._x = this._x ;
       cadre._y = this._y ; 
       this._alpha = 80;
     }
     laPhoto.onPress = function():Void {
        trace("Photo : " + tmp.chemin+tmp.rubrique+tmp.numero);
     }
     laPhoto.onRollOut = function():Void  {     
       cadre.removeMovieClip();   
       this._alpha = 100;
     }
   }
 }

}
