﻿/*
# Apprendre à programmer en ActionScript
# A. Tasso
# Chapitre 9 : Les principes du concept objet
# Exercice : Un menu déroulant
# Fichier : Exercice 9_5.fla
# Classe : Menu.as 
*/
//Définition de la classe Menu extends MovieClip
class Menu extends MovieClip {
// Définition des attributs de la classe
	private var entete:MovieClip;
        private var listeItems:Array;
        public var estVisible:Boolean = false;
  
  private function aDerouler(nbr:Number):Void{
    // Le menu déroule les items et devient visible
    // c. afficher "je me déroule" dans la fenêtre de sortie
    trace("Je me déroule");
  }

  private function aEnrouler(nbr:Number, p:Number):Void{
    // Le menu enroule les items et devient invisible (sauf l’entete) 
    // c. afficher "je m'enroule" dans la fenêtre de sortie
    trace("Je m'enroule");
  }

  function ajouterUnItem(cible:MovieClip, np:Number, rubrique:Array):Void{ 
    var x:Number =  entete._x;
    var y:Number =  entete._y;
    var h:Number =  entete._height;

    var profondeur:Number = np - (listeItems.length +1);
    var nvelItem:Item = new Item(rubrique[0], cible,  profondeur, x,y, rubrique);
    listeItems.push(nvelItem);
  }

  // Définition de la fonction constructeur 
  public function Menu(nom:String, cible:MovieClip, nx:Number, ny:Number, l:Array) {
    var ceMenu:Menu = this;
    var nbRubrique:Number = l.length;
    var profondeur =  cible.getNextHighestDepth()+nbRubrique;
    entete = cible.attachMovie("ItemMenuClp", nom+profondeur, profondeur);
    entete._x = nx;
    entete._y = ny;
    entete.labelOut.text = nom;
  
    listeItems = new Array();
    for(var i:Number = 0; i < nbRubrique; i++) {
      ceMenu.ajouterUnItem(cible, profondeur, l[i]);
    }
    entete.onPress = function():Void {
     // b. Si le menu est invisible, le dérouler
     if( !ceMenu.estVisible) {
        ceMenu.aDerouler(nbRubrique, ceMenu);
        // Changer l'état du drapeau estVisible
        ceMenu.estVisible = true;
     }
     // b. Si le menu est visible, l'enrouler
     else {
       ceMenu.aEnrouler(nbRubrique, ny);
       // Changer l'état du drapeau estVisible
       ceMenu.estVisible = false;
     } 
    }

    // a. Au survol de la souris, l'entete devient plus transparent
    entete.onRollOver = function():Void {
     this._alpha = 40;
    }
    // b. L'entete reprend sa couleur initiale
    entete.onRollOut = function():Void {
     this._alpha = 100;
    }
  }

}
