﻿/*
# Apprendre à programmer en ActionScript
# A. Tasso
# Chapitre 9 : Les principes du concept objet
# Exercice : Un menu déroulant
# Fichier : Exercice 9_7.fla
# Classe : Menu.as
*/

//Définition de la classe Menu extends MovieClip
class Menu extends MovieClip {
// Définition des attributs de la classe
	private var entete:MovieClip;
        private var listeItems:Array;
        public var estVisible:Boolean = false;


  private function aDerouler(nbr:Number):Void{
     // Le menu déroule les items et devient visible 
    var x:Number =  entete._x;
    var y:Number =  entete._y;
    var h:Number =  entete._height;
    for(var i:Number = 0; i < nbr; i++) {
      listeItems[i].afficher(h*(i+1)+y );
    }
   }

  private function aEnrouler(nbr:Number, p:Number):Void{
    // Le menu enroule les items et devient invisible (sauf l’entete)  
    var x:Number =  entete._x;
    var y:Number =  entete._y;
    var h:Number =  entete._height;

    for(var i:Number = 0; i < nbr ; i++){
     // a. Chaque item s'efface en se plaçant sous l'entête
     listeItems[i].effacer(y);
    }
  }


  function ajouterUnItem(cible:MovieClip, np:Number, rubrique:Array):Void{ 
    var x:Number =  entete._x;
    var y:Number =  entete._y;
    var h:Number =  entete._height;

    var profondeur:Number = np - (listeItems.length +1);
    var nvelItem:Item = new Item(rubrique[0], cible,  profondeur, x,y, rubrique);
    listeItems.push(nvelItem);
  }

  // Définition de la fonction constructeur 
  public function Menu(nom:String, cible:MovieClip, nx:Number, ny:Number, l:Array) {
    var ceMenu:Menu = this;
    var nbRubrique:Number = l.length;
    var profondeur =  cible.getNextHighestDepth()+nbRubrique;
    entete = cible.attachMovie("ItemMenuClp", nom+profondeur, profondeur);
    entete._x = nx;
    entete._y = ny;
    entete.labelOut.text = nom;
  
    listeItems = new Array();
    for(var i:Number = 0; i < nbRubrique; i++) {
      ceMenu.ajouterUnItem(cible, profondeur, l[i]);
    }
    entete.onPress = function():Void {
     if( !ceMenu.estVisible) {
        ceMenu.aDerouler(nbRubrique, ceMenu);
        ceMenu.estVisible = true;
     }
     else {
       ceMenu.aEnrouler(nbRubrique, ny);
       ceMenu.estVisible = false;
     } 
    }

    entete.onRollOver = function():Void {
     this._alpha = 40;
    }

    entete.onRollOut = function():Void {
     this._alpha = 100;
    }
  }

}
