﻿/*
# Apprendre à programmer en ActionScript
# A. Tasso
# Chapitre 9 : Les principes du concept objet
# Exercice : Un menu déroulant
# Fichier : Exercice 9_7.fla
# Classe : Menu.as
*/

//Définition de la classe Menu extends MovieClip
class Menu extends MovieClip {
// Définition des attributs de la classe
	private var entete:MovieClip;
        private var listeItems:Array;
        public var estVisible:Boolean = false;


  private function aDerouler(nbr:Number):Void{
     // Le menu déroule les items et devient visible 
    var x:Number =  entete._x;
    var y:Number =  entete._y;
    var h:Number =  entete._height;
    for(var i:Number = 0; i < nbr; i++) {
      listeItems[i].afficher(h*(i+1)+y );
    }
   }

  private function aEnrouler(nbr:Number, p:Number):Void{
    // Le menu enroule les items et devient invisible (sauf l’entete)  
    var x:Number =  entete._x;
    var y:Number =  entete._y;
    var h:Number =  entete._height;

    for(var i:Number = 0; i < nbr ; i++){
     listeItems[i].effacer(y);
    }
  }


  function ajouterUnItem(cible:MovieClip, np:Number, rubrique:Array):Void{ 
    var x:Number =  entete._x;
    var y:Number =  entete._y;
    var h:Number =  entete._height;

    var profondeur:Number = np - (listeItems.length +1);
    var nvelItem:Item = new Item(rubrique[0], cible,  profondeur, x,y, rubrique);
    listeItems.push(nvelItem);
  }

  // Définition de la fonction constructeur 
  public function Menu(nom:String, cible:MovieClip, nx:Number, ny:Number, l:Array) {
    var ceMenu:Menu = this;
    // Le menu écoute les événements de la souris
    Mouse.addListener(ceMenu);
    var nbRubrique:Number = l.length;
    var profondeur =  cible.getNextHighestDepth()+nbRubrique;
    // Au début, l'entête n'a pas été cliquée
    var clicSurEntete:Boolean = false;

    entete = cible.attachMovie("ItemMenuClp", nom+profondeur, profondeur);
    entete._x = nx;
    entete._y = ny;
    entete.labelOut.text = nom;
  
    listeItems = new Array();
    for(var i:Number = 0; i < nbRubrique; i++) {
      ceMenu.ajouterUnItem(cible, profondeur, l[i]);
    }



    entete.onPress = function():Void {
     // Si on clic sur l'entete le menu devient visible
     if(clicSurEntete) {
        ceMenu.estVisible = true;
        // On modifie l'état clicSurEntete
        clicSurEntete = false; 
     }
     // Sinon on modifie l'état clicSurEntete
     else clicSurEntete = true;
     // Si le menu n'est pas visible
     if( !ceMenu.estVisible) {
        // Le dérouler
        ceMenu.aDerouler(nbRubrique);
        ceMenu.estVisible = true;
     }
     // Si le menu est visible
     else {
       // L'enrouler
       ceMenu.aEnrouler(nbRubrique, ny);
       ceMenu.estVisible = false;
     }
    
    }

    entete.onRollOver = function():Void {
     this._alpha = 40;
    }

    entete.onRollOut = function():Void {
     this._alpha = 100;
    }
    // Lorsque le menu perçoit une touche enfoncée sur la souris
    ceMenu.onMouseDown = function():Void {
      // Pour effacer le menu alors que l'on clique sur l'entete d'un autre menu
      if(!this.estVisible && clicSurEntete) clicSurEntete = false;
      this.aEnrouler(nbRubrique, ny);
      this.estVisible = false;
  };
  }

}
