﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Content;

namespace ChapitreDix
{
    class Asteroid : Sprite
    {
        Vector2 speed = Vector2.Zero;
        static Random random = new Random(DateTime.Now.Millisecond);

        public Asteroid(ContentManager content)
            : base(Vector2.Zero)
        {
            base.LoadContent(content, "asteroid");
            Initialize();
        }

        private void Initialize()
        {
            Position = new Vector2(random.Next(0, Chapitre10.SCREEN_WIDTH - Texture.Width), -Texture.Height);
            speed = new Vector2((float)random.Next(-7, 7) / 10, (float)random.Next(1, 7) / 10);
        }

        public void Update(GameTime gameTime)
        {           
            Position = new Vector2(Position.X + (speed.X * gameTime.ElapsedGameTime.Milliseconds), Position.Y + (speed.Y * gameTime.ElapsedGameTime.Milliseconds));

            if (Position.X + Texture.Width < 0)
                Initialize();

            if (Position.X > Chapitre10.SCREEN_WIDTH)
                Initialize();

            if (Position.Y > Chapitre10.SCREEN_HEIGHT)
                Initialize();
        }
    }
}
