﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace ChapitreDix
{
    public class Chapitre10 : Microsoft.Xna.Framework.Game
    {
        public static int SCREEN_WIDTH = 512;
        public static int SCREEN_HEIGHT = 748;
        static int NEW_ASTEROID_TIME = 5;

        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        Player playerShip;
        List<Asteroid> asteroids = new List<Asteroid>();

        TimeSpan elapsedTimeSinceLastNewAsteroid = TimeSpan.Zero;

        public Chapitre10()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
            ServiceHelper.Game = this;
            Components.Add(new KeyboardService(this));
            graphics.PreferredBackBufferHeight = SCREEN_HEIGHT;
            graphics.PreferredBackBufferWidth = SCREEN_WIDTH;
        }

        protected override void Initialize()
        {
            playerShip = new Player();

            base.Initialize();
        }

        protected override void LoadContent()
        {
            spriteBatch = new SpriteBatch(GraphicsDevice);

            playerShip.LoadContent(Content, "ship");
            playerShip.ResetPosition();
        }

        protected override void Update(GameTime gameTime)
        {
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            playerShip.Update(gameTime);

            foreach (Asteroid asteroid in asteroids)
            {
                asteroid.Update(gameTime);
                if (playerShip.Rectangle.Intersects(asteroid.Rectangle) && CollisionPerPixels(playerShip, asteroid))
                {
                    playerShip.ResetPosition();
                    asteroids.Clear();
                    break;
                }
            }

            elapsedTimeSinceLastNewAsteroid += gameTime.ElapsedGameTime;

            if (elapsedTimeSinceLastNewAsteroid.Seconds >= NEW_ASTEROID_TIME)
            {
                asteroids.Add(new Asteroid(Content));
                elapsedTimeSinceLastNewAsteroid = TimeSpan.Zero;
            }

            base.Update(gameTime);
        }

        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.Black);

            spriteBatch.Begin();
            playerShip.Draw(spriteBatch);
            foreach (Asteroid asteroid in asteroids)
                asteroid.Draw(spriteBatch);
            spriteBatch.End();

            base.Draw(gameTime);
        }

        protected bool CollisionPerPixels(Sprite spriteA, Sprite spriteB)			
        {
            int top = Math.Max(spriteA.Rectangle.Top, spriteB.Rectangle.Top);
            int bottom = Math.Min(spriteA.Rectangle.Bottom, spriteB.Rectangle.Bottom);
            int left = Math.Max(spriteA.Rectangle.Left, spriteB.Rectangle.Left);
            int right = Math.Min(spriteA.Rectangle.Right, spriteB.Rectangle.Right);	

            for (int y = top; y < bottom; y++)
            {
                for (int x = left; x < right; x++)
                {
                    Color colorA = spriteA.TextureData[(x - spriteA.Rectangle.Left) +
                                (y - spriteA.Rectangle.Top) * spriteA.Rectangle.Width];
                    Color colorB = spriteB.TextureData[(x - spriteB.Rectangle.Left) +
                                (y - spriteB.Rectangle.Top) * spriteB.Rectangle.Width];

                    if (colorA.A != 0 && colorB.A != 0)
                        return true;
                }
            }

            return false;
        }
    }
}
