﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;

namespace ChapitreDix
{
    class Player : Sprite
    {
        public Player()
            : base(Vector2.Zero)
        {
        }

        public void Update(GameTime gameTime)
        {
            if(ServiceHelper.Get<IKeyboardService>().IsKeyDown(Keys.Up))
                Position = new Vector2(Position.X, Position.Y - (float)(0.4 * gameTime.ElapsedGameTime.Milliseconds));

            if (ServiceHelper.Get<IKeyboardService>().IsKeyDown(Keys.Down))
                Position = new Vector2(Position.X, Position.Y + (float)(0.2 * gameTime.ElapsedGameTime.Milliseconds));

            if (ServiceHelper.Get<IKeyboardService>().IsKeyDown(Keys.Left))
                Position = new Vector2(Position.X - (float)(0.3 * gameTime.ElapsedGameTime.Milliseconds), Position.Y);

            if (ServiceHelper.Get<IKeyboardService>().IsKeyDown(Keys.Right))
                Position = new Vector2(Position.X + (float)(0.3 * gameTime.ElapsedGameTime.Milliseconds), Position.Y);

            if (Position.X < 0)
                Position = new Vector2(0, Position.Y);

            if (Position.X + Texture.Width > Chapitre10.SCREEN_WIDTH)
                Position = new Vector2(Chapitre10.SCREEN_WIDTH - Texture.Width, Position.Y);

            if (Position.Y < 0)
                Position = new Vector2(Position.X, 0);

            if (Position.Y + Texture.Height > Chapitre10.SCREEN_HEIGHT)
                Position = new Vector2(Position.X, Chapitre10.SCREEN_HEIGHT - Texture.Height);
        }

        public void ResetPosition()
        {
            Position = new Vector2(Chapitre10.SCREEN_WIDTH / 2 - (Texture.Width / 2), 9 * (Chapitre10.SCREEN_HEIGHT / 10) - Texture.Height);
        }
    }
}
