﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Content;
using FarseerGames.FarseerPhysics;
using FarseerGames.FarseerPhysics.Factories;
using FarseerGames.FarseerPhysics.Dynamics;
using FarseerGames.FarseerPhysics.Collisions;

namespace ChapitreDix_2
{
    class Asteroid : Sprite
    {
        static Random random = new Random(DateTime.Now.Millisecond);

        Body body;

        public Asteroid(PhysicsSimulator physicsSimulator, ContentManager content)
            : base(Vector2.Zero)
        {
            base.LoadContent(content, "asteroid2");
            body = BodyFactory.Instance.CreateRectangleBody(physicsSimulator, 32, 32, 1);
            Origin = new Vector2(Texture.Width / 2, Texture.Height / 2);
            GeomFactory.Instance.CreateRectangleGeom(physicsSimulator, body, 32, 32).CollisionResponseEnabled = true;
            Initialize();
        }

        private void Initialize()
        {
            body.Position = new Vector2(random.Next(0, Chapitre10_2.SCREEN_WIDTH - Texture.Width), -Texture.Height);
            body.ApplyForce(new Vector2(random.Next(-3, 3) * 1000, random.Next(-3, 3) * 1000));
            body.ApplyForceAtLocalPoint(new Vector2(random.Next(-3, 3) * 100, random.Next(-3, 3) * 100), new Vector2(random.Next(0, Texture.Width), random.Next(0, Texture.Height)));
            Position = body.Position;
            Rotation = body.Rotation;
        }

        public void Update(GameTime gameTime)
        {
            Position = body.Position;
            Rotation = body.Rotation;

            if (body.Position.X > Chapitre10_2.SCREEN_WIDTH + (2 * Texture.Width))
                body.Position = new Vector2(-Texture.Width, body.Position.Y);

            if (body.Position.X < 0 - (2 * Texture.Width))
                body.Position = new Vector2(Chapitre10_2.SCREEN_WIDTH + Texture.Width, body.Position.Y);

            if (body.Position.Y > Chapitre10_2.SCREEN_HEIGHT + (2 * Texture.Height))
                body.Position = new Vector2(body.Position.X, -Texture.Height);

            if (body.Position.Y < 0 - (2 * Texture.Height))
                body.Position = new Vector2(body.Position.X, Chapitre10_2.SCREEN_HEIGHT + Texture.Height);
        }
    }
}
