﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;
using FarseerGames.FarseerPhysics;
using FarseerGames.FarseerPhysics.Dynamics;
using FarseerGames.FarseerPhysics.Factories;

namespace ChapitreDix_2
{
    public class Chapitre10_2 : Microsoft.Xna.Framework.Game
    {
        public static int SCREEN_WIDTH = 512;
        public static int SCREEN_HEIGHT = 748;
        static int NEW_ASTEROID_TIME = 5;

        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;
        PhysicsSimulator physicsSimulator;

        Player ship;
        List<Asteroid> asteroids = new List<Asteroid>();

        TimeSpan elapsedTimeSinceLastNewAsteroid = TimeSpan.Zero;

        public Chapitre10_2()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
            ServiceHelper.Game = this;
            Components.Add(new KeyboardService(this));
            graphics.PreferredBackBufferHeight = SCREEN_HEIGHT;
            graphics.PreferredBackBufferWidth = SCREEN_WIDTH;
        }

        protected override void Initialize()
        {
            physicsSimulator = new PhysicsSimulator();
            ship = new Player(physicsSimulator);
            ship.ShipDestroyed += new Player.ShipDestroyedEventHandler(ship_ShipHasExploded);
            base.Initialize();
        }

        protected override void LoadContent()
        {
            spriteBatch = new SpriteBatch(GraphicsDevice);
            ship.LoadContent(Content, "ship2");
            ship.ResetPosition();
        }

        protected override void Update(GameTime gameTime)
        {
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            physicsSimulator.Update(gameTime.ElapsedGameTime.Milliseconds * 0.001f);

            ship.Update(gameTime);

            foreach (Asteroid asteroid in asteroids)
                asteroid.Update(gameTime);

            elapsedTimeSinceLastNewAsteroid += gameTime.ElapsedGameTime;

            if (elapsedTimeSinceLastNewAsteroid.Seconds >= NEW_ASTEROID_TIME)
            {
                asteroids.Add(new Asteroid(physicsSimulator, Content));
                elapsedTimeSinceLastNewAsteroid = TimeSpan.Zero;
            }

            base.Update(gameTime);
        }

        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.Black);

            spriteBatch.Begin();
            ship.Draw(spriteBatch);
            foreach(Asteroid asteroid in asteroids)
                asteroid.Draw(spriteBatch);
            spriteBatch.End();

            base.Draw(gameTime);
        }

        void ship_ShipHasExploded()
        {
            asteroids.Clear();
        }
    }
}
