﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using FarseerGames.FarseerPhysics;
using FarseerGames.FarseerPhysics.Factories;
using FarseerGames.FarseerPhysics.Dynamics;
using FarseerGames.FarseerPhysics.Collisions;

namespace ChapitreDix_2
{
    class Player : Sprite
    {
        Body body;
        public delegate void ShipDestroyedEventHandler();
        public event ShipDestroyedEventHandler ShipDestroyed;

        public Player(PhysicsSimulator physicsSimulator)
            : base(Vector2.Zero)
        {
            body = BodyFactory.Instance.CreateRectangleBody(physicsSimulator, 32, 32, 1);
            GeomFactory.Instance.CreateRectangleGeom(physicsSimulator, body, 32, 32).OnCollision += new Geom.CollisionEventHandler(CollisionOccurs);
        }

        public void Update(GameTime gameTime)
        {
            Position = body.Position;
            Rotation = body.Rotation;

            if (ServiceHelper.Get<IKeyboardService>().IsKeyDown(Keys.Left))
                body.Rotation -= 0.05f;

            if (ServiceHelper.Get<IKeyboardService>().IsKeyDown(Keys.Right))
                body.Rotation += 0.05f;

            if (ServiceHelper.Get<IKeyboardService>().IsKeyDown(Keys.Up))
                body.ApplyForce(new Vector2((float)Math.Sin(body.Rotation) * 100, (float)Math.Cos(body.Rotation) * -100));

            if (ServiceHelper.Get<IKeyboardService>().IsKeyDown(Keys.Down))
                body.ApplyForce(new Vector2((float)Math.Sin(body.Rotation) * -100, (float)Math.Cos(body.Rotation) * 100));

            if (body.Position.X > Chapitre10_2.SCREEN_WIDTH + (2 * Texture.Width))
                body.Position = new Vector2(-Texture.Width, body.Position.Y);

            if (body.Position.X < 0 - (2 * Texture.Width))
                body.Position = new Vector2(Chapitre10_2.SCREEN_WIDTH + Texture.Width, body.Position.Y);

            if (body.Position.Y > Chapitre10_2.SCREEN_HEIGHT + (2 * Texture.Height))
                body.Position = new Vector2(body.Position.X, -Texture.Height);

            if (body.Position.Y < 0 - (2 * Texture.Height))
                body.Position = new Vector2(body.Position.X, Chapitre10_2.SCREEN_HEIGHT + Texture.Height);
        }

        public void ResetPosition()
        {
            body.ResetDynamics();
            body.Position = new Vector2(Chapitre10_2.SCREEN_WIDTH / 2 - (Texture.Width / 2), 9 * (Chapitre10_2.SCREEN_HEIGHT / 10) - Texture.Height);
            Position = body.Position;
            body.Rotation = 0;
            Rotation = body.Rotation;
            Origin = new Vector2(Texture.Width / 2, Texture.Height / 2);
        }

        private bool CollisionOccurs(Geom geomA, Geom geomB, ContactList contactList)
        {
            ResetPosition();
            ShipDestroyed();
            return true;
        }
    }
}
