<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!-- Display a documentation file generated by Visual Studio from XML comments. -->
	<!-- Copyright 2008 by Gary Gocek. -->
	<!-- Tested with C# and VS 2005 and VS 2003 -->
	<!-- Set a var with the name of the assembly for the documented project. -->
	<xsl:variable name="myAssembly"><xsl:value-of select="doc/assembly/name"/></xsl:variable>
	<xsl:template match="doc">
		<HTML>
			<HEAD>
				<TITLE>Visual Studio XML Documentation Stylesheet v20080509</TITLE>
			</HEAD>
			<BODY>
				<center><b><u><xsl:value-of select="$myAssembly"/> documentation</u></b></center>
				<p/>
				<xsl:apply-templates select="members"/>
			</BODY>
		</HTML>
	</xsl:template>

	<!-- All the classes and methods are grouped under members -->
	<xsl:template match="members">
		<xsl:apply-templates select="member"/>
	</xsl:template>

	<!-- Show a member - a class, method, property, etc. -->
	<xsl:template match="member">
		<!-- The whole name has the namespace, class name, and member name. -->
		<xsl:variable name="myWholeName"><xsl:value-of select="@name"/></xsl:variable>
		<!-- The class name, method, and args follow the period after the assembly name. -->
		<xsl:variable name="myClassMethodsArgs">
			<xsl:value-of select="substring-after($myWholeName,concat($myAssembly,'.'))"/>
		</xsl:variable>
		<!-- If there is no dot within myClassMethodArgs, then all we have is the class name. -->
		<!-- Otherwise, there is one dot between the class and method. -->
		<xsl:variable name="myClass">
			<xsl:if test="contains($myClassMethodsArgs,'.')">
				<xsl:value-of select="substring-before($myClassMethodsArgs,'.')"/>
			</xsl:if>
			<xsl:if test="not(contains($myClassMethodsArgs,'.'))">
				<xsl:value-of select="$myClassMethodsArgs"/>
			</xsl:if>
		</xsl:variable>
		<!-- If there is no dot within myClassMethodArgs, use the class name as the method name. -->
		<xsl:variable name="myMethodArgs">
			<xsl:if test="contains($myClassMethodsArgs,'.')">
				<xsl:value-of select="substring-after($myClassMethodsArgs,'.')"/>
			</xsl:if>
			<xsl:if test="not(contains($myClassMethodsArgs,'.'))">
				<xsl:value-of select="$myClassMethodsArgs"/>
			</xsl:if>
		</xsl:variable>

		<!-- Show the names. Append () to method names with no args. -->
		<font color="red"><xsl:value-of select="$myClass"/></font><br/>
		<b><big><big><code>  
			<xsl:if test="contains($myWholeName,'M:') and contains($myWholeName,'(')">
				<xsl:value-of select="$myMethodArgs"/>
			</xsl:if>
			<xsl:if test="contains($myWholeName,'M:') and not(contains($myWholeName,'('))">
				<xsl:value-of select="concat($myMethodArgs,'()')"/>
			</xsl:if>
			<xsl:if test="not(contains($myWholeName,'M:'))">
				<xsl:value-of select="$myMethodArgs"/>
			</xsl:if>
		</code></big></big></b><br/>

		<xsl:apply-templates select="summary"/>
		<xsl:apply-templates select="param"/>
		<xsl:apply-templates select="returns"/>
		<xsl:apply-templates select="exception"/>
		<p/>
	</xsl:template>

	<xsl:template match="summary">
		<!-- Show the summary. -->
		<i>* Summary: </i><xsl:value-of select="."/><br/>
	</xsl:template>

	<xsl:template match="param">
		<!-- Show the param names in blue. -->
		<i>* Param: </i> <b><font color="blue"><code><xsl:value-of select="@name"/></code></font>: </b> <xsl:value-of select="."/><br/>
	</xsl:template>

	<xsl:template match="returns">
		<!-- Show the returns. Note that the XML file does not provide the actual datatype that is returned,
			so it can be helpful to include that in the returns comment. -->
		<i>* Returns: </i><xsl:value-of select="."/><br/>
	</xsl:template>

	<xsl:template match="exception">
		<!-- Show the exceptions. -->
		<i>* Exception: </i>(<xsl:value-of select="@cref"/>) <xsl:value-of select="."/><br/>
	</xsl:template>
</xsl:stylesheet>