﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;
using System.Diagnostics;

namespace ChapitreNeuf
{
    public class Chapitre9 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        Map map;
        Hero heros;

        public Chapitre9()
        {
            graphics = new GraphicsDeviceManager(this);
            ServiceHelper.Game = this;
            Components.Add(new MouseService(this));
            Content.RootDirectory = "Content";

            map = new Map(new byte[,] { {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 1, 1, 0}
                                      , {0, 1, 1, 1, 1, 1, 0, 1, 0, 0, 2, 0, 0, 0, 0, 0, 1, 0}
                                      , {0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 2, 0, 0, 0, 0, 0, 0, 0}
                                      , {0, 0, 1, 1, 0, 1, 0, 1, 0, 1, 2, 1, 1, 1, 1, 0, 0, 0}
                                      , {0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 2, 2, 0, 0, 1, 0, 1, 0}
                                      , {1, 1, 0, 1, 0, 1, 1, 1, 0, 1, 1, 2, 0, 0, 1, 0, 1, 0}
                                      , {0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, 0}
                                      , {0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 2, 0, 1, 0, 1, 1}
                                      , {0, 0, 0, 1, 0, 1, 0, 0, 3, 3, 0, 1, 2, 0, 0, 0, 0, 1}
                                      , {0, 0, 0, 1, 0, 1, 1, 3, 3, 1, 1, 1, 2, 0, 1, 0, 0, 1}
                                      , {0, 0, 0, 1, 0, 0, 1, 3, 3, 3, 3, 2, 2, 0, 1, 1, 0, 1}
                                      , {0, 0, 0, 1, 0, 0, 1, 3, 3, 3, 3, 2, 1, 1, 1, 0, 0, 0}
                                      , {0, 0, 0, 1, 0, 0, 0, 3, 1, 1, 3, 2, 0, 0, 1, 0, 0, 0}
                                      , {0, 0, 0, 1, 0, 0, 3, 3, 1, 1, 3, 2, 0, 0, 0, 0, 0, 0}});
            
            graphics.PreferredBackBufferWidth = map.TileList.GetLength(1) * 32;
            graphics.PreferredBackBufferHeight = map.TileList.GetLength(0) * 32;
            IsMouseVisible = true;
        }

        protected override void Initialize()
        {
            heros = new Hero(13, 0, 4);

            base.Initialize();
        }

        protected override void LoadContent()
        {
            spriteBatch = new SpriteBatch(GraphicsDevice);

            foreach (Tile tile in map.TileList)
            {
                tile.LoadContent(Content, "tile");
            }
            heros.LoadContent(Content, "tile");
        }

        protected override void Update(GameTime gameTime)
        {
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            if (ServiceHelper.Get<IMouseService>().LeftButtonHasBeenPressed())
            {
                if (heros.X != ((int)ServiceHelper.Get<IMouseService>().GetCoordinates().X / 32) || heros.Y != ((int)ServiceHelper.Get<IMouseService>().GetCoordinates().Y / 32))
                heros.WalkingList = Pathfinding.CalculatePathWithAStar(map, heros, map.TileList[(int)ServiceHelper.Get<IMouseService>().GetCoordinates().Y / 32,(int)ServiceHelper.Get<IMouseService>().GetCoordinates().X / 32]);
            }

            heros.Update(gameTime);
            base.Update(gameTime);
        }

        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.Black);

            spriteBatch.Begin();
            map.Draw(spriteBatch);
            heros.Draw(spriteBatch);
            spriteBatch.End();

            base.Draw(gameTime);
        }
    }
}
