﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;

namespace ChapitreNeuf
{
    class Hero : Tile
    {
        int msElapsed = 0;

        List<Tile> walkingList = new List<Tile>();

        public List<Tile> WalkingList
        {
            set { if (value != null) walkingList = value; }
        }

        public Hero(int y, int x, byte type)
            : base(y, x, type)
        {
        }

        public void Update(GameTime gameTime)
        {
            msElapsed += gameTime.ElapsedGameTime.Milliseconds;

            if (walkingList.Count != 0)
            {
                if (msElapsed >= 100)
                {
                    msElapsed = 0;
                    X = walkingList[walkingList.Count - 1].X;
                    Y = walkingList[walkingList.Count - 1].Y;
                    Position = walkingList[walkingList.Count - 1].Position;
                    walkingList.RemoveAt(walkingList.Count - 1);
                }
            }
        }
    }
}
