﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Graphics;

namespace ChapitreNeuf
{
    class Pathfinding
    {
        public static List<Tile> CalculatePathWithAStar(Map map, Tile startTile, Tile endTile)
        {
            List<Tile> result = new List<Tile>();
            NodeList<Node> openList = new NodeList<Node>();
            NodeList<Node> closedList = new NodeList<Node>();
            List<Node> possibleNodes;
            int possibleNodesCount;

            Node startNode = new Node(startTile, null, endTile);

            openList.Add(startNode);

            while (openList.Count > 0)
            {
                Node current = openList[0];
                openList.RemoveAt(0);
                closedList.Add(current);

                if (current.Tile == endTile)
                {
                    List<Tile> sol = new List<Tile>();
                    while (current.Parent != null)
                    {
                        sol.Add(current.Tile);
                        current = current.Parent;
                    }
                    return sol;
                }

                possibleNodes = current.GetPossibleNode(map, endTile);
                possibleNodesCount = possibleNodes.Count;
                for (int i = 0; i < possibleNodesCount; i++)
                {
                    if (!closedList.Contains(possibleNodes[i]))
                    {
                        if (openList.Contains(possibleNodes[i]))
                        {
                            if (possibleNodes[i].EstimatedMovement < openList[possibleNodes[i]].EstimatedMovement)
                                openList[possibleNodes[i]].Parent = current;
                        }
                        else
                            openList.DichotomicInsertion(possibleNodes[i]);
                    }
                }
            }
            return null;
        }
    }
}
