﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace ChapitreQuatre
{
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;
        Sprite sprite;
        float speed = 0.1f;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            this.graphics.ToggleFullScreen();
            Content.RootDirectory = "Content";
            ServiceHelper.Game = this;
            Components.Add(new KeyboardService(this));
            sprite = new Sprite(300, 200);
        }

        protected override void Initialize()
        {
            base.Initialize();
        }

        protected override void LoadContent()
        {
            spriteBatch = new SpriteBatch(GraphicsDevice);
            sprite.LoadContent(Content, "GameThumbnail");
        }

        protected override void UnloadContent()
        {
        }

        protected override void Update(GameTime gameTime)
        {
            if (ServiceHelper.Get<IKeyboardService>().IsKeyDown(Keys.Escape))
                this.Exit();

            if(ServiceHelper.Get<IKeyboardService>().IsKeyDown(Keys.Up))
                sprite.Update(new Vector2(0, -1 * gameTime.ElapsedGameTime.Milliseconds * speed));

            if (ServiceHelper.Get<IKeyboardService>().IsKeyDown(Keys.Down))
                sprite.Update(new Vector2(0, 1 * gameTime.ElapsedGameTime.Milliseconds * speed));

            if (ServiceHelper.Get<IKeyboardService>().IsKeyDown(Keys.Left))
                sprite.Update(new Vector2(-1 * gameTime.ElapsedGameTime.Milliseconds * speed, 0));

            if (ServiceHelper.Get<IKeyboardService>().IsKeyDown(Keys.Right))
                sprite.Update(new Vector2(1 * gameTime.ElapsedGameTime.Milliseconds * speed, 0));

            base.Update(gameTime);
        }

        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.CornflowerBlue);
            spriteBatch.Begin();
            sprite.Draw(spriteBatch);
            spriteBatch.End();
            base.Draw(gameTime);
        }
    }
}
