﻿using System.Collections.Generic;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace ComparaisonPerf
{
    class TextureManager
    {
        Dictionary<string, Texture2D> textureBank = new Dictionary<string, Texture2D>();

        ContentManager content;

        public TextureManager(ContentManager content)
        {
            this.content = content;
        }

        public Texture2D GetTexture(string assetName)
        {
            if (textureBank.ContainsKey(assetName))
                return textureBank[assetName];
            else
            {
                textureBank.Add(assetName, content.Load<Texture2D>(assetName));
                return textureBank[assetName];
            }
        }
    }
}
