﻿using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace Pong
{
    class Background : DrawableGameComponent
    {
        Sprite sprite;
        SpriteBatch spriteBatch;

        public Background(Game game)
            : base(game)
        {
        }

        public override void Initialize()
        {
            sprite = new Sprite(new Vector2(0, 0));
            spriteBatch = new SpriteBatch(Game.GraphicsDevice);
            base.Initialize();
        }

        protected override void LoadContent()
        {
            sprite.LoadContent(Game.Content, "back");
            base.LoadContent();
        }

        public override void Draw(GameTime gameTime)
        {
            spriteBatch.Begin();
            sprite.Draw(spriteBatch);
            spriteBatch.End();
            base.Draw(gameTime);
        }
    }
}
