﻿using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Input;

namespace Pong
{
    class Ball : Sprite
    {
        float speed;
        Vector2 angle;
        int maxHeight;
        int maxWidth;

        public Ball(Vector2 position, int maxWidth, int maxHeight)
            : base(position)
        {
            this.maxHeight = maxHeight;
            this.maxWidth = maxWidth;
            speed = 0.2f;
            angle = new Vector2(1, 1);
        }

        public void Update(GameTime gameTime, Sprite playerOne, Sprite playerTwo, ref bool started)
        {
            Position = new Vector2(Position.X + speed * angle.X * gameTime.ElapsedGameTime.Milliseconds, Position.Y + speed * angle.Y * gameTime.ElapsedGameTime.Milliseconds);

            Rectangle ballRect = new Rectangle((int)Position.X, (int)Position.Y, Texture.Width, Texture.Height);
            Rectangle playerOneRect = new Rectangle((int)playerOne.Position.X, (int)playerOne.Position.Y, playerOne.Texture.Width, playerOne.Texture.Height);
            Rectangle playerTwoRect = new Rectangle((int)playerTwo.Position.X, (int)playerTwo.Position.Y, playerOne.Texture.Width, playerOne.Texture.Height);

            // did we collide with the top ?
            if (Position.Y <= 0)
                angle = new Vector2(angle.X, 1);
            // ... or with the bottom ?
            else if (Position.Y >= maxHeight - Texture.Height)
                angle = new Vector2(angle.X, -1);
            // ... or whith player one ?
            else if (ballRect.Intersects(playerOneRect))
            {
                angle = new Vector2(1, angle.Y);
                speed += 0.02f;
            }
            // ... or maybe player two ?
            else if (ballRect.Intersects(playerTwoRect))
            {
                angle = new Vector2(-1, angle.Y);
                speed += 0.02f;
            }
            // ... or maybe we reached left or right border
            else if (Position.X <= 0 || Position.X + Texture.Width >= maxWidth)
                started = false;
        }
    }
}
