﻿using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Input;

namespace Pong
{
    class Bat : Sprite
    {
        float speed;
        int maxHeight;
        Keys keyUp;
        Keys keyDown;

        public Bat(Vector2 position, int maxHeight, Keys keyUp, Keys keyDown)
            : base(position)
        {
            this.maxHeight = maxHeight;
            this.keyUp = keyUp;
            this.keyDown = keyDown;
            speed = 0.7f;
        }

        public void Update(GameTime gameTime)
        {
            if (ServiceHelper.Get<IKeyboardService>().IsKeyDown(keyDown))
                if (Position.Y < (maxHeight - Texture.Height))
                    Position = new Vector2(Position.X, Position.Y + speed * gameTime.ElapsedGameTime.Milliseconds);

            if (ServiceHelper.Get<IKeyboardService>().IsKeyDown(keyUp))
                if (Position.Y > 0)
                    Position = new Vector2(Position.X, Position.Y - speed * gameTime.ElapsedGameTime.Milliseconds);
        }
    }
}
