﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace Pong
{
    public class Pong : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;
        Bat playerOne;
        Bat playerTwo;
        Ball ball;
        bool started;

        public Pong()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";

            ServiceHelper.Game = this;
            Components.Add(new KeyboardService(this));
            //Components.Add(new Background(this));

            playerOne = new Bat(new Vector2(0, 0), graphics.PreferredBackBufferHeight, Keys.A, Keys.Q);
            playerTwo = new Bat(new Vector2(0, 0), graphics.PreferredBackBufferHeight, Keys.Up, Keys.Down);

            ball = new Ball(new Vector2(0, 0), graphics.PreferredBackBufferWidth, graphics.PreferredBackBufferHeight);

            started = false;
        }

        protected override void Initialize()
        {
            Window.Title = "Appuyez sur espace pour démarrer";
            
            base.Initialize();
        }

        protected override void LoadContent()
        {
            spriteBatch = new SpriteBatch(GraphicsDevice);
            playerOne.LoadContent(Content, "bat");
            playerOne.Position = new Vector2(20, graphics.PreferredBackBufferHeight / 2 - playerOne.Texture.Height / 2);
            playerTwo.LoadContent(Content, "bat");
            playerTwo.Position = new Vector2(770, graphics.PreferredBackBufferHeight / 2 - playerTwo.Texture.Height / 2);
            ball.LoadContent(Content, "ball");
            ball.Position = new Vector2((graphics.PreferredBackBufferWidth / 2) - (ball.Texture.Width / 2), (graphics.PreferredBackBufferHeight / 2) - (ball.Texture.Height / 2));
        }

        protected override void UnloadContent()
        {
        }

        protected override void Update(GameTime gameTime)
        {
            base.Update(gameTime);

            if (started)
            {
                playerOne.Update(gameTime);
                playerTwo.Update(gameTime);
                ball.Update(gameTime, playerOne, playerTwo, ref started);
            }
            else
            {
                if (ServiceHelper.Get<IKeyboardService>().IsKeyDown(Keys.Space))
                {
                    started = true;
                    Window.Title = "Pong !";
                }
            }
        }

        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.CornflowerBlue);

            base.Draw(gameTime);

            spriteBatch.Begin(SpriteBlendMode.Additive);
            playerOne.Draw(spriteBatch);
            playerTwo.Draw(spriteBatch);
            ball.Draw(spriteBatch);
            spriteBatch.End();
        }
    }
}
