﻿using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;

namespace PremierProjetXNA
{
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;
        Wizard mage;
        Warrior guerrier;
        float speed;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
            speed = 0.2f;
        }

        protected override void Initialize()
        {
            mage = new Wizard(new Vector2(100,100), "Gandalf", 100, 98);
            guerrier = new Warrior(new Vector2(300, 100), "Conan", 150, 100);
            base.Initialize();          
        }

        protected override void LoadContent()
        {
            spriteBatch = new SpriteBatch(GraphicsDevice);
            mage.LoadContent(Content, "personnage");
            guerrier.LoadContent(Content, "personnage");
        }

        protected override void UnloadContent()
        {
        }

        protected override void Update(GameTime gameTime)
        {
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            mage.Update(new Vector2(gameTime.ElapsedGameTime.Milliseconds * speed, gameTime.ElapsedGameTime.Milliseconds * speed));
            guerrier.Update(new Vector2(0, 0));

            base.Update(gameTime);
        }

        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.Black);

            spriteBatch.Begin();
            mage.Draw(spriteBatch);
            guerrier.Draw(spriteBatch);
            spriteBatch.End();

            base.Draw(gameTime);
        }
    }
}
