<?php

function menus_admin($type = NULL){
    if ($type) {
        return drupal_get_form('menus_addmenu', $type);
    }
    else {
       $rows = array();
       $rows[] = array(l(t('Diner'), 'admin/menus/diner'));
       $rows[] = array(l(t('Gouter'), 'admin/menus/gouter'));
       $header = array('Type');
       $content = array(
           '#theme' => 'table',
           '#header' => $header,
           '#rows' => $rows
       );
       return $content;
    }
}

function menus_addmenu($form, &$form_state, $type) {
    $form['name'] = array(
        '#type' => 'textfield',
        '#title' => 'name'
    );
    $menus = new stdClass();
    $menus->type = $type;
    
    $form['menus'] = array(
        '#type' => 'value',
        '#value' => $menus
    );
    
    $form['type'] = array(
        '#type' => 'value',
        '#value' => $type 
    );
    
    field_attach_form('menus', $menus, $form, $form_state);
    
    $form['actions'] = array('#type' => 'actions');
    $form['actions']['add'] = array(
        '#type' => 'submit',
        '#value' => 'add'
    );
    return $form;
}
function menus_addmenu_validate($form, &$form_state) {
    entity_form_field_validate('menus', $form, $form_state);
}
function menus_addmenu_submit($form, &$form_state) {
    $menus = $form_state['values']['menus'];
    $menus->name = $form_state['values']['name'];
    drupal_write_record('menus', $menus);
    entity_form_submit_build_entity('menus', $menus, $form, $form_state);
    field_attach_submit('menus', $menus, $form, $form_state);
    field_attach_insert('menus', $menus);
    drupal_set_message(
            t('Nouveau @type a été ajouté',
            array('@type' => $menus->type))
            );
}



function menus_display_one($menu) {
    $content[] = array(
                '#markup' => array( $menu->name, 'menus/' . $menu->mid ),
                );
    $content[] = field_attach_view('menus', $menu, 'full');
    return $content;
}

function menus_edit($form, &$form_state, $menu) {
    $form['name'] = array(
        '#type' => 'textfield',
        '#title' => 'name',
        '#default_value' => $menu->name
    );
    $form['menus'] = array(
        '#type' => 'value',
        '#value' => $menu
    );
    
    $form['type'] = array(
        '#type' => 'value',
        '#value' => $menu->type
    );
    
    field_attach_form('menus', $menu, $form, $form_state);
    
    $form['actions'] = array('#type' => 'actions');
    
    $form['actions']['save'] = array(
        '#type' => 'submit',
        '#value' => 'save'
    );
    
    $form['actions']['delete'] = array(
        '#type' => 'submit',
        '#value' => 'delete',
        '#submit' => array('menus_edit_delete')
    );
    return $form;
}

function menus_edit_validate($form, &$form_state) {
    entity_form_field_validate('menus', $form, $form_state);
}

function menus_edit_submit($form, &$form_state) {
    $menu = $form_state['values']['menus'];
    $menu->name = check_plain($form_state['values']['name']);
    drupal_write_record('menus', $menu, array('mid'));
    entity_form_submit_build_entity('menus', $menu, $form, $form_state);
    field_attach_update('menus', $menu);
    
    drupal_set_message(
            t('Le @type a été sauvegardé',
            array('@type' => $menu->type))
            );
    
    $form_state['redirect'] = 'menus/' . $menu->mid;
}

function menus_edit_delete($form, &$form_state) {
    $menu = $form_state['values']['menus'];
    
    field_attach_delete('menus', $menu);
    
    db_delete('menus')
        ->condition('mid', $menu->mid)
        ->execute();
    $form_state['redirect'] = 'menus';
}


?>
