<?php

/* 
 * Intégration de notre entité Menus avec Views
 */

function menus_views_data(){
    // On ajoute un groupe de champs Menus
    $data['menus']['table']['group'] = t('Menus');
    
    $data['menus']['table']['base'] = array(
        'field' => 'mid',
        'title' => t('Menus'),
        'help' => t('Défitions des menus'),
    );
    
    // On ajoute le champ Menu ID (mid)
    $data['menus']['mid'] = array(
        'title' => t('Menus ID'),
        'help' => t('L\'identifiant unique interne du menu.'),
        'field' => array(
            'handler' => 'views_handler_field_numeric',
            'click sortable' => TRUE,
        ),
        'filter' => array(
            'handler' => 'views_handler_filter_numeric',
        ),
        'sort' => array(
            'handler' => 'views_handler_sort',
        ),
        'argument' => array(
            'handler' => 'views_handler_argument_numeric',
        ),
    );
    
    // On ajoute le champ Nom du Menu
    $data['menus']['name'] = array(
        'title' => t('Nom du menu'),
        'help' => t('Le nom du menu'),
        'field' => array(
            'handler' => 'views_handler_field',
            'click sortable' => TRUE,
        ),
        'filter' => array(
            'handler' => 'views_handler_filter_string',
        ),
        'sort' => array(
            'handler' => 'views_handler_sort',
        ),
        'argument' => array(
            'handler' => 'views_handler_argument_string',
        ),
    );
    
    // On ajoute le champs Type
    $data['menus']['type'] = array(
        'title' => t('Type de menu'),
        'help' => t('Le type de menu.'),
        'field' => array(
            'handler' => 'views_handler_field',
            'click sortable' => TRUE,
        ),
        'filter' => array(
            'handler' => 'views_handler_filter_menus_type',
            'label' => t('Type de menus'),
            'use equal' => TRUE,
        ),
        'sort' => array(
            'handler' => 'views_handler_sort',
        ),
        'argument' => array(
            'handler' => 'views_handler_argument_string',
        ),
    );
    
    return $data;
}

class views_handler_filter_menus_type extends views_handler_filter_equality {
    /*
     * On fournit une liste de sélection pour le type
     */
    function value_form(&$form, &$form_state) {
        parent::value_form($form, $form_state);
        
        $form['value'] = array(
            '#type' => 'select',
            '#title' => t('Type'),
            '#options' => array(
                'diner' => t('Diner'),
                'gouter' => t('Gouter'),
            ),
            '#default_value' => $this->value,
            '#required' => FALSE,
        );
    }
}


?>
