<?php

// menus_ressource.inc
/**
  * Callback pour créer des menus.
  *
  * @param object $data
  * @return object
  */
function _menus_ressource_create($data) {
    global $user;
    unset($data->id);
    $data->uid = $user->uid;
    $data->created = time();
    $data->modified = time();
    if (!isset($data->subject)) {
        return services_error('Titre du menu manquant', 406);
    }
    if (!isset($data->menu)) {
        return services_error('Corps du menu manquant', 406);
    }
    menus_ressource_write_menu($data);
    return (object)array(
        'id' => $data->id,'uri' => services_resource_uri(array('menus', $data->id)),
    );
}

/**
  * Callback pour mettre à jour les menus.
  *
  * @param int $id
  * @param object $data
  * @return object
  */
function _menus_ressource_update($id, $data) {
    global $user;
    $menu = menus_ressource_get_menu($id);
    unset($data->created);
    $data->id = $id;
    $data->uid = $menu->uid;
    $data->modified = time();
    menus_ressource_write_menu($data);
    return (object)array(
        'id' => $id,
        'uri' => services_resource_uri(array('menus', $id)),
    );
}

/**
  * Callback pour retrouver un menu.
  *
  * @param int $id
  * @return object
  */
function _menus_ressource_retrieve($id) {
    return menus_ressource_get_menu($id);
}

/**
  * Callback for deleting menus ressources.
  *
  * @param int $id
  * @return object
  */
function _menus_ressource_delete($id) {
    menus_ressource_delete_menu($id);
    return (object)array(
        'id' => $id,
      );
}

/**
  * Callback pour lister les menus.
  *
  * @param int $page
  * @param array $parameters
  * @return array
  */
function _menus_ressource_index($page, $parameters) {
    global $user;
    $menus = array();
    $res = db_query("SELECT * FROM {menus} WHERE uid=:uid ORDER BY modified DESC", array(
        ':uid' => $user->uid,
    ));
    while ($menu = db_fetch_object($res)) {
        $menus[] = $menu;
    }
    return $menus;
}