<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=windows-1252">
<meta name="viewport" content="width=654, minimal-ui">

<style type="text/css"><!--

A:link { color: #000099; }
A:active { color: #ff0000; }
A:visited { color: #000099; }
A:hover { color: #006600; }

body {
	margin: 0px;
	padding: 0px;
	-webkit-text-size-adjust: 100%;
	-moz-text-size-adjust: 100%;
	-ms-text-size-adjust: 100%;
	text-size-adjust: 100%;
}
.outer {
	position: absolute;
	top: 0px;
	bottom: 8px; /* allows for .divider height */
	width: 100%;
}
.divider, .dividerHighlight {
    border: 2px outset #dddddd;
    background-color: #bbbbbb;
    height: 4px;
    cursor: pointer;
}
.dividerHighlight {
	border-style: inset !important;
}
.inner {
	overflow: auto;
	-webkit-overflow-scrolling: touch;
}
#topPart {
	height: 50%;
	display: none;
}
#bottomPart {
	height: 100%;
}
.cr {
	background-color: #999999;
	color: #ffffff;
	border-top: 2px #cccccc ridge;
	border-bottom: 2px #cccccc ridge;
	padding-left: 1em;
	padding-right: 1em;
	font-size: 0.75em;
	line-height: 1.5;
}
.right {
	float: right;
}
.source, .pad {
	white-space: pre;
	font-family: monospace, serif; /* avoids strange font sizing */
	font-size: 0.8em;
}
div.pad {
	line-height: 0.5em;
	overflow: hidden;
}
span.n {
	background-color: #bbbbbb;
	color: #ffffff;
	border-left: 1px #999999 solid;
	border-right: 1px #999999 solid;
}
@media screen and (max-device-width: 640px) {
	/* disable the split-screen machinery so that UI hiding and landscape
	   mode work nicely on the iPhone */
	.outer {
		position: static;
	}
	.divider {
		display: none;
	}
}
--></style>

<script type="text/javascript"><!--

var cloned = false;
var divided = false;
var savedPos = 0;

function splitUnsplit() {
    // Flip between split and un-split views
    //
    var topPart = document.getElementById("topPart");
    var bottomPart = document.getElementById("bottomPart");
	if (!cloned) {
		// topPart.innerHTML = bottomPart.innerHTML;
		var children = bottomPart.childNodes;
		for (var i = 0; i < children.length; i++) {
			topPart.appendChild(children[i].cloneNode(true));
		}
		cloned = true;
	}
    if (divided) {
		savedPos = topPart.scrollTop;
        topPart.style.display = "none";
        bottomPart.style.height = "100%";
    } else {
        topPart.style.display = "block";
        bottomPart.style.height = "50%";
		topPart.scrollTop = savedPos;
    }
    divided = !divided;
    return false;
}

function mouseDown(elt) {
	elt.className = "dividerHighlight";
	return true;
}

function mouseUpOut(elt) {
	elt.className = "divider";
	return true;
}

--></script>

<title>iphone.js</title>
</head>

<body>
<div class="outer">
<div id="topPart" class="inner"></div>
<div class="divider" title="Click to split or un-split the window" onmousedown="return mouseDown(this)" onmouseup="return mouseUpOut(this)" onmouseout="return mouseUpOut(this)" onclick="return splitUnsplit()">
</div>
<div id="bottomPart" class="inner">
<div class="cr">
Source of iphone.js.
<div class="right">
1087 lines, 28.2 KBytes. &nbsp;
Last modified 11:23 am, 26th April 2014 PDT.
</div>
</div> <!-- cr -->
<div class="pad"><span class="n">      </span></div>
<div class="source"><span class="n">    1 </span> // Emacs settings: -*- mode: Fundamental; tab-width: 4; -*-
<span class="n">    2 </span> 
<span class="n">    3 </span> ////////////////////////////////////////////////////////////////////////////
<span class="n">    4 </span> //                                                                        //
<span class="n">    5 </span> // Pachylet: Andrew's Web Mail Interface                                  //
<span class="n">    6 </span> //                                                                        //
<span class="n">    7 </span> // Copyright (c) 2002-2014                                                //
<span class="n">    8 </span> //                                                                        //
<span class="n">    9 </span> // See http://birrell.org/pachylet/help.html                              //
<span class="n">   10 </span> //                                                                        //
<span class="n">   11 </span> // Javascript for iPhone                                                  //
<span class="n">   12 </span> //                                                                        //
<span class="n">   13 </span> ////////////////////////////////////////////////////////////////////////////
<span class="n">   14 </span> 
<span class="n">   15 </span> 
<span class="n">   16 </span> //
<span class="n">   17 </span> // Data types
<span class="n">   18 </span> //
<span class="n">   19 </span> 
<span class="n">   20 </span> // Query is in pachyletV2.js
<span class="n">   21 </span> 
<span class="n">   22 </span> // State is in pachyletV2.js
<span class="n">   23 </span> 
<span class="n">   24 </span> // Toc is in pachyletV2.js
<span class="n">   25 </span> 
<span class="n">   26 </span> // Contact is in pachyletV2.js
<span class="n">   27 </span> 
<span class="n">   28 </span> // Button is in pachyletV2.js, but has overrides:
<span class="n">   29 </span> 
<span class="n">   30 </span> Button.prototype.enable = function() {
<span class="n">   31 </span>     if (!this.enabled) this.element.style.opacity = 1.0;
<span class="n">   32 </span>     this.enabled = true;
<span class="n">   33 </span> }
<span class="n">   34 </span> 
<span class="n">   35 </span> Button.prototype.disable = function() {
<span class="n">   36 </span>     if (this.enabled) this.element.style.opacity = 0.5;
<span class="n">   37 </span>     this.enabled = false;
<span class="n">   38 </span> }
<span class="n">   39 </span> 
<span class="n">   40 </span> 
<span class="n">   41 </span> //
<span class="n">   42 </span> // Global state
<span class="n">   43 </span> //
<span class="n">   44 </span> 
<span class="n">   45 </span> // Most of the global state is declared in pachyletV2.js
<span class="n">   46 </span> var theFQ;                  // sorted array of folders plus saved queries
<span class="n">   47 </span> 
<span class="n">   48 </span> // Widget state
<span class="n">   49 </span> var draftScrollbar;         // scrollbar on draft screen
<span class="n">   50 </span> noMessageSelected = "&lt;b&gt;No message selected&lt;/b&gt;";
<span class="n">   51 </span> viewingUnsentFolder = "&lt;b&gt;Click on a message to resume composing it&lt;/b&gt;";
<span class="n">   52 </span> noMessagesAtAll = "";
<span class="n">   53 </span> var tocItemHeight = 46;   // pixel height of item in the TOC
<span class="n">   54 </span> 
<span class="n">   55 </span> function setPersistentCookie(key, value, path, domain, secure) {
<span class="n">   56 </span>     // Set a persistent cookie
<span class="n">   57 </span>     var date = new Date();
<span class="n">   58 </span>     date.setTime(date.getTime() + 365.25*24*60*60*1000);
<span class="n">   59 </span>     setCookie(key, value, date, path, domain, secure);
<span class="n">   60 </span> }
<span class="n">   61 </span> 
<span class="n">   62 </span> 
<span class="n">   63 </span> //
<span class="n">   64 </span> // Modal message screens
<span class="n">   65 </span> //
<span class="n">   66 </span> 
<span class="n">   67 </span> function reportSuccess(str, action) {
<span class="n">   68 </span>     // Report success modally; cleared by a user click; then do action
<span class="n">   69 </span>     //
<span class="n">   70 </span>     alert(str);
<span class="n">   71 </span>     action();
<span class="n">   72 </span> }
<span class="n">   73 </span> 
<span class="n">   74 </span> function reportError(str) {
<span class="n">   75 </span>     // Report an error to the user, modally
<span class="n">   76 </span>     //
<span class="n">   77 </span>     alert(str);
<span class="n">   78 </span> }
<span class="n">   79 </span> 
<span class="n">   80 </span> function askConfirm(str, action) {
<span class="n">   81 </span>     // Ask for confirmation modally, and on "yes" do the action
<span class="n">   82 </span>     //
<span class="n">   83 </span>     if (confirm(str)) action();
<span class="n">   84 </span> }
<span class="n">   85 </span> 
<span class="n">   86 </span> 
<span class="n">   87 </span> //
<span class="n">   88 </span> // Making server-side requests
<span class="n">   89 </span> //
<span class="n">   90 </span> 
<span class="n">   91 </span> // urlForOp is in pachyletV2.js
<span class="n">   92 </span> 
<span class="n">   93 </span> // The constructor for "Getter" is in pachyletV2.js
<span class="n">   94 </span> // We override methods ".handleFailure", ".handleResult"
<span class="n">   95 </span> 
<span class="n">   96 </span> Getter.prototype.handleFailure = function() {
<span class="n">   97 </span>     if (this.labelOp) doneLabelOp();
<span class="n">   98 </span>     if (this.state != theState) {
<span class="n">   99 </span>         // User has logged out since the request - ignore the response
<span class="n">  100 </span>     } else if (this.op == "saveDraft" &amp;&amp; this.draft.id != curDraftId()) {
<span class="n">  101 </span>         // saveDraft on a draft we've abandoned
<span class="n">  102 </span>     } else {
<span class="n">  103 </span>         if (this.op == "login" || this.op == "logout") {
<span class="n">  104 </span>             screens.login.show();
<span class="n">  105 </span>         } else if (this.toc == theToc &amp;&amp; (this.op == "fetchMail" ||
<span class="n">  106 </span>                 this.op == "getMsgs" ||
<span class="n">  107 </span>                 this.op == "scan")) {
<span class="n">  108 </span>             showFolderScreen();
<span class="n">  109 </span>         } else if (this.composeOp) {
<span class="n">  110 </span>             returnFromDraft();
<span class="n">  111 </span>         } else if (this.sendOp) {
<span class="n">  112 </span>             showDraftScreen();
<span class="n">  113 </span>         } 
<span class="n">  114 </span>         alert("HTTP request" +
<span class="n">  115 </span>             (this.op ? (" \"" + this.op + "\"") : "") + " failed.");
<span class="n">  116 </span>     }
<span class="n">  117 </span> }
<span class="n">  118 </span> 
<span class="n">  119 </span> Getter.prototype.handleResult = function(xmlhttp) {
<span class="n">  120 </span>     // Handle successful result of async HTTP request
<span class="n">  121 </span> //  alert(xmlhttp.responseText);
<span class="n">  122 </span>     if (this.labelOp) doneLabelOp();
<span class="n">  123 </span>     var responseXML = xmlhttp.responseXML;
<span class="n">  124 </span>     var doc = (responseXML ? responseXML.documentElement : null);
<span class="n">  125 </span>     if (this.state != theState) {
<span class="n">  126 </span>         // User has logged out since the request - ignore the response
<span class="n">  127 </span>     } else if (this.op == "saveDraft" &amp;&amp; this.draft.id != curDraftId()) {
<span class="n">  128 </span>         // saveDraft on a draft we've abandoned
<span class="n">  129 </span>     } else if (!doc) {
<span class="n">  130 </span>         alert("Internal error: response isn't valid XML\n\n" +
<span class="n">  131 </span>                                     xmlhttp.responseText);
<span class="n">  132 </span>     } else if (doc.nodeName == "loginFailed") {
<span class="n">  133 </span>         doLogout();
<span class="n">  134 </span>         reportError("Login failed: " + doc.getAttribute("status"));
<span class="n">  135 </span>     } else if (doc.nodeName == "unknownOp") {
<span class="n">  136 </span>         alert("Unknown operation: " + doc.getAttribute("op"));
<span class="n">  137 </span>     } else {
<span class="n">  138 </span>         this.callback(doc);
<span class="n">  139 </span>     }
<span class="n">  140 </span> }
<span class="n">  141 </span> 
<span class="n">  142 </span> function pachyGet(op) {
<span class="n">  143 </span>     // Patch out pachyGet from pachyletV2, since it shouldn't be called.
<span class="n">  144 </span>     //
<span class="n">  145 </span>     alert("Internal error: pachyGet(" + op + ")");
<span class="n">  146 </span> }
<span class="n">  147 </span> 
<span class="n">  148 </span> function iPachyGet(op, callback, offset, selected, dest, startAt) {
<span class="n">  149 </span>     // Call the client-side script to do something, asynchronously,
<span class="n">  150 </span>     // with a GET request.
<span class="n">  151 </span>     //
<span class="n">  152 </span>     var getter = new Getter(op);
<span class="n">  153 </span>     if (getter.labelOp) labelOps++;
<span class="n">  154 </span>     getter.url = urlForOp(op, offset, selected, dest, startAt);
<span class="n">  155 </span>     getter.callback = (callback ? callback : dummyCallback);
<span class="n">  156 </span>     initiateXMLHttp(getter);
<span class="n">  157 </span> }
<span class="n">  158 </span> 
<span class="n">  159 </span> function doneLabelOp() {
<span class="n">  160 </span>     // Completion of a label op
<span class="n">  161 </span>     labelOps--;
<span class="n">  162 </span>     if (labelOps &lt; 0) alert("negative label op count");
<span class="n">  163 </span>     if (labelOps == 0) {
<span class="n">  164 </span>         if (deferredOp) {
<span class="n">  165 </span>             var op = deferredOp;
<span class="n">  166 </span>             deferredOp = null;
<span class="n">  167 </span>             iPachyGet(op, deferredCallback);
<span class="n">  168 </span>         }
<span class="n">  169 </span>     }
<span class="n">  170 </span> }
<span class="n">  171 </span> 
<span class="n">  172 </span> 
<span class="n">  173 </span> //
<span class="n">  174 </span> // Login screen
<span class="n">  175 </span> //
<span class="n">  176 </span> 
<span class="n">  177 </span> function doLogin() {
<span class="n">  178 </span>     user = utf8(document.getElementById("loginUser").value);
<span class="n">  179 </span>     var loginPwd = utf8(document.getElementById("loginPwd").value);
<span class="n">  180 </span>     document.getElementById("loginPwd").value = "";
<span class="n">  181 </span>     document.getElementById("loginUser").blur();
<span class="n">  182 </span>     document.getElementById("loginPwd").blur();
<span class="n">  183 </span>     if (isIphone()) setPersistentCookie("ipachyuser", user);
<span class="n">  184 </span>     pachyPostPwd("login", gotLogin, loginPwd);
<span class="n">  185 </span>     loginPwd = "";
<span class="n">  186 </span>     screens.loggingIn.show();
<span class="n">  187 </span>     return false;
<span class="n">  188 </span> }
<span class="n">  189 </span> 
<span class="n">  190 </span> function autoLogin() {
<span class="n">  191 </span>     // If appropriate, log the user in automatically
<span class="n">  192 </span>     //
<span class="n">  193 </span>     var autoUser = getCookie("ipachyuser");
<span class="n">  194 </span>     if (autoUser &amp;&amp; autoUser == user) {
<span class="n">  195 </span>         if (slidingScreens) setTimeout(doLogin, 0); else doLogin();
<span class="n">  196 </span>     }
<span class="n">  197 </span> }
<span class="n">  198 </span> 
<span class="n">  199 </span> // receiveAccounts is in pachyletV2.js
<span class="n">  200 </span> 
<span class="n">  201 </span> // receiveFolders is in pachyletV2.js
<span class="n">  202 </span> 
<span class="n">  203 </span> // receiveQueries is in pachyletV2.js
<span class="n">  204 </span> 
<span class="n">  205 </span> function folderListHTML(fn, id) {
<span class="n">  206 </span>     // Construct HTML for entire list, calling fn onclick, and
<span class="n">  207 </span>     // insert it at given element id.
<span class="n">  208 </span>     var fText = "";
<span class="n">  209 </span>     for (var i = 0; i &lt; theFQ.length; i++) {
<span class="n">  210 </span>         if (i != 0) fText += '&lt;hr&gt;\n';
<span class="n">  211 </span>         var name = theFQ[i];
<span class="n">  212 </span>         fText += '&lt;a href="#" onclick="return ' + fn + '(\'' +
<span class="n">  213 </span>             htmlspecials(name) +
<span class="n">  214 </span>             '\')"&gt;' +
<span class="n">  215 </span>             htmlspecials(name) +
<span class="n">  216 </span>             '&lt;/a&gt;\n';
<span class="n">  217 </span>     }
<span class="n">  218 </span>     document.getElementById(id).innerHTML = fText;
<span class="n">  219 </span> }
<span class="n">  220 </span> 
<span class="n">  221 </span> function gotLogin(doc) {
<span class="n">  222 </span>     if (checkResult(doc, "user")) {
<span class="n">  223 </span>         if (theState.query.folder == "") {
<span class="n">  224 </span>             screens.loggingIn.seq = screens.folder.seq;
<span class="n">  225 </span>             showFolderScreen();
<span class="n">  226 </span>         } else {
<span class="n">  227 </span>             screens.loggingIn.seq = screens.toc.seq;
<span class="n">  228 </span>             jumpTo(theState.query);
<span class="n">  229 </span>         }
<span class="n">  230 </span>         receiveAccounts(doc);
<span class="n">  231 </span>         var fixedFolders = new Array("Inbox", "Dropped", "Trash", "Unsent");
<span class="n">  232 </span>         var recvdFolders = receiveFolders(doc);
<span class="n">  233 </span>         var recvdQueries = receiveQueries(doc);
<span class="n">  234 </span>         updateAccountsUI();
<span class="n">  235 </span>         theFQ = fixedFolders.concat(
<span class="n">  236 </span>                     recvdFolders.concat(recvdQueries).sort(caseSort));
<span class="n">  237 </span>         folderListHTML("doOpen", "folderList");
<span class="n">  238 </span>         folderListHTML("chooseMoveOp", "moveDestList");
<span class="n">  239 </span>         truncateOptions('findFolder', 1);
<span class="n">  240 </span>         var elt = document.getElementById('findFolder');
<span class="n">  241 </span>         for (var i = 0; i &lt; theFQ.length; i++) {
<span class="n">  242 </span>             appendOption(elt, theFQ[i], theFQ[i]);
<span class="n">  243 </span>         }
<span class="n">  244 </span>     }
<span class="n">  245 </span> }
<span class="n">  246 </span> 
<span class="n">  247 </span> function doLogoutUI() {
<span class="n">  248 </span>     // Clean up the UI after logout
<span class="n">  249 </span>     if (isIphone()) setPersistentCookie("ipachyuser", "");
<span class="n">  250 </span>     screens.loggingOut.show();
<span class="n">  251 </span> }
<span class="n">  252 </span> 
<span class="n">  253 </span> function doLogoutAtServer() {
<span class="n">  254 </span>     // Ask server to erase our authentication cookie
<span class="n">  255 </span>     //
<span class="n">  256 </span>     iPachyGet("logout", doneLogout);
<span class="n">  257 </span> }
<span class="n">  258 </span> 
<span class="n">  259 </span> function doneLogout(doc) {
<span class="n">  260 </span>     // Completion of doLogoutAtServer
<span class="n">  261 </span>     //
<span class="n">  262 </span>     screens.login.show();
<span class="n">  263 </span> }
<span class="n">  264 </span> 
<span class="n">  265 </span> // doLogout is in pachyletV2.js
<span class="n">  266 </span> 
<span class="n">  267 </span> 
<span class="n">  268 </span> //
<span class="n">  269 </span> // Folder list and moveDest screens
<span class="n">  270 </span> //
<span class="n">  271 </span> 
<span class="n">  272 </span> function showFolderScreen() {
<span class="n">  273 </span>     // Show top-level folder list screen, and abandon previous query and
<span class="n">  274 </span>     // its TOC.
<span class="n">  275 </span>     screens.folder.show();
<span class="n">  276 </span>     disableMsgBtns();
<span class="n">  277 </span>     deleteCookie("ipachyfolder");
<span class="n">  278 </span>     if (theState.query.folder != "") theState.oldFolder =
<span class="n">  279 </span>             theState.query.folder;
<span class="n">  280 </span>     theState.query = new Query("");
<span class="n">  281 </span>     abandonToc();
<span class="n">  282 </span>     return false;
<span class="n">  283 </span> }
<span class="n">  284 </span> 
<span class="n">  285 </span> function chooseMoveDest() {
<span class="n">  286 </span>     // Show moveDest screen
<span class="n">  287 </span>     screens.moveDest.show();
<span class="n">  288 </span>     return false;
<span class="n">  289 </span> }
<span class="n">  290 </span> 
<span class="n">  291 </span> 
<span class="n">  292 </span> //
<span class="n">  293 </span> // TOC operations
<span class="n">  294 </span> //
<span class="n">  295 </span> 
<span class="n">  296 </span> function showTocScreen() {
<span class="n">  297 </span>     // Show the TOC screen
<span class="n">  298 </span>     screens.toc.show();
<span class="n">  299 </span>     tocScrollbar.set(tocScrollbar.visible, tocScrollbar.pos);
<span class="n">  300 </span>     return false;
<span class="n">  301 </span> }
<span class="n">  302 </span> 
<span class="n">  303 </span> function setTocPrompt(prompt) {
<span class="n">  304 </span>     // Set a user prompt on the TOC area
<span class="n">  305 </span>     document.getElementById("toc").innerHTML = prompt;
<span class="n">  306 </span>     theToc.prevHTML = prompt;
<span class="n">  307 </span>     document.getElementById('tocCounters').innerHTML = "";
<span class="n">  308 </span> }
<span class="n">  309 </span> 
<span class="n">  310 </span> function getToc(fetch) {
<span class="n">  311 </span>     // Execute a query on the server to fetch theState.tocPageSize TOC lines
<span class="n">  312 </span>     // Can get deferred because of outstanding labelOps.
<span class="n">  313 </span>     var op = (fetch ? "fetchMail" : "getMsgs");
<span class="n">  314 </span>     if (theToc.total &lt; 0) {
<span class="n">  315 </span>         // First use of query
<span class="n">  316 </span>         var fName = htmlspecials(theState.query.folder);
<span class="n">  317 </span>         setTocPrompt("Reading ...");
<span class="n">  318 </span>         document.getElementById('tocTitle').innerHTML = "&amp;nbsp;" + fName;
<span class="n">  319 </span>         document.getElementById('msgTitle').innerHTML = "&amp;nbsp;" + fName;
<span class="n">  320 </span>     }
<span class="n">  321 </span>     if (labelOps &gt; 0) {
<span class="n">  322 </span>         deferredOp = op;
<span class="n">  323 </span>         deferredCallback = gotToc;
<span class="n">  324 </span>     } else {
<span class="n">  325 </span>         iPachyGet(op, gotToc);
<span class="n">  326 </span>     }
<span class="n">  327 </span> }
<span class="n">  328 </span> 
<span class="n">  329 </span> // receiveToc is in pachyletV2.js
<span class="n">  330 </span> 
<span class="n">  331 </span> function gotToc(doc) {
<span class="n">  332 </span>     // Response to fetchMail or getMsgs
<span class="n">  333 </span>     if (checkResult(doc, "toc")) {
<span class="n">  334 </span>         var recvdToc = receiveToc(doc);
<span class="n">  335 </span>         if (theState.selected &lt; 0) {
<span class="n">  336 </span>             theState.selected = recvdToc.selected;
<span class="n">  337 </span>             theState.selOffset = recvdToc.selOffset;
<span class="n">  338 </span>             prefetchToc();
<span class="n">  339 </span>         }
<span class="n">  340 </span>         // unlike non-iPhone, we don't call "show" because that would
<span class="n">  341 </span>         // flip us to the message screen.
<span class="n">  342 </span>         showToc();
<span class="n">  343 </span>         xableMiscBtns();
<span class="n">  344 </span>     }
<span class="n">  345 </span> }
<span class="n">  346 </span> 
<span class="n">  347 </span> function disableMsgBtns() {
<span class="n">  348 </span>     // Disable buttons that require a message to be selected
<span class="n">  349 </span>     btns.resend.disable();
<span class="n">  350 </span>     btns.forward.disable();
<span class="n">  351 </span>     btns.replyAll.disable();
<span class="n">  352 </span>     btns.reply.disable();
<span class="n">  353 </span> }
<span class="n">  354 </span> 
<span class="n">  355 </span> function abandonToc() {
<span class="n">  356 </span>     // Discard TOC in preparation for new query
<span class="n">  357 </span>     // Implicitly discards responses to related requests
<span class="n">  358 </span>     theState.offset = 0;
<span class="n">  359 </span>     theState.selected = -1;
<span class="n">  360 </span>     theToc = new Toc(); // discard old TOC data, and also old requests
<span class="n">  361 </span>     showContents(noMessagesAtAll);
<span class="n">  362 </span>     tocScrollbar.set(1.0, 0.0);
<span class="n">  363 </span>     btns.tocEarlier.disable();
<span class="n">  364 </span>     btns.tocLater.disable();
<span class="n">  365 </span>     btns.next.disable();
<span class="n">  366 </span>     btns.next2.disable();
<span class="n">  367 </span>     btns.prev.disable();
<span class="n">  368 </span>     disableMsgBtns();
<span class="n">  369 </span> }
<span class="n">  370 </span> 
<span class="n">  371 </span> function fetchMail() {
<span class="n">  372 </span>     // Manual prod at incorporating new mail
<span class="n">  373 </span>     // In this version, this happens on the folder screen, with no current
<span class="n">  374 </span>     // folder.
<span class="n">  375 </span>     doOpen("Inbox", true);
<span class="n">  376 </span>     return false;
<span class="n">  377 </span> }
<span class="n">  378 </span> 
<span class="n">  379 </span> function jumpTo(query, fetch) {
<span class="n">  380 </span>     // Execute the given query, optionally first fetching new mail
<span class="n">  381 </span>     if (query.folder != theState.query.folder &amp;&amp;
<span class="n">  382 </span>             theState.query.folder != "") {
<span class="n">  383 </span>         theState.oldFolder = theState.query.folder;
<span class="n">  384 </span>     }
<span class="n">  385 </span>     theState.query = query;
<span class="n">  386 </span>     abandonToc();
<span class="n">  387 </span>     getToc(fetch);
<span class="n">  388 </span>     showTocScreen();
<span class="n">  389 </span>     setPersistentCookie("ipachyfolder", theState.query.folder);
<span class="n">  390 </span> }
<span class="n">  391 </span> 
<span class="n">  392 </span> // fetchMail is in pachyletV2.js
<span class="n">  393 </span> 
<span class="n">  394 </span> function fixFindPrompts() {
<span class="n">  395 </span>     // Override pachyletV2.js
<span class="n">  396 </span> }
<span class="n">  397 </span> 
<span class="n">  398 </span> // setFind is in pachyletV2.js
<span class="n">  399 </span> 
<span class="n">  400 </span> function chooseFind() {
<span class="n">  401 </span>     setFind(theState.query);
<span class="n">  402 </span>     screens.find.show();
<span class="n">  403 </span>     return false;
<span class="n">  404 </span> }
<span class="n">  405 </span> 
<span class="n">  406 </span> function findFromFolders() {
<span class="n">  407 </span>     findClear();
<span class="n">  408 </span>     screens.find.show();
<span class="n">  409 </span>     return false;
<span class="n">  410 </span> }
<span class="n">  411 </span> 
<span class="n">  412 </span> // findClear is in pachyletV2.js
<span class="n">  413 </span> 
<span class="n">  414 </span> function findClose() {
<span class="n">  415 </span>     // Override pachyletV2.js
<span class="n">  416 </span> }
<span class="n">  417 </span> 
<span class="n">  418 </span> // doFind is in pachyletV2.js
<span class="n">  419 </span> 
<span class="n">  420 </span> // doOpen is in pachyletV2.js
<span class="n">  421 </span> 
<span class="n">  422 </span> function doScan() {
<span class="n">  423 </span>     // Scan smart folders for unread messages
<span class="n">  424 </span>     abandonToc();
<span class="n">  425 </span>     setTocPrompt("Scanning ...");
<span class="n">  426 </span>     document.getElementById('tocTitle').innerHTML = "&amp;nbsp;";
<span class="n">  427 </span>     showTocScreen();
<span class="n">  428 </span>     if (labelOps &gt; 0) {
<span class="n">  429 </span>         deferredOp = "scan";
<span class="n">  430 </span>         deferredCallback = gotScan;
<span class="n">  431 </span>     } else {
<span class="n">  432 </span>         iPachyGet("scan", gotScan);
<span class="n">  433 </span>     }
<span class="n">  434 </span>     return false;
<span class="n">  435 </span> }
<span class="n">  436 </span> 
<span class="n">  437 </span> function gotScan(doc) {
<span class="n">  438 </span>     // Scan result from server
<span class="n">  439 </span>     if (checkResult(doc, "scanned")) {
<span class="n">  440 </span>         var found = doc.getAttribute("folder");
<span class="n">  441 </span>         if (found == "") {
<span class="n">  442 </span>             showFolderScreen();
<span class="n">  443 </span>         } else {
<span class="n">  444 </span>             doOpen(found);
<span class="n">  445 </span>         }
<span class="n">  446 </span>     }
<span class="n">  447 </span> }
<span class="n">  448 </span> 
<span class="n">  449 </span> function showToc() {
<span class="n">  450 </span>     // Show the TOC at its current scroll offset
<span class="n">  451 </span>     var last = theToc.total - theState.offset;
<span class="n">  452 </span>     var first = last - theState.tocPageSize + 1;
<span class="n">  453 </span>     if (first &lt;= 0) first = 1;
<span class="n">  454 </span>     document.getElementById('tocCounters').innerHTML =
<span class="n">  455 </span>         "&amp;nbsp;" +
<span class="n">  456 </span>         (theToc.total == 0 ? "Empty" :
<span class="n">  457 </span>             ((last - first + 1 == theToc.total ?
<span class="n">  458 </span>                 "All " + (last - first + 1) :
<span class="n">  459 </span>                 (theState.offset == 0 ? "Last " + (last - first + 1) :
<span class="n">  460 </span>                     ("" + first + "-" + last))) +
<span class="n">  461 </span>             "&amp;nbsp;\nof " + theToc.total));
<span class="n">  462 </span>     var temp = "";
<span class="n">  463 </span>     var gotEverything = true;
<span class="n">  464 </span>     for (var i = theState.offset + theState.tocPageSize - 1;
<span class="n">  465 </span>             i &gt;= theState.offset; i--) {
<span class="n">  466 </span>         var tocLine = theToc.lines[i];
<span class="n">  467 </span>         if (temp != "") temp += "&lt;hr&gt;";
<span class="n">  468 </span>         if (tocLine) {
<span class="n">  469 </span>             var flag = (tocLine.id == theState.selected ? "&amp;gt;" :
<span class="n">  470 </span>                 (tocLine.unread ? "?" : "&amp;nbsp;"));
<span class="n">  471 </span>             // Date is right-justified.  Left is better with this layout
<span class="n">  472 </span>             var lDate = tocLine.date;
<span class="n">  473 </span>             for (;;) {
<span class="n">  474 </span>                 if (lDate.indexOf(' ') == 0) {
<span class="n">  475 </span>                     lDate = lDate.substring(1) + "&amp;nbsp;";
<span class="n">  476 </span>                 } else if (lDate.indexOf('&amp;nbsp;') == 0) {
<span class="n">  477 </span>                     lDate = lDate.substring(6) + "&amp;nbsp;";
<span class="n">  478 </span>                 } else {
<span class="n">  479 </span>                     break;
<span class="n">  480 </span>                 }
<span class="n">  481 </span>             }
<span class="n">  482 </span>             temp += "&lt;a href=\"#\" onclick=\"return show(" + tocLine.id +
<span class="n">  483 </span>                 "," + i + ")\"&gt;";
<span class="n">  484 </span>             temp += flag + " &lt;b&gt;" + tocLine.subject + "&lt;/b&gt;";
<span class="n">  485 </span>             temp += "\n";
<span class="n">  486 </span>             temp += "  " + lDate + "  " + tocLine.from;
<span class="n">  487 </span>             temp += "&lt;/a&gt;";
<span class="n">  488 </span>         } else if (i &lt; theToc.total) {
<span class="n">  489 </span>             temp += "&lt;a href=\"#\" onclick=\"return false\"&gt;";
<span class="n">  490 </span>             temp += "  Message " + (theToc.total-i) + " ...\n ";
<span class="n">  491 </span>             temp += "&lt;/a&gt;";
<span class="n">  492 </span>             gotEverything = false;
<span class="n">  493 </span>         }
<span class="n">  494 </span>     }
<span class="n">  495 </span>     if (temp != theToc.prevHTML) { // there are redundant calls of showToc
<span class="n">  496 </span>         document.getElementById("toc").innerHTML = temp;
<span class="n">  497 </span>         theToc.prevHTML = temp;
<span class="n">  498 </span>     }
<span class="n">  499 </span>     tocScrollbar.set(
<span class="n">  500 </span>         (theToc.total == 0 ? 1.0 : (last-first+1)/theToc.total),
<span class="n">  501 </span>         (first == 1 ? 0.0 : (first-1)/(theToc.total-(last-first+1))));
<span class="n">  502 </span>     if (theState.offset == 0) {
<span class="n">  503 </span>         btns.tocLater.disable();
<span class="n">  504 </span>     } else {
<span class="n">  505 </span>         btns.tocLater.enable();
<span class="n">  506 </span>     }
<span class="n">  507 </span>     if (theState.offset &gt;= theToc.total - theState.tocPageSize) {
<span class="n">  508 </span>         btns.tocEarlier.disable();
<span class="n">  509 </span>     } else {
<span class="n">  510 </span>         btns.tocEarlier.enable();
<span class="n">  511 </span>     }
<span class="n">  512 </span>     return gotEverything;
<span class="n">  513 </span> }
<span class="n">  514 </span> 
<span class="n">  515 </span> // tocPageKnown is in pachyletV2.js
<span class="n">  516 </span> 
<span class="n">  517 </span> function prefetchToc() {
<span class="n">  518 </span>     var nextBefore = theState.offset + theState.tocPageSize;
<span class="n">  519 </span>     if (nextBefore &gt;= theToc.total) nextBefore = theToc.total-1;
<span class="n">  520 </span>     if (nextBefore &gt; theState.offset &amp;&amp; !tocPageKnown(nextBefore)) {
<span class="n">  521 </span>         iPachyGet("getMsgs", gotToc, nextBefore);
<span class="n">  522 </span>     }
<span class="n">  523 </span>     var nextAfter = theState.offset - theState.tocPageSize;
<span class="n">  524 </span>     if (nextAfter &lt; 0) nextAfter = 0;
<span class="n">  525 </span>     if (nextAfter &lt; theState.offset &amp;&amp; !tocPageKnown(nextAfter)) {
<span class="n">  526 </span>         iPachyGet("getMsgs", gotToc, nextAfter);
<span class="n">  527 </span>     }
<span class="n">  528 </span> }
<span class="n">  529 </span> 
<span class="n">  530 </span> // scrollTocTo is in pachyletV2.js
<span class="n">  531 </span> 
<span class="n">  532 </span> // goToStart is in pachyletV2.js
<span class="n">  533 </span> 
<span class="n">  534 </span> // goToEnd is in pachyletV2.js
<span class="n">  535 </span> 
<span class="n">  536 </span> // newTocScrollbar is in pachyletV2.js
<span class="n">  537 </span> 
<span class="n">  538 </span> 
<span class="n">  539 </span> //
<span class="n">  540 </span> // Message display
<span class="n">  541 </span> //
<span class="n">  542 </span> 
<span class="n">  543 </span> // Summary of the main message display functions:
<span class="n">  544 </span> //
<span class="n">  545 </span> //   showContents ... places given HTML in the message display area.
<span class="n">  546 </span> //   showMessageContents ... display a message object (which might be a sub-
<span class="n">  547 </span> //                           message); calls showContents; initiates message
<span class="n">  548 </span> //                           pre-fetch.
<span class="n">  549 </span> //   show         ... makes the given message ID be the one we're trying to
<span class="n">  550 </span> //                    display.  Switches to the message screen.  Calls
<span class="n">  551 </span> //                    showMessageContents, or initiates read from server.
<span class="n">  552 </span> //   showAltMsg   ... initiates read of a sub-message or alternative part.
<span class="n">  553 </span> //   receiveMsg   ... takes message response from server, and builds message
<span class="n">  554 </span> //                    object; caches it if appropriate, and displays it if
<span class="n">  555 </span> //                    appropriate (by calling showMessageContents).
<span class="n">  556 </span> //
<span class="n">  557 </span> // Note that "show" is the only thing that changes the shown message ID. The
<span class="n">  558 </span> // others gets used to display sub-messages, alternative views, or
<span class="n">  559 </span> // miscellanous prompts within that message ID.
<span class="n">  560 </span> 
<span class="n">  561 </span> function showMsgScreen() {
<span class="n">  562 </span>     screens.msg.show();
<span class="n">  563 </span> }
<span class="n">  564 </span> 
<span class="n">  565 </span> function returnToToc() {
<span class="n">  566 </span>     // Return from message contents screen to TOC screen, re-displaying TOC
<span class="n">  567 </span>     // (which can change during message screen operations).
<span class="n">  568 </span>     if (!showToc()) getToc();
<span class="n">  569 </span>     showTocScreen();
<span class="n">  570 </span>     return false;
<span class="n">  571 </span> }
<span class="n">  572 </span> 
<span class="n">  573 </span> function showContents(head, body) {
<span class="n">  574 </span>     // Display some HTML in the contents area
<span class="n">  575 </span>     document.getElementById("msgContents").scrollTop = 0;
<span class="n">  576 </span>     document.getElementById("msgContents").scrollLeft = 0;
<span class="n">  577 </span>     document.getElementById("msgHead").innerHTML = head;
<span class="n">  578 </span>     document.getElementById("msgBody").innerHTML = (body ? body : "");
<span class="n">  579 </span> }
<span class="n">  580 </span> 
<span class="n">  581 </span> function getTruncatedPrompt(msgContent) {
<span class="n">  582 </span>     // Return "truncated" prompt for inclusion in header display
<span class="n">  583 </span>     var truncated;
<span class="n">  584 </span>     if (msgContent.truncated) {
<span class="n">  585 </span>         var clickHere = "&lt;a href=\"#\" " +
<span class="n">  586 </span>             "onClick=\"return showAltMsg(" + msgContent.id + "," +
<span class="n">  587 </span>                 msgContent.startAt + ", '" +
<span class="n">  588 </span>                 msgContent.selectedPart + "', true)\" " +
<span class="n">  589 </span>             "&gt;view all " + msgContent.fullLength + " bytes&lt;/a&gt;";
<span class="n">  590 </span>         truncated = "&lt;br&gt;&lt;b&gt;Truncated: &lt;/b&gt;" + clickHere;
<span class="n">  591 </span>     } else {
<span class="n">  592 </span>         truncated = "";
<span class="n">  593 </span>     }
<span class="n">  594 </span>     return truncated;
<span class="n">  595 </span> }
<span class="n">  596 </span> 
<span class="n">  597 </span> function showMessageContents(msgContent) {
<span class="n">  598 </span>     // Display received message contents, and pre-fetch next message
<span class="n">  599 </span>     showContents(msgContent.header + getTruncatedPrompt(msgContent),
<span class="n">  600 </span>         msgContent.body);
<span class="n">  601 </span>     if (theState.selOffset &gt; 0) {
<span class="n">  602 </span>         var nextLine = theToc.lines[theState.selOffset - 1];
<span class="n">  603 </span>         if (nextLine &amp;&amp; !msgCache.read(""+nextLine.id)) {
<span class="n">  604 </span>             iPachyGet("getMsg", gotMsg, null, nextLine.id);
<span class="n">  605 </span>         }
<span class="n">  606 </span>     }
<span class="n">  607 </span> }
<span class="n">  608 </span> 
<span class="n">  609 </span> function show(id, offset) {
<span class="n">  610 </span>     // Show given message, which lives at given offset in TOC
<span class="n">  611 </span>     if (theState.query.folder == "Unsent") {
<span class="n">  612 </span>         theState.selected = 0;
<span class="n">  613 </span>         theState.selOffset = 0;
<span class="n">  614 </span>     } else {
<span class="n">  615 </span>         theState.selected = id;
<span class="n">  616 </span>         theState.selOffset = offset;
<span class="n">  617 </span>     }
<span class="n">  618 </span>     if (offset &lt; theState.offset) {
<span class="n">  619 </span>         scrollTocTo(theState.offset - theState.tocPageSize);
<span class="n">  620 </span>     } else if (offset &gt;= theState.offset + theState.tocPageSize) {
<span class="n">  621 </span>         scrollTocTo(theState.offset + theState.tocPageSize);
<span class="n">  622 </span>     }
<span class="n">  623 </span>     if (theState.query.folder == "Unsent") {
<span class="n">  624 </span>         if (id == 0) {
<span class="n">  625 </span>             showContents(theToc.total &gt; 0 ? viewingUnsentFolder :
<span class="n">  626 </span>                 noMessagesAtAll);
<span class="n">  627 </span>         } else {
<span class="n">  628 </span>             return doReopenDraft(id);
<span class="n">  629 </span>         }
<span class="n">  630 </span>     } else if (theState.selected &lt;= 0) {
<span class="n">  631 </span>         showContents(theToc.total &gt; 0 ? noMessageSelected :
<span class="n">  632 </span>             noMessagesAtAll);
<span class="n">  633 </span>     } else {
<span class="n">  634 </span>         var tocLine = theToc.lines[theState.selOffset];
<span class="n">  635 </span>         if (tocLine.unread) {
<span class="n">  636 </span>             iPachyGet("markRead");
<span class="n">  637 </span>             theState.totalUnread--;
<span class="n">  638 </span>         }
<span class="n">  639 </span>         tocLine.unread = false;
<span class="n">  640 </span>         var content = msgCache.read(""+id);
<span class="n">  641 </span>         if (content) {
<span class="n">  642 </span>             showMessageContents(content);
<span class="n">  643 </span>         } else {
<span class="n">  644 </span>             var prompt = "&lt;b&gt;Reading ...&lt;/b&gt;";
<span class="n">  645 </span>             if (tocLine) {
<span class="n">  646 </span>                 prompt += "&lt;br&gt;&lt;b&gt;Subj: &lt;/b&gt;" + tocLine.subject;
<span class="n">  647 </span>             }
<span class="n">  648 </span>             showContents(prompt);
<span class="n">  649 </span>             iPachyGet("getMsg", gotMsg);
<span class="n">  650 </span>         }
<span class="n">  651 </span>     }
<span class="n">  652 </span>     document.getElementById('msgCounters').innerHTML =
<span class="n">  653 </span>         "&amp;nbsp;" + (theState.selected &lt;= 0 ? "" :
<span class="n">  654 </span>             (theToc.total - theState.selOffset) +
<span class="n">  655 </span>             "\n&amp;nbsp;of " + theToc.total);
<span class="n">  656 </span>     showMsgScreen();
<span class="n">  657 </span>     xableMiscBtns();
<span class="n">  658 </span>     return false;
<span class="n">  659 </span> }
<span class="n">  660 </span> 
<span class="n">  661 </span> function showAltMsg(id, startAt, chosenPartNo, full) {
<span class="n">  662 </span>     // Show an attached message, or non-default part of main message
<span class="n">  663 </span>     showContents("&lt;b&gt;Reading ...&lt;/b&gt;");
<span class="n">  664 </span>     iPachyGet((full ? "getFullMsg" : "getMsg"), gotMsg, null, null,
<span class="n">  665 </span>         chosenPartNo, startAt);
<span class="n">  666 </span>     return false;
<span class="n">  667 </span> }
<span class="n">  668 </span> 
<span class="n">  669 </span> function showHeader(id, startAt) {
<span class="n">  670 </span>     // Show a message's header
<span class="n">  671 </span>     showContents("&lt;b&gt;Reading ...&lt;/b&gt;");
<span class="n">  672 </span>     iPachyGet("getRawHeader", gotRaw, null, null, null, startAt);
<span class="n">  673 </span>     return false;
<span class="n">  674 </span> }
<span class="n">  675 </span> 
<span class="n">  676 </span> function showRawMessage(id, startAt) {
<span class="n">  677 </span>     // Show re-assembled raw message
<span class="n">  678 </span>     showContents("&lt;b&gt;Reading ...&lt;/b&gt;");
<span class="n">  679 </span>     iPachyGet("getRawMessage", gotRaw, null, null, null, startAt);
<span class="n">  680 </span>     return false;
<span class="n">  681 </span> }
<span class="n">  682 </span> 
<span class="n">  683 </span> // receiveMsg is in pachyletV2.js
<span class="n">  684 </span> 
<span class="n">  685 </span> function gotRaw(doc) {
<span class="n">  686 </span>     // Server response to getRawHeader or getRawMessage
<span class="n">  687 </span>         var id = parseInt(doc.getAttribute("id"));
<span class="n">  688 </span>         if (id == theState.selected) {
<span class="n">  689 </span>             var startAt = parseInt(doc.getAttribute("startAt"));
<span class="n">  690 </span>             var content = getBulkData(doc);
<span class="n">  691 </span>             var tempHdr = "&lt;b&gt;Raw " +
<span class="n">  692 </span>                 (doc.nodeName == "rawHeader" ? "Header:" : "Message:") +
<span class="n">  693 </span>                 " &lt;/b&gt;";
<span class="n">  694 </span>             if (startAt != 0) {
<span class="n">  695 </span>                 tempHdr += "&lt;a href=\"#\" " +
<span class="n">  696 </span>                     "onClick=\"return showAltMsg(" + id + "," +
<span class="n">  697 </span>                     startAt + ", '')\" " +
<span class="n">  698 </span>                     "title=\"Return to attached message\"" +
<span class="n">  699 </span>                     "&gt;sub-message #" + startAt + "&lt;/a&gt; of ";
<span class="n">  700 </span>             }
<span class="n">  701 </span>             tempHdr += "&lt;a href=\"#\" onClick=\"return show(" + id + "," +
<span class="n">  702 </span>                 theState.selOffset +
<span class="n">  703 </span>                 ")\" title=\"Return to message #" + id + "\"&gt;" +
<span class="n">  704 </span>                 "message #" + id + "&lt;/a&gt;";
<span class="n">  705 </span>             showContents(tempHdr,
<span class="n">  706 </span>                 "&lt;div class=fixedNoWrap&gt;" +
<span class="n">  707 </span>                 htmlspecials(content) + 
<span class="n">  708 </span>                 "&lt;/div&gt;");
<span class="n">  709 </span>         }
<span class="n">  710 </span> }
<span class="n">  711 </span> 
<span class="n">  712 </span> function gotMsg(doc) {
<span class="n">  713 </span>     // Server response to getMsg
<span class="n">  714 </span>     if (checkResult(doc, "msg")) {
<span class="n">  715 </span>         receiveMsg(this, doc, false);
<span class="n">  716 </span>     }
<span class="n">  717 </span> }
<span class="n">  718 </span> 
<span class="n">  719 </span> // doNext and doPrev are in pachyletV2.js
<span class="n">  720 </span> 
<span class="n">  721 </span> 
<span class="n">  722 </span> function xableMiscBtns() {
<span class="n">  723 </span>     // called when displaying a message, or after getting a query result
<span class="n">  724 </span>     if (theState.selected &lt;= 0) {
<span class="n">  725 </span>         disableMsgBtns();
<span class="n">  726 </span>     } else {
<span class="n">  727 </span>         btns.resend.enable();
<span class="n">  728 </span>         btns.forward.enable();
<span class="n">  729 </span>         btns.replyAll.enable();
<span class="n">  730 </span>         btns.reply.enable();
<span class="n">  731 </span>     }
<span class="n">  732 </span>     if (theState.query.folder == "Trash") {
<span class="n">  733 </span>         btns.drop.disable();
<span class="n">  734 </span>         btns.trash.disable();
<span class="n">  735 </span>     } else if (theState.query.folder == "Dropped") {
<span class="n">  736 </span>         btns.drop.disable();
<span class="n">  737 </span>         btns.trash.enable();
<span class="n">  738 </span>     } else {
<span class="n">  739 </span>         btns.drop.enable();
<span class="n">  740 </span>         btns.trash.enable();
<span class="n">  741 </span>     }
<span class="n">  742 </span>     if (theState.selOffset &gt; 0 ||
<span class="n">  743 </span>             (theState.selected &lt;= 0 &amp;&amp; theToc.total &gt; 0)) {
<span class="n">  744 </span>         showHide(btns.next2.id, true);
<span class="n">  745 </span>         showHide(btns.scan3.id, false);
<span class="n">  746 </span>         btns.next.enable();
<span class="n">  747 </span>         btns.next2.enable();
<span class="n">  748 </span>     } else {
<span class="n">  749 </span>         showHide(btns.next2.id, false);
<span class="n">  750 </span>         showHide(btns.scan3.id, true);
<span class="n">  751 </span>         btns.next.disable();
<span class="n">  752 </span>         btns.next2.disable();
<span class="n">  753 </span>     }
<span class="n">  754 </span>     if (theState.selOffset + 1 &lt; theToc.total) {
<span class="n">  755 </span>         btns.prev.enable();
<span class="n">  756 </span>     } else {
<span class="n">  757 </span>         btns.prev.disable();
<span class="n">  758 </span>     }
<span class="n">  759 </span>     if (theState.totalUnread &gt; 0 || true) {
<span class="n">  760 </span>         btns.scan1.enable();
<span class="n">  761 </span>     } else {
<span class="n">  762 </span>         btns.scan1.disable();
<span class="n">  763 </span>     }
<span class="n">  764 </span> }
<span class="n">  765 </span> 
<span class="n">  766 </span> 
<span class="n">  767 </span> //
<span class="n">  768 </span> // Label operations
<span class="n">  769 </span> //
<span class="n">  770 </span> 
<span class="n">  771 </span> function doMoveCopy(moveOrCopy, dest) {
<span class="n">  772 </span>     // Move or copy to dest folder
<span class="n">  773 </span>     if (theState.selected &lt;= 0) {
<span class="n">  774 </span>         reportError("No message selected");
<span class="n">  775 </span>     } else {
<span class="n">  776 </span>         if (!dest || dest == "-") {
<span class="n">  777 </span>             reportError("No destination folder selected");
<span class="n">  778 </span>         } else if (dest == theState.query.folder) {
<span class="n">  779 </span>             reportError("You can't move or copy a message to the " +
<span class="n">  780 </span>                 "folder you're currently looking at");
<span class="n">  781 </span>         } else {
<span class="n">  782 </span>             iPachyGet((moveOrCopy ? "move" : "copy"),
<span class="n">  783 </span>                       null, null, null, dest);
<span class="n">  784 </span>             if (moveOrCopy) {
<span class="n">  785 </span>                 // Remove from our cached TOC, and repaint
<span class="n">  786 </span>                 theToc.lines.splice(theState.selOffset, 1);
<span class="n">  787 </span>                 theToc.total--;
<span class="n">  788 </span>             }
<span class="n">  789 </span>             if (theToc.total == 0) {
<span class="n">  790 </span>                 show(0, 0);
<span class="n">  791 </span>             } else {
<span class="n">  792 </span>                 if (theState.selOffset == 0) theState.selOffset = 1;
<span class="n">  793 </span>                 doNext();
<span class="n">  794 </span>             }
<span class="n">  795 </span>         }
<span class="n">  796 </span>     }
<span class="n">  797 </span>     return false;
<span class="n">  798 </span> }
<span class="n">  799 </span> 
<span class="n">  800 </span> var moveCopyDest = null;
<span class="n">  801 </span> 
<span class="n">  802 </span> function chooseMoveOp(folder) {
<span class="n">  803 </span>     moveCopyDest = folder;
<span class="n">  804 </span>     document.getElementById('moveOpDest').innerHTML = htmlspecials(folder);
<span class="n">  805 </span>     screens.moveOp.show();
<span class="n">  806 </span>     return false;
<span class="n">  807 </span> }
<span class="n">  808 </span> 
<span class="n">  809 </span> function doMoveCopyOp(moveOrCopy, all) {
<span class="n">  810 </span>     // Do requested move/copy with previously chosen destination
<span class="n">  811 </span>     if (!all) {
<span class="n">  812 </span>         doMoveCopy(moveOrCopy, moveCopyDest);
<span class="n">  813 </span>     } else if (theToc.total &lt; 0) {
<span class="n">  814 </span>         // nothing to move
<span class="n">  815 </span>     } else if (!confirm("Really " + (moveOrCopy ? "move" : "copy") +
<span class="n">  816 </span>                 " all " + theToc.total + " messages to \"" +
<span class="n">  817 </span>                 moveCopyDest + "\"?")) {
<span class="n">  818 </span>         // just walk away
<span class="n">  819 </span>     } else if (moveOrCopy) {
<span class="n">  820 </span>         iPachyGet("moveAll", null, null, null, moveCopyDest);
<span class="n">  821 </span>         theToc.lines = new Array();
<span class="n">  822 </span>         theToc.total = 0;
<span class="n">  823 </span>         show(0,0);
<span class="n">  824 </span>         returnToToc();
<span class="n">  825 </span>     } else {
<span class="n">  826 </span>         iPachyGet("copyAll", null, null, null, moveCopyDest);
<span class="n">  827 </span>     }
<span class="n">  828 </span>     screens.moveOp.goBack();
<span class="n">  829 </span>     return false;
<span class="n">  830 </span> }
<span class="n">  831 </span> 
<span class="n">  832 </span> function chooseMarkOp() {
<span class="n">  833 </span>     screens.markOp.show();
<span class="n">  834 </span>     return false;
<span class="n">  835 </span> }
<span class="n">  836 </span> 
<span class="n">  837 </span> function doMark(unread, all) {
<span class="n">  838 </span>     // Mark selected/all as unread/read
<span class="n">  839 </span>     if (theToc.total &gt;= 0) {
<span class="n">  840 </span>         if (!all &amp;&amp; theState.selected &lt;= 0) {
<span class="n">  841 </span>             reportError("No message selected");
<span class="n">  842 </span>         } else {
<span class="n">  843 </span>             iPachyGet((unread ? (all ? "markAllUnread" : "markUnread") :
<span class="n">  844 </span>                         (all ? "markAllRead" : "markRead")));
<span class="n">  845 </span>             if (all) {
<span class="n">  846 </span>                 jumpTo(theState.query); // to recompute unread count
<span class="n">  847 </span>                 // ... which also calls abandonToc, so we needn't update it
<span class="n">  848 </span>             } else {
<span class="n">  849 </span>                 theState.totalUnread += (unread ? 1 : 0) -
<span class="n">  850 </span>                     (theToc.lines[theState.selOffset].unread ? 1 : 0);
<span class="n">  851 </span>                 theToc.lines[theState.selOffset].unread = unread;
<span class="n">  852 </span>                 if (theState.selOffset &gt; 0) doNext(); else show(0,0);
<span class="n">  853 </span>             }
<span class="n">  854 </span>         }
<span class="n">  855 </span>     }
<span class="n">  856 </span>     if (all || theState.selected &lt;= 0) {
<span class="n">  857 </span>         returnToToc();
<span class="n">  858 </span>     } else {
<span class="n">  859 </span>         screens.markOp.goBack();
<span class="n">  860 </span>     }
<span class="n">  861 </span>     return false;
<span class="n">  862 </span> }
<span class="n">  863 </span> 
<span class="n">  864 </span> function chooseSendOp() {
<span class="n">  865 </span>     screens.sendOp.show();
<span class="n">  866 </span>     return false;
<span class="n">  867 </span> }
<span class="n">  868 </span> 
<span class="n">  869 </span> 
<span class="n">  870 </span> //
<span class="n">  871 </span> // Message composition operations
<span class="n">  872 </span> //
<span class="n">  873 </span> 
<span class="n">  874 </span> // Most of this section is used directly from pachyletV2.js, except for
<span class="n">  875 </span> // functions managing the screen.  We don't enumerate the unchanged
<span class="n">  876 </span> // functions.
<span class="n">  877 </span> 
<span class="n">  878 </span> function setupDBodyHeight() {
<span class="n">  879 </span>     // Set the height of the draft body text area
<span class="n">  880 </span>     //
<span class="n">  881 </span>     var dBody = document.getElementById("draftBody");
<span class="n">  882 </span>     dBody.style.height = "" +
<span class="n">  883 </span>         (dBody.offsetParent.clientHeight - dBody.offsetTop) +
<span class="n">  884 </span>         "px";
<span class="n">  885 </span>     // That calculation assumed dBody has no padding/border/margin
<span class="n">  886 </span> }
<span class="n">  887 </span> 
<span class="n">  888 </span> function openDraft(op, draftId) {
<span class="n">  889 </span>     // Commence opening a draft, new or old
<span class="n">  890 </span>     //
<span class="n">  891 </span>     screens.composing.show();
<span class="n">  892 </span>     iPachyGet(op, gotDraft, null, null, draftId);
<span class="n">  893 </span> }
<span class="n">  894 </span> 
<span class="n">  895 </span> function showDraftScreen() {
<span class="n">  896 </span>     // Switch to the draft screen, from modal state
<span class="n">  897 </span>     //
<span class="n">  898 </span>     screens.draft.show();
<span class="n">  899 </span>     setupDBodyHeight();
<span class="n">  900 </span> }
<span class="n">  901 </span> 
<span class="n">  902 </span> function showComposingScreen() {
<span class="n">  903 </span>     // Move to modal state from the draft screen
<span class="n">  904 </span>     //
<span class="n">  905 </span>     screens.composing.show();
<span class="n">  906 </span> }
<span class="n">  907 </span> 
<span class="n">  908 </span> function returnFromDraft() {
<span class="n">  909 </span>     // Exit from the draft screen (which might be modal at the time)
<span class="n">  910 </span>     //
<span class="n">  911 </span>     if (screens.composing.prev == screens.toc &amp;&amp;
<span class="n">  912 </span>             theState.query.folder == 'Unsent') {
<span class="n">  913 </span>         jumpTo(theState.query); // re-evaluate query after send/discard
<span class="n">  914 </span>     } else {
<span class="n">  915 </span>         screens.composing.goBack();
<span class="n">  916 </span>     }
<span class="n">  917 </span>     return false;
<span class="n">  918 </span> }
<span class="n">  919 </span> 
<span class="n">  920 </span> function doResend() {
<span class="n">  921 </span>     reportError("Resend not implemented");
<span class="n">  922 </span>     return false;
<span class="n">  923 </span> }
<span class="n">  924 </span> 
<span class="n">  925 </span> function showRecipients() {
<span class="n">  926 </span>     // Show the "add recipient" screen
<span class="n">  927 </span>     //
<span class="n">  928 </span>     screens.recipient.show();
<span class="n">  929 </span>     if (!theContacts) {
<span class="n">  930 </span>         document.getElementById("recipientList").innerHTML = "Reading ...";
<span class="n">  931 </span>         iPachyGet("getContacts", gotContacts);
<span class="n">  932 </span>     }
<span class="n">  933 </span>     return false;
<span class="n">  934 </span> }
<span class="n">  935 </span> 
<span class="n">  936 </span> function addRecipientDone() {
<span class="n">  937 </span>     // Cleanup after addRecipient
<span class="n">  938 </span>     //
<span class="n">  939 </span>     screens.recipient.goBack();
<span class="n">  940 </span> }
<span class="n">  941 </span> 
<span class="n">  942 </span> function autoSaveDraft(id) {
<span class="n">  943 </span>     // Timed saving of draft, if modified
<span class="n">  944 </span>     if (screens.cur == screens.draft &amp;&amp; lastSavedDraft.id == id) {
<span class="n">  945 </span>         if (!saveIfNeeded(autoSaveDone)) startAutoSave();
<span class="n">  946 </span>     }
<span class="n">  947 </span> }
<span class="n">  948 </span> 
<span class="n">  949 </span> // Not used, because iOS doesn't generate the event
<span class="n">  950 </span> //
<span class="n">  951 </span> function onBeforeUnload() {
<span class="n">  952 </span>     // Save before exit from the program
<span class="n">  953 </span>     if (screens.cur == screens.draft) {
<span class="n">  954 </span>         if (saveIfNeeded()) {
<span class="n">  955 </span>             return "The draft will remain in your Unsent folder";
<span class="n">  956 </span>         }
<span class="n">  957 </span>     }
<span class="n">  958 </span> }
<span class="n">  959 </span> 
<span class="n">  960 </span> 
<span class="n">  961 </span> //
<span class="n">  962 </span> // Contacts (!)
<span class="n">  963 </span> //
<span class="n">  964 </span> 
<span class="n">  965 </span> function keepContact(email, person) {
<span class="n">  966 </span>     // "keep" in a message's recipient list
<span class="n">  967 </span>     reportError("Keep contact not implemented");
<span class="n">  968 </span>     return false;
<span class="n">  969 </span> }
<span class="n">  970 </span> 
<span class="n">  971 </span> 
<span class="n">  972 </span> //
<span class="n">  973 </span> // Initialisation
<span class="n">  974 </span> //
<span class="n">  975 </span> 
<span class="n">  976 </span> function adjustContentsHeight(id, contentsPx) {
<span class="n">  977 </span>     // Adjust screen contents height to fit the display
<span class="n">  978 </span>     var elt = document.getElementById(id);
<span class="n">  979 </span>     elt.style.height = contentsPx;
<span class="n">  980 </span> }
<span class="n">  981 </span> 
<span class="n">  982 </span> function setupScreen(id, seq) {
<span class="n">  983 </span>     // Create one screen object, and adjust its height
<span class="n">  984 </span>     new Screen(id, seq);
<span class="n">  985 </span> }
<span class="n">  986 </span> 
<span class="n">  987 </span> function setupScreens() {
<span class="n">  988 </span>     // Create screen objects
<span class="n">  989 </span>     setupScreen('login',      1);
<span class="n">  990 </span>     setupScreen('loggingIn',  2);
<span class="n">  991 </span>     setupScreen('loggingOut', 2);
<span class="n">  992 </span>     setupScreen('folder',     3);
<span class="n">  993 </span>     setupScreen('toc',        4);
<span class="n">  994 </span>     setupScreen('msg',        5);
<span class="n">  995 </span>     setupScreen('find',       6);
<span class="n">  996 </span>     setupScreen('moveDest',   7.1);
<span class="n">  997 </span>     setupScreen('moveOp',     7.2);
<span class="n">  998 </span>     setupScreen('markOp',     8);
<span class="n">  999 </span>     setupScreen('sendOp',     9.1);
<span class="n"> 1000 </span>     setupScreen('composing',  9.2);
<span class="n"> 1001 </span>     setupScreen('draft',      9.2);
<span class="n"> 1002 </span>     setupScreen('recipient',  10);
<span class="n"> 1003 </span>     screens.cur = screens.login;
<span class="n"> 1004 </span> }
<span class="n"> 1005 </span> 
<span class="n"> 1006 </span> function setupHeights() {
<span class="n"> 1007 </span>     // Adjust elements that are sized to fit the current screen height
<span class="n"> 1008 </span>     window.scrollTo(0, 0); // scrolls Mobile Safari's header off-screen
<span class="n"> 1009 </span>     var contentsHeight = windowSize().y - 2 * 43;
<span class="n"> 1010 </span>     var contentsPx = "" + contentsHeight + "px";
<span class="n"> 1011 </span>     adjustContentsHeight("login", contentsPx);
<span class="n"> 1012 </span>     adjustContentsHeight("loggingIn", contentsPx);
<span class="n"> 1013 </span>     adjustContentsHeight("loggingOut", contentsPx);
<span class="n"> 1014 </span>     adjustContentsHeight("folderList", contentsPx);
<span class="n"> 1015 </span>     adjustContentsHeight("tocWrapper", contentsPx);
<span class="n"> 1016 </span>     adjustContentsHeight("findWrapper", contentsPx);
<span class="n"> 1017 </span>     adjustContentsHeight("msgContents", contentsPx);
<span class="n"> 1018 </span>     adjustContentsHeight("moveDestList", contentsPx);
<span class="n"> 1019 </span>     // The "*opWrapper" elements exist because their children have padding
<span class="n"> 1020 </span>     adjustContentsHeight("moveOpWrapper", contentsPx);
<span class="n"> 1021 </span>     adjustContentsHeight("markOpWrapper", contentsPx);
<span class="n"> 1022 </span>     adjustContentsHeight("sendOpWrapper", contentsPx);
<span class="n"> 1023 </span>     adjustContentsHeight("composing", contentsPx);
<span class="n"> 1024 </span>     adjustContentsHeight("draftWrapper", contentsPx);
<span class="n"> 1025 </span>     adjustContentsHeight("recipientList", contentsPx);
<span class="n"> 1026 </span>     tocScrollbar = newTocScrollbar();
<span class="n"> 1027 </span>     theState.tocPageSize =
<span class="n"> 1028 </span>         Math.floor((contentsHeight + 3) / tocItemHeight);
<span class="n"> 1029 </span> }
<span class="n"> 1030 </span> 
<span class="n"> 1031 </span> function rotated() {
<span class="n"> 1032 </span>     setupHeights();
<span class="n"> 1033 </span>     // Force TOC redisplay for new page size, also re-applying bounds for
<span class="n"> 1034 </span>     // new page size.
<span class="n"> 1035 </span>     if (theToc.total &gt;= 0) {
<span class="n"> 1036 </span>         var dest = theState.offset;
<span class="n"> 1037 </span>         theState.offset = -1;
<span class="n"> 1038 </span>         scrollTocTo(dest, false); // always sets theState.offset
<span class="n"> 1039 </span>     }
<span class="n"> 1040 </span>     if (screens.cur == screens.draft) setupDBodyHeight();
<span class="n"> 1041 </span> }
<span class="n"> 1042 </span> 
<span class="n"> 1043 </span> function runDirectly() {
<span class="n"> 1044 </span>     // Run without installing home screen link
<span class="n"> 1045 </span>     document.getElementById("loginTable").style.display = "block";
<span class="n"> 1046 </span>     document.getElementById("useHome").style.display = "none";
<span class="n"> 1047 </span>     document.getElementById("useHome2").style.display = "none";
<span class="n"> 1048 </span>     autoLogin();
<span class="n"> 1049 </span>     return false;
<span class="n"> 1050 </span> }
<span class="n"> 1051 </span> 
<span class="n"> 1052 </span> function init() {
<span class="n"> 1053 </span>     new Button("tocLater");
<span class="n"> 1054 </span>     new Button("tocEarlier");
<span class="n"> 1055 </span>     new Button("scan1");
<span class="n"> 1056 </span>     new Button("scan2");
<span class="n"> 1057 </span>     new Button("scan3");
<span class="n"> 1058 </span>     new Button("prev");
<span class="n"> 1059 </span>     new Button("next");
<span class="n"> 1060 </span>     new Button("next2");
<span class="n"> 1061 </span>     new Button("drop");
<span class="n"> 1062 </span>     new Button("trash");
<span class="n"> 1063 </span>     new Button("reply");
<span class="n"> 1064 </span>     new Button("replyAll");
<span class="n"> 1065 </span>     new Button("forward");
<span class="n"> 1066 </span>     new Button("resend");
<span class="n"> 1067 </span>     window.onbeforeunload = onBeforeUnload;
<span class="n"> 1068 </span>     user = getQueryArg("user");
<span class="n"> 1069 </span>     if (!user) user = getCookie("ipachyuser");
<span class="n"> 1070 </span>     if (!user) user = getCookie("pachyuser");
<span class="n"> 1071 </span>     if (!user) user = "";
<span class="n"> 1072 </span>     document.getElementById("loginUser").value = user;
<span class="n"> 1073 </span>     document.getElementById("loginTable").style.visibility = "visible";
<span class="n"> 1074 </span>     var prevFolder = getCookie("ipachyfolder");
<span class="n"> 1075 </span>     if (typeof(prevFolder) != "string") prevFolder = "";
<span class="n"> 1076 </span>     theState = new State(new Query(prevFolder));
<span class="n"> 1077 </span>     
<span class="n"> 1078 </span>     if (isIphone() &amp;&amp; !window.navigator.standalone) {
<span class="n"> 1079 </span>         document.getElementById("loginTable").style.display = "none";
<span class="n"> 1080 </span>         document.getElementById("useHome").style.display = "block";
<span class="n"> 1081 </span>         document.getElementById("useHome2").style.display = "block";
<span class="n"> 1082 </span>     } else {
<span class="n"> 1083 </span>         autoLogin();
<span class="n"> 1084 </span>     }
<span class="n"> 1085 </span>     setupScreens();
<span class="n"> 1086 </span>     setTimeout(setupHeights, 0);
<span class="n"> 1087 </span> }
</div>
<div class="pad"><span class="n">      </span></div>
<div class="cr">End of listing</div>
</div> <!-- inner -->
</div> <!-- outer -->


</body></html>