<?php

/*
 * Implements hook_rules_event_info
 * 
 */

function restaurant_rules_rules_event_info() {
    return array(
        'restaurant_rules_views_render' => array(
            'label' => 'Une vue est affichée',
            'group' =>  'Restaurant Rules',
            'variables' => array(
                'view' => array(
                    'type' => 'restaurant_rules_view_datatype',
                    'label' => t('La vue qui est affichée'),
                )
            )
        )
    );
}

/**
 * Implements hook_rules_data_info()
 * Ici nous indiquons à Rules qu'il s'agit d'un objet de type View
 */

function restaurant_rules_rules_data_info() {
    return array(
        'restaurant_rules_view_datatype' => array(
            'label' => t('view')
        ),
    );
    
}

/**
 * Implements hook_rules_condition_info
 * On déclare notre condition
 */

function restaurant_rules_rules_condition_info() {
    return array(
        'restaurant_rules_views_condition' => array(
            'label' => t('La vue affichée est'),
            'parameter' => array(
                'view' => array(
                    'type' => 'text',
                    'label' =>  t('Vue et affichage'),
                    'options list' => 'restaurant_rules_view_list',
                    'description' => t('Selectionner la vue et l\id de l\'affichage'),
                    'restriction' => 'input',
                ),
            ),
            'group' => t('Restaurant Rules'),
        ),
    );
}

/**
 * Fonction qui renvoie la liste de toutes les vues activées du site
 */
function restaurant_rules_view_list() {
    $views = array();
    foreach (views_get_enabled_views() as  $view_name => $view) {
        foreach ($view->display as $display_name => $display) {
            $views[$view_name . '-' . $display_name] = check_plain($view->human_name) . ' - ' . check_plain($display->display_title);
        }
    }
    return $views;
}

/**
 * Callback fonction pour notre condition personnalisé
 * Le nom de la fonction doit correspondre à la clé du tableau dans notre restaurant_rules_conditition_info
 */

function restaurant_rules_views_condition($view = array()) {
    $current_view = views_get_current_view();
    $parts = explode('-', $view);
    if(($parts[0] == $current_view->name) && ($parts[1] == $current_view->current_display)) {
        return TRUE;
    }
    return FALSE;
}

/**
 * Implements hook_rules_action_info
 */

function restaurant_rules_rules_action_info() {
    return array(
        'restaurant_rules_update_table' => array(
            'label' => t('Mise à jour de la table des affichages de vues'),
            'parameter' => array(
                'view' => array(
                    'type' => 'restaurant_rules_view_datatype',
                    'label' => t('La vue affichée'),
                ),
            ),
            'group' => t('Restaurant Rules'),
        ),
    );
}

/**
 * La fonction de base de donnée appelée par l'action de Rules
 * Le nom de la fonction doit être le même que celui déclaré dans le hook_rules_action_info
 */

function restaurant_rules_update_table($view) {
    // On teste pour vérifier que la vue est bien un objet
    if (!is_object($view)) {
        return FALSE;
    }
    // On séléctionne la vue concernée en base
    $result = db_select('restaurant_rules_views_render','r')
            ->fields('r')
            ->condition('view', $view->name .'_'. $view->current_display, '=')
            ->execute()
            ->fetchAssoc();
    // S'il y a des résultats sur le select, on met à jour
    if($result) {
        $update = db_update('restaurant_rules_views_render')
                ->expression('rendered', 'rendered + :one', array(':one' => 1))
                ->condition('view', $view->name .'_'. $view->current_display, '=')
                ->execute();
    }
    else {
        $insert = db_insert('restaurant_rules_views_render')
                ->fields(array(
                    'view' => $view->name .'_'. $view->current_display,
                    'rendered' => 1
                ))
                ->execute();
    }
    
}