<?php
/**
 * @file
 * bookdev_slideshow2.features.inc
 */

/**
 * Implements hook_views_api().
 */
function bookdev_slideshow2_views_api($module = NULL, $api = NULL) {
  return array("api" => "3.0");
}

/**
 * Implements hook_image_default_styles().
 */
function bookdev_slideshow2_image_default_styles() {
  $styles = array();

  // Exported image style: bandeau_930x240.
  $styles['bandeau_930x240'] = array(
    'name' => 'bandeau_930x240',
    'label' => 'bandeau 930x240',
    'effects' => array(
      1 => array(
        'label' => 'Redimensionner',
        'help' => 'Le redimensionnement ne respecte pas les proportions de l\'image. Ce qui peut se traduire par des images étirées ou compressées.',
        'effect callback' => 'image_resize_effect',
        'dimensions callback' => 'image_resize_dimensions',
        'form callback' => 'image_resize_form',
        'summary theme' => 'image_resize_summary',
        'module' => 'image',
        'name' => 'image_resize',
        'data' => array(
          'width' => 930,
          'height' => 240,
        ),
        'weight' => 1,
      ),
    ),
  );

  return $styles;
}

/**
 * Implements hook_node_info().
 */
function bookdev_slideshow2_node_info() {
  $items = array(
    'slideshow' => array(
      'name' => t('slideshow'),
      'base' => 'node_content',
      'description' => t('Type de contenu pour le slideshow'),
      'has_title' => '1',
      'title_label' => t('Title'),
      'help' => '',
    ),
  );
  return $items;
}
