<?php
/**
 * @file
 * Returns the HTML for a node.
 *
 * Complete documentation for this file is available online.
 * @see https://drupal.org/node/1728164
 */
?>
<article class="node-<?php print $node->nid; ?> <?php print $classes; ?> clearfix"<?php print $attributes; ?>>
    <header>
        <h2>
<?php
		print l ( $title, $node_url, array (
				'attributes' => array (
						'title' => t($title),
					),
				'html' => TRUE 
				) 
			);
?>
</h2>
    </header>

    <div id="node-author">
        <?php
        print $user_picture;
        print $name;
        ?>
    </div>

    <div id="body-node">
          <?php
            print render($content['body']);
          ?>
    </div>
    <div id="node-og-audience">
        <?php
            print render($content['og_group_ref']);
        ?>
    </div>
    <div id="comment-node">
        <?php 
            print render($content['comments']);
        ?>
    </div>
    <div id="node-links">
        <?php
            print render($content['links']);
        ?>
    </div>



</article>
