// breaksys.c : auteur: Jean-Francois BOUCHAUDY
// $Id: breaksys.c,v 1.6 2010/09/04 10:30:23 root Exp root $ 
// PREREQUIS: (pour certains problemes)
//    - l'utilisateur guest existe, il peut se connecter (mot de passe...)
//    - /boot est un FS
//    - le package Cups (cupsd) est installe
//    - le service telnet est present
//    - Avoir un systeme annexe de demarrage (exos de type "BOOT")

# include <stdio.h>
# include <stdlib.h>
# include <string.h>
void casse_1();
void casse_2();
void casse_3();
void casse_4();
void casse_5();
void casse_6();
void casse_7();
void casse_8();
void casse_9();
void casse_10();
void casse_11();
void casse_12();
void casse_13();
void casse_14();
void casse_15();
void casse_16();
void casse_17();
void affiche(char * str);

main() {
	char saisie[256];
	int choix;
	printf("\n\n\t\tNature des problemes\n\n");
	puts(" 1 - crontab");
	puts(" 2 - crontab");
	puts(" 3 - crontab");
	puts(" 4 - utilisateurs & droits");
	puts(" 5 - utilisateurs & droits");
	puts(" 6 - utilisateurs & droits");
	puts(" 7 - utilisateurs & droits");
	puts(" 8 - syslog");
	puts(" 9 - FS");
	puts("10 - FS");
	puts("11 - FS");
	puts("12 - Demarrage [long]");
	puts("13 - Demarrage");
	puts("14 - mail");
	puts("15 - mail");
	puts("16 - Reseau");
	puts("17 - Reseau");
	printf("\nVotre choix (99:sortie) ? ");
	fgets(saisie,10,stdin);
	choix = atoi(saisie);
	switch(choix) {
	case  1: casse_1();  break;
	case  2: casse_2();  break;
	case  3: casse_3();  break;
	case  4: casse_4();  break;
	case  5: casse_5();  break;
	case  6: casse_6();  break;
	case  7: casse_7();  break;
	case  8: casse_8();  break;
	case  9: casse_9();  break;
	case 10: casse_10(); break;
	case 11: casse_11(); break;
	case 12: casse_12(); break;
	case 13: casse_13(); break;
	case 14: casse_14(); break;
	case 15: casse_15(); break;
	case 16: casse_16(); break;
	case 17: casse_17(); break;
	}
	puts(".... Le systeme est casse!");
}
void affiche(char * str) {
	char saisie[256];
	puts("===========================================================");
	printf("\n\n%s\n\n", str );
	puts("===========================================================");
	puts("[Le systeme sera endomage apres avoir frappe sur validation]");
	puts("...Vous pouvez encore interrompre le programme par Ctrl-C!");
	fgets(saisie,10,stdin);
}

void casse_1() {
	affiche("l'utilisateur guest ne peut pas creer de crontab");
	// --- on supprime le droit SUID a /usr/bin/crontab
	// --- REPARATION: chmod u+s /usr/bin/crontab
	// --- DIAGNOSTIC: rpm -qV cronie
	system("chmod u-s /usr/bin/crontab");
}

void casse_2() {
	affiche("l'utilisateur guest ne peut pas creer de crontab");
	// --- on cree le fichier /etc/cron.allow
	// --- REPARATION: rm /etc/cron.allow
	// --- DIAGNOSTIC: man crontab (section FILE); ls -l /etc/cron.*
	system("touch /etc/cron.allow");
}

void casse_3() {
	affiche("Les crontabs de guest ne fonctionnent pas");
	// --- on tue crond
	// --- REPARATION: /etc/init.d/crond restart
	// --- DIAGNOSTIC: ps -e |grep cron
	system("pkill cron");
}

void casse_4() {
	affiche("On ne peut plus creer des utilisateurs");
	// --- on change les attributs de /etc/passwd
	// --- REPARATION: chattr -i /etc/passwd
	// --- DIAGNOSTIC: lsattr /etc/passwd
	system("chattr +i /etc/passwd");
}

void casse_5() {
	affiche("guest ne peut plus se connecter en mode texte");
	// --- on change son shell de connexion
	// --- REPARATION: chsh -s /bin/bash guest
	system("if ! grep false /etc/shells >/dev/null 2>&1;then echo /bin/false >>/etc/shells;fi");
	// --- DIAGNOSTIC: getentd passwd guest
	system("chsh -s /bin/false guest >/dev/null 2>&1");
}

void casse_6() {
	affiche("guest ne peut plus modifier un fichier qui vient d'etre\ncree avec vi - il faut au prealable de se deconnecter");
	// --- on ajoute un umask 700 au .bash_profile de guest
	// --- REPARATION: on change en "umask 77"
	// --- DIAGNOSTIC: ls -l ; umask
	system("echo 'umask 700' >> ~guest/.bash_profile");
}

void casse_7() {
	affiche("guest ne peut plus se connecter");
	// --- le compte a expire 
	// --- REPARATION: chage -E -1 guest
	// --- DIAGNIOSTIC: tail /var/log/secure
	system("chage -E 1999-12-31 guest");
}

void casse_8() {
	affiche("Le log de cron (/var/log/cron) n'est plus mis a jour");
	// --- il y a une erreur de syntaxe dans rsyslog.conf (un blanc de trop)
	// --- REPARATION: on supprime le blanc et on previent syslogd
	// --- DIAGNOSTIC: more /etc/rsyslog.conf
	system("mv /var/log/cron /var/log/cron.old");
	system("sed '/^cron/s/cron./cron. /' /etc/rsyslog.conf > /tmp/bidule$$; mv /tmp/bidule$$ /etc/rsyslog.conf; pkill -1 rsyslogd");
	system("clear; sleep 1; clear");
}

void casse_9() {
	affiche("Impossible de creer des fichiers dans /boot");
	// --- On remonte /boot en lecure seule
	// --- REPARATION: mount -o remount /boot
	// --- DIAGNOSTIC: mount |grep boot
	system("mount -o remount,ro /boot");
//	system("mount -o remount,ro /home");
}

void casse_10() {
	affiche("Impossible de demonter /boot");
	// --- Une application utilise un fichier de /boot
	// --- REPARATION: on tue l'application : lsof | grep /boot; kill ...
	system("{ cd /boot/grub;sleep 3600; }&");
//	system("{ cd /home;sleep 3600; }&");
}

void casse_11() {
	affiche("/boot commence a etre plein, faites le menage!");
	// --- Une application cree des fichiers dans /boot
	// REPARATION: rm /boot/.TTT*
	// DIAGNOSTIC: find /boot -size +100
	system("for i in 1 2 3 4 5 6 7 8 9;do dd if=/dev/zero of=/boot/.TTT$i count=100 bs=512k >/dev/null 2>&1;done");
//	system("for i in 1 2 3 4 5 6;do dd if=/dev/zero of=/home/.TTT$i count=1000 >/dev/null 2>&1;done");
}

void casse_12() {
	affiche("LE SYSTEME NE REDEMARRE PAS!!!");
	// --- On n'a plus de fichier BASH !!!
	// --- RESOLUTION: on demarre en "linux rescue" et
	//     on recupere le shell a partir des sauvegardes
	// --- DIAGNOSTIC: dans grub changer "rhgb quiet" par "verbose vga=792"
	//     ls -lb /bin/bash*
	system("cp /bin/bash /root");
	system("mv /bin/bash /bin/'bash '");
	system("sleep 3; halt");
}

void casse_13() {
	affiche("Le systeme demarre mal (pas de reseau, ...)");
	// --- On a renomme le repertoire qui comprend les modules
	// --- RESOLUTION: on renome correctement le repertoire
	system("mv /lib/modules/$(uname -r) /lib/modules/$(uname -r)X");
	system("sleep 3; halt");
}

void casse_14() {
	// --- on modifie le fichier de configuration
	// --- RESOLUTION: supprimer la derniere ligne de /etc/postifx/main.cf
	// --- DIAGNOSTIC: tail /var/log/maillog; postfix check
	affiche("Le courrier ne fonctionne plus!");
	system("echo XXXX >> /etc/postfix/main.cf");
	system("pkill master");
}

void casse_15() {
	affiche("L'utilisateur guest ne recoit plus de courrier");
	// --- on change le proprietaire du repertoire recevant le courrier
	// --- RESOLUTION: chown postfix /var/spool/postfix/maildrop
	// --- DIAGNOSTIC: more /var/log/maillog
	system("chown root /var/spool/postfix/maildrop");
}

void casse_16() {
	char ch[1000];
	affiche("Apache ne veut pas demarrer");
	// --- Une application a ouvert le port 80 
	// --- RESOLUTION: netstat -anpe | grep ':80.*LISTEN'
	//     kill ... ; /etc/init.d/httpd restart
	strcpy(ch,"perl -e '");
	strcat(ch,"use IO::Socket::INET;");
	strcat(ch,"$p=IO::Socket::INET->new(LocalPort=>80,Type=>SOCK_STREAM,Reuse=>1,Listen=>1);");
	strcat(ch,"while($pj=$p->accept()) { close $pj; }");
	strcat(ch,"'  &");
	system("/etc/init.d/httpd stop; sleep 3");
	system(ch);
}

void casse_17() {
	char ch[1000];
	strcpy(ch,"Dans le repertoire courant, il y a l'application\n");
	strcat(ch,"<<securise>>. Lancer cette application. Que fait-elle?");
	strcat(ch,"Comment resoudre les problemes qu'elle a engendres ?");
	affiche(ch);
	// --- un pare-feu IPTABLES supprime les paquets entrants locaux
	// --- DIAGNOSTIC: strace -f ./securise >result 2>&1; iptables -L
	// --- RESOLUTION: iptables -F
}
