/*
 * Decompiled with CFR 0.152.
 */
package net.zhuoweizhang.raspberryjuice;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import net.zhuoweizhang.raspberryjuice.RaspberryJuicePlugin;
import net.zhuoweizhang.raspberryjuice.RemoteSession;

public class ServerListenerThread
implements Runnable {
    public ServerSocket serverSocket;
    public SocketAddress bindAddress;
    public boolean running = true;
    private RaspberryJuicePlugin plugin;

    public ServerListenerThread(RaspberryJuicePlugin plugin, SocketAddress bindAddress) throws IOException {
        this.plugin = plugin;
        this.bindAddress = bindAddress;
        this.serverSocket = new ServerSocket();
        this.serverSocket.setReuseAddress(true);
        this.serverSocket.bind(bindAddress);
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                Socket newConnection = this.serverSocket.accept();
                if (!this.running) {
                    return;
                }
                this.plugin.handleConnection(new RemoteSession(this.plugin, newConnection));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            this.serverSocket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

