/*
 * Decompiled with CFR 0.152.
 */
package net.zhuoweizhang.raspberryjuice;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.zhuoweizhang.raspberryjuice.RemoteSession;
import net.zhuoweizhang.raspberryjuice.ServerListenerThread;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class RaspberryJuicePlugin
extends JavaPlugin
implements Listener {
    public static final Set<Material> blockBreakDetectionTools = EnumSet.of(Material.DIAMOND_SWORD, Material.GOLD_SWORD, Material.IRON_SWORD, Material.STONE_SWORD, Material.WOOD_SWORD);
    public static final int DEFAULT_PORT = 4711;
    public ServerListenerThread serverThread;
    public List<RemoteSession> sessions;
    public Player hostPlayer = null;
    private int tickTimerId = -1;

    public void onEnable() {
        this.sessions = new ArrayList<RemoteSession>();
        try {
            this.serverThread = new ServerListenerThread(this, new InetSocketAddress(4711));
            new Thread(this.serverThread).start();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.tickTimerId = this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)new TickHandler(), 1L, 1L);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ItemStack currentTool = event.getPlayer().getItemInHand();
        if (currentTool == null || !blockBreakDetectionTools.contains(currentTool.getType())) {
            return;
        }
        for (RemoteSession session : this.sessions) {
            session.queuePlayerInteractEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleConnection(RemoteSession newSession) {
        if (this.checkBanned(newSession)) {
            System.out.println("Kicking " + newSession.getSocket().getRemoteSocketAddress() + " because the IP address has been banned.");
            newSession.kick("You've been banned from this server!");
            return;
        }
        List<RemoteSession> list = this.sessions;
        synchronized (list) {
            this.sessions.add(newSession);
        }
    }

    public Player getNamedPlayer(String name) {
        if (name == null) {
            return null;
        }
        Player[] allPlayers = this.getServer().getOnlinePlayers();
        int i = 0;
        while (i < allPlayers.length) {
            if (name == allPlayers[i].getPlayerListName()) {
                return allPlayers[i];
            }
            ++i;
        }
        return null;
    }

    public Player getHostPlayer() {
        if (this.hostPlayer != null) {
            return this.hostPlayer;
        }
        Player[] allPlayers = this.getServer().getOnlinePlayers();
        if (allPlayers.length >= 1) {
            return allPlayers[0];
        }
        return null;
    }

    public boolean checkBanned(RemoteSession session) {
        Set ipBans = this.getServer().getIPBans();
        String sessionIp = session.getSocket().getInetAddress().getHostAddress();
        return ipBans.contains(sessionIp);
    }

    public void onDisable() {
        this.serverThread.running = false;
        try {
            this.serverThread.serverSocket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        for (RemoteSession session : this.sessions) {
            try {
                session.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.sessions = null;
        this.serverThread = null;
    }

    private class TickHandler
    implements Runnable {
        private TickHandler() {
        }

        @Override
        public void run() {
            Iterator<RemoteSession> sI = RaspberryJuicePlugin.this.sessions.iterator();
            while (sI.hasNext()) {
                RemoteSession s = sI.next();
                if (s.pendingRemoval) {
                    s.close();
                    sI.remove();
                    continue;
                }
                s.tick();
            }
        }
    }
}

