/*
 * Decompiled with CFR 0.152.
 */
package net.zhuoweizhang.raspberryjuice;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.ArrayDeque;
import net.zhuoweizhang.raspberryjuice.RaspberryJuicePlugin;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;

public class RemoteSession {
    private Location origin;
    private Socket socket;
    private BufferedReader in;
    private BufferedWriter out;
    private ArrayDeque<String> inQueue = new ArrayDeque();
    private ArrayDeque<String> outQueue = new ArrayDeque();
    public boolean running = true;
    public boolean pendingRemoval = false;
    public RaspberryJuicePlugin plugin;
    protected ArrayDeque<PlayerInteractEvent> interactEventQueue = new ArrayDeque();
    private int maxCommandsPerTick = 9000;
    private boolean closed = false;
    private Player attachedPlayer = null;

    public RemoteSession(RaspberryJuicePlugin plugin, Socket socket) throws IOException {
        this.socket = socket;
        this.plugin = plugin;
        this.init();
    }

    public void init() throws IOException {
        this.socket.setTcpNoDelay(true);
        this.socket.setKeepAlive(true);
        this.socket.setTrafficClass(16);
        this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.out = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
        this.startThreads();
        this.plugin.getLogger().info("Opened connection to" + this.socket.getRemoteSocketAddress() + ".");
    }

    protected void startThreads() {
        new Thread(new InputThread()).start();
        new Thread(new OutputThread()).start();
    }

    public Location getOrigin() {
        return this.origin;
    }

    public void setOrigin(Location origin) {
        this.origin = origin;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void queuePlayerInteractEvent(PlayerInteractEvent event) {
        this.plugin.getLogger().info(event.toString());
        this.interactEventQueue.add(event);
    }

    public void tick() {
        String message;
        if (this.origin == null) {
            this.origin = ((World)this.plugin.getServer().getWorlds().get(0)).getSpawnLocation();
        }
        int processedCount = 0;
        while ((message = this.inQueue.poll()) != null) {
            this.handleLine(message);
            if (++processedCount < this.maxCommandsPerTick) continue;
            this.plugin.getLogger().warning("Over " + this.maxCommandsPerTick + " commands were queued - deferring " + this.inQueue.size() + " to next tick");
            break;
        }
        if (!this.running && this.inQueue.size() <= 0) {
            this.pendingRemoval = true;
        }
    }

    protected void handleLine(String line) {
        String methodName = line.substring(0, line.indexOf("("));
        String[] args = line.substring(line.indexOf("(") + 1, line.length() - 1).split(",");
        this.handleCommand(methodName, args);
    }

    protected void handleCommand(String c, String[] args) {
        World world = this.origin.getWorld();
        Server server = this.plugin.getServer();
        if (c.equals("world.getBlock")) {
            Location loc = this.parseRelativeBlockLocation(args[0], args[1], args[2]);
            this.send(world.getBlockTypeIdAt(loc));
        } else if (c.equals("world.getBlocks")) {
            Location loc1 = this.parseRelativeBlockLocation(args[0], args[1], args[2]);
            Location loc2 = this.parseRelativeBlockLocation(args[3], args[4], args[5]);
            this.send(this.getBlocks(loc1, loc2));
        } else if (c.equals("world.getBlockWithData")) {
            Location loc = this.parseRelativeBlockLocation(args[0], args[1], args[2]);
            this.send(String.valueOf(world.getBlockTypeIdAt(loc)) + "," + world.getBlockAt(loc).getData());
        } else if (c.equals("world.setBlock")) {
            Location loc = this.parseRelativeBlockLocation(args[0], args[1], args[2]);
            world.getBlockAt(loc).setTypeIdAndData(Integer.parseInt(args[3]), args.length > 4 ? Byte.parseByte(args[4]) : (byte)0, true);
        } else if (c.equals("world.setBlocks")) {
            Location loc1 = this.parseRelativeBlockLocation(args[0], args[1], args[2]);
            Location loc2 = this.parseRelativeBlockLocation(args[3], args[4], args[5]);
            int blockType = Integer.parseInt(args[6]);
            byte data = args.length > 7 ? Byte.parseByte(args[7]) : (byte)0;
            this.setCuboid(loc1, loc2, blockType, data);
        } else if (c.equals("world.getPlayerIds")) {
            StringBuilder bdr = new StringBuilder();
            Player[] playerArray = server.getOnlinePlayers();
            int data = playerArray.length;
            int blockType = 0;
            while (blockType < data) {
                Player p = playerArray[blockType];
                bdr.append(p.getEntityId());
                bdr.append("|");
                ++blockType;
            }
            this.send(bdr.toString());
        } else if (c.equals("chat.post")) {
            server.broadcastMessage(args[0]);
        } else if (c.equals("events.clear")) {
            this.interactEventQueue.clear();
        } else if (c.equals("events.block.hits")) {
            PlayerInteractEvent event;
            StringBuilder b = new StringBuilder();
            while ((event = this.interactEventQueue.poll()) != null) {
                Block block = event.getClickedBlock();
                Location loc = block.getLocation();
                b.append(this.blockLocationToRelative(loc));
                b.append(",");
                b.append(RemoteSession.blockFaceToNotch(event.getBlockFace()));
                b.append(",");
                b.append(event.getPlayer().getEntityId());
                if (this.interactEventQueue.size() <= 0) continue;
                b.append("|");
            }
            System.out.println(b.toString());
            this.send(b.toString());
        } else if (c.equals("player.getTile")) {
            String name = null;
            if (args.length > 0) {
                name = args[0];
            }
            Player currentPlayer = this.getCurrentPlayer(name);
            this.send(this.blockLocationToRelative(currentPlayer.getLocation()));
        } else if (c.equals("player.setTile")) {
            String name = null;
            String x = args[0];
            String y = args[1];
            String z = args[2];
            if (args.length > 3) {
                name = args[0];
                x = args[1];
                y = args[2];
                z = args[3];
            }
            Player currentPlayer = this.getCurrentPlayer(name);
            currentPlayer.teleport(this.parseRelativeBlockLocation(x, y, z));
        } else if (c.equals("player.getPos")) {
            String name = null;
            if (args.length > 0) {
                name = args[0];
            }
            Player currentPlayer = this.getCurrentPlayer(name);
            this.send(this.locationToRelative(currentPlayer.getLocation()));
        } else if (c.equals("player.setPos")) {
            String name = null;
            String x = args[0];
            String y = args[1];
            String z = args[2];
            if (args.length > 3) {
                name = args[0];
                x = args[1];
                y = args[2];
                z = args[3];
            }
            Player currentPlayer = this.getCurrentPlayer(name);
            currentPlayer.teleport(this.parseRelativeLocation(x, y, z));
        } else if (c.equals("world.getHeight")) {
            this.send(world.getHighestBlockYAt(this.parseRelativeBlockLocation(args[0], "0", args[1])) - this.origin.getBlockY());
        } else {
            System.err.println(String.valueOf(c) + " has not been implemented.");
            this.send("Fail");
        }
    }

    private void setCuboid(Location pos1, Location pos2, int blockType, byte data) {
        World world = pos1.getWorld();
        int minX = pos1.getBlockX() < pos2.getBlockX() ? pos1.getBlockX() : pos2.getBlockX();
        int maxX = pos1.getBlockX() >= pos2.getBlockX() ? pos1.getBlockX() : pos2.getBlockX();
        int minY = pos1.getBlockY() < pos2.getBlockY() ? pos1.getBlockY() : pos2.getBlockY();
        int maxY = pos1.getBlockY() >= pos2.getBlockY() ? pos1.getBlockY() : pos2.getBlockY();
        int minZ = pos1.getBlockZ() < pos2.getBlockZ() ? pos1.getBlockZ() : pos2.getBlockZ();
        int maxZ = pos1.getBlockZ() >= pos2.getBlockZ() ? pos1.getBlockZ() : pos2.getBlockZ();
        int x = minX;
        while (x <= maxX) {
            int z = minZ;
            while (z <= maxZ) {
                int y = minY;
                while (y <= maxY) {
                    world.getBlockAt(x, y, z).setTypeIdAndData(blockType, data, true);
                    ++y;
                }
                ++z;
            }
            ++x;
        }
    }

    private String getBlocks(Location pos1, Location pos2) {
        StringBuilder blockData = new StringBuilder();
        World world = pos1.getWorld();
        int minX = pos1.getBlockX() < pos2.getBlockX() ? pos1.getBlockX() : pos2.getBlockX();
        int maxX = pos1.getBlockX() >= pos2.getBlockX() ? pos1.getBlockX() : pos2.getBlockX();
        int minY = pos1.getBlockY() < pos2.getBlockY() ? pos1.getBlockY() : pos2.getBlockY();
        int maxY = pos1.getBlockY() >= pos2.getBlockY() ? pos1.getBlockY() : pos2.getBlockY();
        int minZ = pos1.getBlockZ() < pos2.getBlockZ() ? pos1.getBlockZ() : pos2.getBlockZ();
        int maxZ = pos1.getBlockZ() >= pos2.getBlockZ() ? pos1.getBlockZ() : pos2.getBlockZ();
        int y = minY;
        while (y <= maxY) {
            int x = minX;
            while (x <= maxX) {
                int z = minZ;
                while (z <= maxZ) {
                    blockData.append(String.valueOf(new Integer(world.getBlockTypeIdAt(x, y, z)).toString()) + ",");
                    ++z;
                }
                ++x;
            }
            ++y;
        }
        return blockData.substring(0, blockData.length() > 0 ? blockData.length() - 1 : 0);
    }

    public Player getCurrentPlayer(String name) {
        Player player = this.plugin.getNamedPlayer(name);
        if (player == null && (player = this.attachedPlayer) == null) {
            player = this.plugin.getHostPlayer();
        }
        return player;
    }

    public Location parseRelativeBlockLocation(String xstr, String ystr, String zstr) {
        int x = (int)Double.parseDouble(xstr);
        int y = (int)Double.parseDouble(ystr);
        int z = (int)Double.parseDouble(zstr);
        return new Location(this.origin.getWorld(), (double)(this.origin.getBlockX() + x), (double)(this.origin.getBlockY() + y), (double)(this.origin.getBlockZ() + z));
    }

    public Location parseRelativeLocation(String xstr, String ystr, String zstr) {
        double x = Double.parseDouble(xstr);
        double y = Double.parseDouble(ystr);
        double z = Double.parseDouble(zstr);
        return new Location(this.origin.getWorld(), this.origin.getX() + x, this.origin.getY() + y, this.origin.getZ() + z);
    }

    public String blockLocationToRelative(Location loc) {
        return String.valueOf(loc.getBlockX() - this.origin.getBlockX()) + "," + (loc.getBlockY() - this.origin.getBlockY()) + "," + (loc.getBlockZ() - this.origin.getBlockZ());
    }

    public String locationToRelative(Location loc) {
        return String.valueOf(loc.getX() - this.origin.getX()) + "," + (loc.getY() - this.origin.getY()) + "," + (loc.getZ() - this.origin.getZ());
    }

    public void send(Object a) {
        this.send(a.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String a) {
        if (this.pendingRemoval) {
            return;
        }
        ArrayDeque<String> arrayDeque = this.outQueue;
        synchronized (arrayDeque) {
            this.outQueue.add(a);
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.running = false;
        this.pendingRemoval = true;
        try {
            this.socket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.plugin.getLogger().info("Closed connection to" + this.socket.getRemoteSocketAddress() + ".");
    }

    public void kick(String reason) {
        try {
            this.out.write(reason);
            this.out.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.close();
    }

    public static int blockFaceToNotch(BlockFace face) {
        switch (face) {
            case DOWN: {
                return 0;
            }
            case UP: {
                return 1;
            }
            case NORTH: {
                return 2;
            }
            case SOUTH: {
                return 3;
            }
            case WEST: {
                return 4;
            }
            case EAST: {
                return 5;
            }
        }
        return 7;
    }

    static /* synthetic */ ArrayDeque access$2(RemoteSession remoteSession) {
        return remoteSession.outQueue;
    }

    static /* synthetic */ BufferedWriter access$3(RemoteSession remoteSession) {
        return remoteSession.out;
    }

    private class InputThread
    implements Runnable {
        private InputThread() {
        }

        @Override
        public void run() {
            System.out.println("Starting input thread!");
            while (RemoteSession.this.running) {
                try {
                    String newLine = RemoteSession.this.in.readLine();
                    if (newLine == null) {
                        RemoteSession.this.running = false;
                        continue;
                    }
                    RemoteSession.this.inQueue.add(newLine);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    RemoteSession.this.running = false;
                }
            }
        }
    }

    private class OutputThread
    implements Runnable {
        private OutputThread() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

