/*
  Exemple simple de programme en C

  Livre "Construire un annuaire d'entreprise avec LDAP"
  Auteur : Marcel Rizcallah
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <windows.h>
#include <ldap.h>

int main( int argc, char **argv )
{
	LDAP		*pLdapId;
	LDAPMessage	*pResultat, *pEntree;
	BerElement	*pBer = NULL;
	char		*pAttribut, *pDN;
	char		**pValeurs;
	int			i;

	// Recuperer un identifant de session LDAP
	if ( (pLdapId = ldap_init( "localhost", (int)atoi(argv[1])) ) == NULL ) 
	{
		//Afficher un message d'erreur
		perror( "ldap_init" );
		return( 1 );
	}

	// S'authentifier a l'annuaire en tant qu'anonyme
	if ( ldap_simple_bind_s(pLdapId, NULL, NULL ) != LDAP_SUCCESS ) 
	{
		//Fermer la session et afficher un message d'erreur
		ldap_perror( pLdapId, "ldap_simple_bind_s" );
		return( 1 );
	}

	// Rechercher toutes les entrees de l'annuaire
	if ( ldap_search_ext_s( pLdapId, 
						argv[2], 
						LDAP_SCOPE_SUBTREE,
						"(objectclass=inetorgperson)", 
						NULL, 
						0, 
						NULL, 
						NULL, 
						NULL, 
						LDAP_NO_LIMIT,
						&pResultat ) != LDAP_SUCCESS ) 
	{
		//Fermer la session et afficher un message d'erreur
		ldap_perror( pLdapId, "ldap_search_ext_s" );
		return( 1 );
	}

	// Pour chaque entree afficher le nom et les couples : attribut-valeur
	for ( pEntree = ldap_first_entry( pLdapId, pResultat ); 
		  pEntree != NULL;
	      pEntree = ldap_next_entry( pLdapId, pEntree ) ) 
	{
		//Lire et afficher le DN
		if ( (pDN = ldap_get_dn( pLdapId, pEntree )) != NULL ) 
		{
			printf( "dn: %s\n", pDN );
			ldap_memfree( pDN );
		}

		//Pour chaque attribut, lire et imprimer les valeurs
		for ( pAttribut = ldap_first_attribute( pLdapId, pEntree, &pBer );
			  pAttribut != NULL; 
			  pAttribut = ldap_next_attribute( pLdapId, pEntree, pBer ) ) 
		{
			if ((pValeurs = ldap_get_values( pLdapId, pEntree, pAttribut)) != NULL ) 
			{
				for ( i = 0; pValeurs[i] != NULL; i++ ) 
				{
					printf( "%s: %s\n", pAttribut, pValeurs[i]);
				}

				//Liberer les valeurs lues
				ldap_value_free( pValeurs );
			}
	
		//Liberer le pointeur sur l'attribut
		ldap_memfree( pAttribut );
		}

		//Liberer le curseur
		if ( pBer != NULL ) 
			ldap_ber_free( pBer, 0 );

		printf( "\n" );
	}

	ldap_msgfree( pResultat );

	//Se deconnecter de l'annuaire
	ldap_unbind( pLdapId );

	return( 0 );
}
