using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace LDAPWinSample
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Menu : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button Fermer;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.Button Rechercher;
		private System.Windows.Forms.ListBox lbResultat;
		private System.Windows.Forms.GroupBox Serveur;
		private System.Windows.Forms.TextBox tbAdresse;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Button bConnexion;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.CheckBox cbOK;
		/// <summary>
		private System.Windows.Forms.TextBox tbDNLogin;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.TextBox tbPassword;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.TextBox tbFiltre;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.Button bSupprimer;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.TextBox tbUid;
		private System.Windows.Forms.Label label7;
		private System.Windows.Forms.TextBox tbNom;
		private System.Windows.Forms.TextBox tbPrenom;
		private System.Windows.Forms.Label label8;
		private System.Windows.Forms.TextBox tbMail;
		private System.Windows.Forms.Label label9;
		private System.Windows.Forms.TextBox tbTelephone;
		private System.Windows.Forms.Button bCreer;
		private System.Windows.Forms.Button bModifier;
		/// Required designer variable.
		private System.DirectoryServices.DirectoryEntry objDE;
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Menu()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.Fermer = new System.Windows.Forms.Button();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.bSupprimer = new System.Windows.Forms.Button();
			this.lbResultat = new System.Windows.Forms.ListBox();
			this.tbFiltre = new System.Windows.Forms.TextBox();
			this.Rechercher = new System.Windows.Forms.Button();
			this.Serveur = new System.Windows.Forms.GroupBox();
			this.label4 = new System.Windows.Forms.Label();
			this.tbPassword = new System.Windows.Forms.TextBox();
			this.label3 = new System.Windows.Forms.Label();
			this.tbDNLogin = new System.Windows.Forms.TextBox();
			this.cbOK = new System.Windows.Forms.CheckBox();
			this.label2 = new System.Windows.Forms.Label();
			this.bConnexion = new System.Windows.Forms.Button();
			this.label1 = new System.Windows.Forms.Label();
			this.tbAdresse = new System.Windows.Forms.TextBox();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.bCreer = new System.Windows.Forms.Button();
			this.label9 = new System.Windows.Forms.Label();
			this.label8 = new System.Windows.Forms.Label();
			this.tbUid = new System.Windows.Forms.TextBox();
			this.label5 = new System.Windows.Forms.Label();
			this.label6 = new System.Windows.Forms.Label();
			this.label7 = new System.Windows.Forms.Label();
			this.tbNom = new System.Windows.Forms.TextBox();
			this.tbPrenom = new System.Windows.Forms.TextBox();
			this.tbMail = new System.Windows.Forms.TextBox();
			this.tbTelephone = new System.Windows.Forms.TextBox();
			this.bModifier = new System.Windows.Forms.Button();
			this.groupBox1.SuspendLayout();
			this.Serveur.SuspendLayout();
			this.groupBox2.SuspendLayout();
			this.SuspendLayout();
			// 
			// Fermer
			// 
			this.Fermer.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.Fermer.Location = new System.Drawing.Point(296, 424);
			this.Fermer.Name = "Fermer";
			this.Fermer.TabIndex = 0;
			this.Fermer.Text = "Fermer";
			this.Fermer.Click += new System.EventHandler(this.Fermer_Click);
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.Add(this.bSupprimer);
			this.groupBox1.Controls.Add(this.lbResultat);
			this.groupBox1.Controls.Add(this.tbFiltre);
			this.groupBox1.Controls.Add(this.Rechercher);
			this.groupBox1.Location = new System.Drawing.Point(8, 120);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(664, 176);
			this.groupBox1.TabIndex = 1;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Recherche et suppression";
			// 
			// bSupprimer
			// 
			this.bSupprimer.Enabled = false;
			this.bSupprimer.Location = new System.Drawing.Point(544, 96);
			this.bSupprimer.Name = "bSupprimer";
			this.bSupprimer.Size = new System.Drawing.Size(104, 23);
			this.bSupprimer.TabIndex = 3;
			this.bSupprimer.Text = "Supprimer";
			this.bSupprimer.Click += new System.EventHandler(this.bSupprimer_Click);
			// 
			// lbResultat
			// 
			this.lbResultat.Location = new System.Drawing.Point(8, 64);
			this.lbResultat.Name = "lbResultat";
			this.lbResultat.Size = new System.Drawing.Size(528, 95);
			this.lbResultat.TabIndex = 2;
			this.lbResultat.SelectedIndexChanged += new System.EventHandler(this.lbResultat_SelectedIndexChanged);
			// 
			// tbFiltre
			// 
			this.tbFiltre.Location = new System.Drawing.Point(8, 32);
			this.tbFiltre.Name = "tbFiltre";
			this.tbFiltre.Size = new System.Drawing.Size(280, 20);
			this.tbFiltre.TabIndex = 1;
			this.tbFiltre.Text = "objectclass=person";
			// 
			// Rechercher
			// 
			this.Rechercher.Location = new System.Drawing.Point(416, 32);
			this.Rechercher.Name = "Rechercher";
			this.Rechercher.Size = new System.Drawing.Size(120, 24);
			this.Rechercher.TabIndex = 0;
			this.Rechercher.Text = "Lancer la recherche";
			this.Rechercher.Click += new System.EventHandler(this.Rechercher_Click);
			// 
			// Serveur
			// 
			this.Serveur.Controls.Add(this.label4);
			this.Serveur.Controls.Add(this.tbPassword);
			this.Serveur.Controls.Add(this.label3);
			this.Serveur.Controls.Add(this.tbDNLogin);
			this.Serveur.Controls.Add(this.cbOK);
			this.Serveur.Controls.Add(this.label2);
			this.Serveur.Controls.Add(this.bConnexion);
			this.Serveur.Controls.Add(this.label1);
			this.Serveur.Controls.Add(this.tbAdresse);
			this.Serveur.Location = new System.Drawing.Point(8, 8);
			this.Serveur.Name = "Serveur";
			this.Serveur.Size = new System.Drawing.Size(664, 104);
			this.Serveur.TabIndex = 2;
			this.Serveur.TabStop = false;
			this.Serveur.Text = "Serveur";
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(8, 69);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(56, 32);
			this.label4.TabIndex = 8;
			this.label4.Text = "Mot de passe :";
			// 
			// tbPassword
			// 
			this.tbPassword.Location = new System.Drawing.Point(72, 75);
			this.tbPassword.Name = "tbPassword";
			this.tbPassword.PasswordChar = '*';
			this.tbPassword.Size = new System.Drawing.Size(176, 20);
			this.tbPassword.TabIndex = 7;
			this.tbPassword.Text = "";
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(8, 48);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(64, 23);
			this.label3.TabIndex = 6;
			this.label3.Text = "DN Login :";
			// 
			// tbDNLogin
			// 
			this.tbDNLogin.Location = new System.Drawing.Point(72, 47);
			this.tbDNLogin.Name = "tbDNLogin";
			this.tbDNLogin.Size = new System.Drawing.Size(344, 20);
			this.tbDNLogin.TabIndex = 5;
			this.tbDNLogin.Text = "cn=Directory Manager";
			// 
			// cbOK
			// 
			this.cbOK.AutoCheck = false;
			this.cbOK.Enabled = false;
			this.cbOK.Location = new System.Drawing.Point(608, 56);
			this.cbOK.Name = "cbOK";
			this.cbOK.Size = new System.Drawing.Size(40, 24);
			this.cbOK.TabIndex = 4;
			this.cbOK.TabStop = false;
			this.cbOK.Text = "OK";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(544, 56);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(64, 32);
			this.label2.TabIndex = 3;
			this.label2.Text = "Etat de la connexion :";
			// 
			// bConnexion
			// 
			this.bConnexion.Location = new System.Drawing.Point(544, 16);
			this.bConnexion.Name = "bConnexion";
			this.bConnexion.Size = new System.Drawing.Size(104, 23);
			this.bConnexion.TabIndex = 2;
			this.bConnexion.Text = "Connexion";
			this.bConnexion.Click += new System.EventHandler(this.bConnexion_Click);
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 19);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(56, 23);
			this.label1.TabIndex = 1;
			this.label1.Text = "Adresse :";
			// 
			// tbAdresse
			// 
			this.tbAdresse.Location = new System.Drawing.Point(72, 16);
			this.tbAdresse.Name = "tbAdresse";
			this.tbAdresse.Size = new System.Drawing.Size(344, 20);
			this.tbAdresse.TabIndex = 0;
			this.tbAdresse.Text = "LDAP://localhost:10000/dc=valoris,dc=com";
			// 
			// groupBox2
			// 
			this.groupBox2.Controls.Add(this.bCreer);
			this.groupBox2.Controls.Add(this.label9);
			this.groupBox2.Controls.Add(this.label8);
			this.groupBox2.Controls.Add(this.tbUid);
			this.groupBox2.Controls.Add(this.label5);
			this.groupBox2.Controls.Add(this.label6);
			this.groupBox2.Controls.Add(this.label7);
			this.groupBox2.Controls.Add(this.tbNom);
			this.groupBox2.Controls.Add(this.tbPrenom);
			this.groupBox2.Controls.Add(this.tbMail);
			this.groupBox2.Controls.Add(this.tbTelephone);
			this.groupBox2.Controls.Add(this.bModifier);
			this.groupBox2.Location = new System.Drawing.Point(8, 304);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(664, 96);
			this.groupBox2.TabIndex = 1;
			this.groupBox2.TabStop = false;
			this.groupBox2.Text = "Mise  jour / cration";
			// 
			// bCreer
			// 
			this.bCreer.Location = new System.Drawing.Point(544, 64);
			this.bCreer.Name = "bCreer";
			this.bCreer.Size = new System.Drawing.Size(104, 23);
			this.bCreer.TabIndex = 4;
			this.bCreer.Text = "Crer";
			this.bCreer.Click += new System.EventHandler(this.bCreer_Click);
			// 
			// label9
			// 
			this.label9.Location = new System.Drawing.Point(184, 68);
			this.label9.Name = "label9";
			this.label9.Size = new System.Drawing.Size(64, 16);
			this.label9.TabIndex = 3;
			this.label9.Text = "Tlphone :";
			// 
			// label8
			// 
			this.label8.Location = new System.Drawing.Point(8, 68);
			this.label8.Name = "label8";
			this.label8.Size = new System.Drawing.Size(40, 12);
			this.label8.TabIndex = 2;
			this.label8.Text = "Mail :";
			// 
			// tbUid
			// 
			this.tbUid.Location = new System.Drawing.Point(48, 24);
			this.tbUid.Name = "tbUid";
			this.tbUid.Size = new System.Drawing.Size(128, 20);
			this.tbUid.TabIndex = 1;
			this.tbUid.Text = "";
			// 
			// label5
			// 
			this.label5.Location = new System.Drawing.Point(8, 26);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(32, 23);
			this.label5.TabIndex = 0;
			this.label5.Text = "Uid :";
			// 
			// label6
			// 
			this.label6.Location = new System.Drawing.Point(186, 26);
			this.label6.Name = "label6";
			this.label6.Size = new System.Drawing.Size(40, 23);
			this.label6.TabIndex = 0;
			this.label6.Text = "Nom :";
			// 
			// label7
			// 
			this.label7.Location = new System.Drawing.Point(376, 26);
			this.label7.Name = "label7";
			this.label7.Size = new System.Drawing.Size(56, 23);
			this.label7.TabIndex = 0;
			this.label7.Text = "Prnom :";
			// 
			// tbNom
			// 
			this.tbNom.Location = new System.Drawing.Point(248, 24);
			this.tbNom.Name = "tbNom";
			this.tbNom.Size = new System.Drawing.Size(120, 20);
			this.tbNom.TabIndex = 1;
			this.tbNom.Text = "";
			// 
			// tbPrenom
			// 
			this.tbPrenom.Location = new System.Drawing.Point(432, 24);
			this.tbPrenom.Name = "tbPrenom";
			this.tbPrenom.TabIndex = 1;
			this.tbPrenom.Text = "";
			// 
			// tbMail
			// 
			this.tbMail.Location = new System.Drawing.Point(48, 64);
			this.tbMail.Name = "tbMail";
			this.tbMail.Size = new System.Drawing.Size(128, 20);
			this.tbMail.TabIndex = 1;
			this.tbMail.Text = "";
			// 
			// tbTelephone
			// 
			this.tbTelephone.Location = new System.Drawing.Point(248, 64);
			this.tbTelephone.Name = "tbTelephone";
			this.tbTelephone.Size = new System.Drawing.Size(120, 20);
			this.tbTelephone.TabIndex = 1;
			this.tbTelephone.Text = "";
			// 
			// bModifier
			// 
			this.bModifier.Location = new System.Drawing.Point(544, 24);
			this.bModifier.Name = "bModifier";
			this.bModifier.Size = new System.Drawing.Size(104, 23);
			this.bModifier.TabIndex = 4;
			this.bModifier.Text = "Modifier";
			this.bModifier.Click += new System.EventHandler(this.bModifier_Click);
			// 
			// Menu
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(688, 461);
			this.Controls.Add(this.Serveur);
			this.Controls.Add(this.groupBox1);
			this.Controls.Add(this.Fermer);
			this.Controls.Add(this.groupBox2);
			this.Name = "Menu";
			this.Text = "Exemple d\'application LDAP avec C#";
			this.Load += new System.EventHandler(this.Menu_Load);
			this.groupBox1.ResumeLayout(false);
			this.Serveur.ResumeLayout(false);
			this.groupBox2.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Menu());
		}

		private void Menu_Load(object sender, System.EventArgs e)
		{
			cbOK.Checked = false;		
		}

		private void Fermer_Click(object sender, System.EventArgs e)
		{
			Application.Exit();
		}

		private void Rechercher_Click(object sender, System.EventArgs e)
		{
			//On s'assure que la connexion est bien tablie avant de faire la recherche
			if (cbOK.Checked == false)
				return;

			//Lire les objets de l'annuaire avec le critre de filtre donn
			System.DirectoryServices.DirectorySearcher objDS = 
				new System.DirectoryServices.DirectorySearcher (objDE, tbFiltre.Text);

			//On indique les attributs que l'on souhaite lire
			//Par dfaut (donc en l'absence de ces lignes), tous les attributs sont lus
			objDS.PropertiesToLoad.Add ("uid");
			objDS.PropertiesToLoad.Add ("sn");
			objDS.PropertiesToLoad.Add ("givenName");
			objDS.PropertiesToLoad.Add ("mail");
			objDS.PropertiesToLoad.Add ("telephoneNumber");

			//On lit toutes les entres de l'annuaire
			System.DirectoryServices.SearchResultCollection objSR = objDS.FindAll();

			//On vide la liste
			lbResultat.Items.Clear();

			//On insre les rsultats de la recherche dans la liste
			foreach (System.DirectoryServices.SearchResult entry in objSR)
			{
				string ListText="";
				if (entry.Properties ["uid"].Count > 0)
					ListText += entry.Properties ["uid"][0].ToString();

				if (entry.Properties ["givenName"].Count > 0)
					ListText += ", "+ entry.Properties ["givenName"][0].ToString();

				if (entry.Properties ["sn"].Count > 0)
					ListText += " "+ entry.Properties ["sn"][0].ToString();

				if (entry.Properties ["mail"].Count > 0)
					ListText += ", "+ entry.Properties ["mail"][0].ToString();
				
				if (entry.Properties ["telephoneNumber"].Count > 0)
					ListText += ", "+ entry.Properties ["telephoneNumber"][0].ToString();

				lbResultat.Items.Add(ListText);
			}
		}

		private void bConnexion_Click(object sender, System.EventArgs e)
		{
			//Si la connexion est dj tablie on la libre
			if (cbOK.Checked == true)
				objDE.Close();

			//Etablir la connexion avec le serveur spcifi
			objDE = new System.DirectoryServices.DirectoryEntry (tbAdresse.Text, 
				tbDNLogin.Text,
				tbPassword.Text,
				System.DirectoryServices.AuthenticationTypes.ServerBind);
				
			try
			{
				//On vrifie que la connexion s'est bien effectue et que l'objet est valide
				//Notons que la connexion n'a rellement lieu qu' l'excution de cette instruction!
				string name = objDE.Name;
				if (name.Length != 0)
					cbOK.Checked = true;
			} 
			catch (Exception ex)
			{
				cbOK.Checked = false;
				throw new Exception ("Problem :"+ex.Message);
			}
			
		}

		private void bSupprimer_Click(object sender, System.EventArgs e)
		{
			//Recuprer la ligne slectionne
			if (lbResultat.SelectedItem == null)
				return;

			//Extraire l'uid de la ligne
			string SelectedText = lbResultat.SelectedItem.ToString();
			string uid = SelectedText.Substring (0,SelectedText.IndexOf (", "));

			//On lit l'entre de l'annuaire qui correspond  ce critre
			System.DirectoryServices.DirectorySearcher objDS = 
				new System.DirectoryServices.DirectorySearcher (objDE, "uid="+uid);
			System.DirectoryServices.SearchResult entry = objDS.FindOne();
			
			try
			{
				//On supprime l'entre et tous les objets sous-jacents ventuels
				entry.GetDirectoryEntry().DeleteTree();
				
				//On supprime la ligne de la liste box
				lbResultat.Items.Remove(lbResultat.SelectedItem);
			}
			catch (Exception ex)
			{
				throw new Exception ("Error :"+ex.Message);
			}
			
		}

		private void lbResultat_SelectedIndexChanged(object sender, EventArgs e)
		{
			//Desactiver le bouton
			bSupprimer.Enabled = false;
			
			//Vider les champs de la fentre Modifier
			tbUid.Text = "";
			tbPrenom.Text = "";
			tbNom.Text = "";
			tbMail.Text ="";
			tbTelephone.Text = "";
			if (lbResultat.SelectedItem != null)
			{
				//S'assurer que la ligne n'est pas vide
				string SelectedText = lbResultat.SelectedItem.ToString();
				if (SelectedText.Length <= 0)
					return;
				//Activer le bouton supprimer
				bSupprimer.Enabled = true;

				//Extraire l'uid de la ligne
				string uid = SelectedText.Substring (0,SelectedText.IndexOf (", "));

				//On lit l'entre de l'annuaire qui correspond  ce critre
				System.DirectoryServices.DirectorySearcher objDS = 
					new System.DirectoryServices.DirectorySearcher (objDE, "uid="+uid);
				System.DirectoryServices.SearchResult entry = objDS.FindOne();
			
				//Renseigner les attributs dans la fentre Modifier
				if (entry.Properties ["uid"].Count > 0)
					tbUid.Text = entry.Properties ["uid"][0].ToString();

				if (entry.Properties ["givenName"].Count > 0)
					tbPrenom.Text = entry.Properties ["givenName"][0].ToString();

				if (entry.Properties ["sn"].Count > 0)
					tbNom.Text = entry.Properties ["sn"][0].ToString();

				if (entry.Properties ["mail"].Count > 0)
					tbMail.Text = entry.Properties ["mail"][0].ToString();
				
				if (entry.Properties ["telephoneNumber"].Count > 0)
					tbTelephone.Text = entry.Properties ["telephoneNumber"][0].ToString();
			
			}
		}

		private void bModifier_Click(object sender, System.EventArgs e)
		{
			//On s'assure que la connexion est bien tablie 
			if (cbOK.Checked == false)
				return;
			if (lbResultat.SelectedItem != null)
			{
				//Extraire l'uid de la ligne
				object selected = lbResultat.SelectedItem;
				string SelectedText = selected.ToString();
				string uid = SelectedText.Substring (0,SelectedText.IndexOf (", "));

				try	
				{
					//On lit l'entre de l'annuaire qui correspond  ce critre
					System.DirectoryServices.DirectoryEntry entry = 
						objDE.Children.Find("uid="+uid);
					
					//On met  jour les attributs sauf l'uid, qui constitue l'index
					entry.Properties ["givenName"].Clear();
					if (tbPrenom.Text.Length > 0)
						entry.Properties ["givenName"].Add (tbPrenom.Text);
					entry.Properties ["sn"].Clear();
					if (tbNom.Text.Length > 0)
						entry.Properties ["sn"].Add (tbNom.Text);
					entry.Properties ["mail"].Clear();
					if (tbMail.Text.Length > 0)
						entry.Properties ["mail"].Add(tbMail.Text);
					entry.Properties ["telephoneNumber"].Clear();
					if (tbTelephone.Text.Length > 0)
						entry.Properties ["telephoneNumber"].Add(tbTelephone.Text);
					
					//Valider les changements
					entry.CommitChanges();

					//Rafraichir la liste
					Rechercher_Click (sender,e);
				}
				catch (Exception ex)
				{
					throw new Exception ("Error :"+ex.Message);
				}
			}
		}

		private void bCreer_Click(object sender, System.EventArgs e)
		{
			//On s'assure que la connexion est bien tablie 
			if (cbOK.Checked == false)
				return;
			try
			{
				//On cre une nouvelle entre
				System.DirectoryServices.DirectoryEntry entry = objDE.Children.Add("uid="+tbUid.Text, "inetorgperson");
				entry.Properties ["givenName"].Add (tbPrenom.Text);
				entry.Properties ["sn"].Add (tbNom.Text);
				entry.Properties ["cn"].Add (tbPrenom.Text + " "+ tbNom.Text);
				entry.Properties ["mail"].Add(tbMail.Text);
				entry.Properties ["telephoneNumber"].Add(tbTelephone.Text);
				
				//On valide la mise  jour
				entry.CommitChanges();

				//Rafraichir la liste
				Rechercher_Click (sender,e);
			}
			catch (Exception ex)
			{
				throw new Exception ("Error :"+ex.Message);
			}
		}
	}
}
