/*	**************************************************************
	File:		AGCore.h
	Decription:	AGCorexx.dll classes declaration

	Copyright 1996-2000 Netsize Corporation. All Rights reserved.
	e-mail	:	support@netsize.com
				info@netsize.com
	web		:	http://www.netsize.com/

	DO NOT MODIFY
	**************************************************************	*/

#ifndef _ACTIVE_GATEWAY_CORE_H_
#define _ACTIVE_GATEWAY_CORE_H_

#ifndef _AG_ERROR_TYPE_
typedef	long AGReturnCode;	/*	Standard return value for most functions	*/
#define _AG_ERROR_TYPE_
#endif	/*	ndef _AG_ERROR_TYPE_	*/

#include <AGReturnCode.h>	/*	Error codes	*/

/* Active Gateway defines concerning extension slots	*/
#define AG_EXTENSION_REQUEST					_T("REQUEST")
#define AG_EXTENSION_RESULT						_T("RESULT")
#define AG_EXTENSION_RESULT_CODE				_T("RESULT.CODE")
#define AG_EXTENSION_RESULT_MESSAGE				_T("RESULT.MESSAGE")
#define AG_EXTENSION_RESULT_REASON				_T("RESULT.REASON")
#define AG_EXTENSION_PEER_NAME					_T("PeerName")
#define AG_EXTENSION_START_SESSION_DATE			_T("StartSessionDate")
#define AG_EXTENSION_PEER_VERSION				_T("PeerVersion")
#define AG_EXTENSION_PEER_PROTOCOL_VERSION		_T("PeerProcotolVersion")
#define AG_EXTENSION_PEER_IP_ADDR				_T("PeerIPAddr")
#define AG_EXTENSION_PEER_DNS_NAME				_T("PeerDNSName")
#define AG_EXTENSION_PEER_PLATFORM				_T("PeerPlatform")
#define AG_EXTENSION_PEER_PLATFORM_VERSION		_T("PeerPlatformVersion")
#define AG_EXTENSION_PEER_SYSTEM_LANGUAGE_CODE	_T("PeerSystemLanguageCode")
#define AG_EXTENSION_PEER_USER_LANGUAGE_CODE	_T("PeerUserLanguageCode")
#define AG_EXTENSION_PEER_CHARACTER_CODE		_T("PeerCharacterCode")

//	Extension Informations
#define AG_EXTENSION_NAME				_T("DLL_NAME")
#define AG_EXTENSION_VERSION_NAME		_T("DLL_VERSION.NAME")
#define AG_EXTENSION_VERSION_MAJOR		_T("DLL_VERSION.MAJOR")
#define AG_EXTENSION_VERSION_MINOR		_T("DLL_VERSION.MINOR")

#define AG_EXTENSION_OPT				_T("AG_EXT_OPT")
#define AG_EXTENSION_OPT_WANT_RESP		_T("AG_EXT_OPT.WANT_RESPONSE")

/* Frame returned by the broker when processing an extension request	*/
#define AGB_EXT_PROCESS_RESULT			_T("NS$AGB$ExtRes")
#define AGB_EPR_RETURN_VALUE			_T("RV")
#define AGB_EPR_MESSAGE					_T("Mess")
#define AGB_EPR_RETURN_DATA				_T("Data")
#define AGB_EPR_RETURN_DATA_RV			_T("Data.RV")
#define AGB_EPR_RETURN_DATA_MESS		_T("Data.Mess")

/* Define to use in asynchronous mode	*/
#define AG_ASYNC_PEER_NAME				AG_EXTENSION_PEER_NAME
#define AG_ASYNC_ARRAY_OF_PEER_NAME		_T("ArrayOfPeerName")
#define	AG_ASYNC_MESSAGE_QUEUE_NAME		_T("MessageQueueName")
#define	AG_ASYNC_NUMBER_OF_MESSAGE		_T("NumberOfMessage")

#define	AG_ASYNC_REQUEST				_T("AsyncRequest")
#define	AG_ASYNC_RESET_MESSAGE_QUEUE	_T("ResetMessageQueue")
#define	AG_ASYNC_GET_NUMBER_OF_MESSAGE	_T("GetNumberOfMessage")
#define	AG_ASYNC_GET_A_MESSAGE			_T("GetAMessage")
#define	AG_ASYNC_PUT_A_MESSAGE			_T("PutAMessage")
#define	AG_ASYNC_REMOVE_A_MESSAGE		_T("RemoveAMessage")
#define	AG_ASYNC_LEAVE_MESSAGE			_T("LeaveMessage")
#define	AG_ASYNC_REQUEST_DATA			_T("AsyncRequestData")

/* Define to use with parameter frame (Construtor, OpenSession, Send, Recv) */
#define AG_BROKER_ADDRESS_PARAM			_T("ag_broker_address_param")
#define AG_BROKER_PORT_PARAM			_T("ag_broker_port_param")
#define AG_PROXY_ADDRESS_PARAM			_T("ag_proxy_address_param")
#define AG_PROXY_PORT_PARAM				_T("ag_proxy_port_param")
#define AG_ENDPOINT_NAME_PARAM			_T("ag_endpoint_name_param")
#define AG_PEER_NAME_PARAM				_T("ag_peer_name_param")
#define AG_CHANNEL_TYPE_PARAM			_T("ag_channel_type_param")
#define AG_COMMUNICATION_MODE_PARAM		_T("ag_communication_mode_param")
#define AG_TIMEOUT_PARAM				_T("ag_timeout_param")
#define AG_MESSAGE_ID_PARAM				_T("ag_message_id_param")
#define AG_DEFAULT_MESSAGE_ID_PARAM		_T("<Undefined>")
#define AG_ACTIVE_ENDPOINT_REGISTER		_T("ag_active_endpoint_register")

/* Define to use with SMTP */
#define	AG_SMTP_FROM_PARAM				_T("ag_smtp_from_param")
#define	AG_SMTP_TO_PARAM				_T("ag_smtp_to_param")
#define	AG_SMTP_SUBJECT_PARAM			_T("ag_smtp_subject_param")
#define	AG_SMTP_TEXT_PARAM				_T("ag_smtp_text_param")
#define	AG_SMTP_FILE_NAME_PARAM			_T("ag_smtp_file_name_param")


#ifdef AG_PF_WIN32
#	define AG_LAST_ERROR_TYPE	DWORD
#else
#	define AG_LAST_ERROR_TYPE	int
#endif	//	def AG_PF_WIN32

/*	**************************************************************************	*/
/*	Base object of most Active Gateway objects	*/
class CAGObject
{
/*	**************************************************************************
	Constructor
*/
public :
	CAGObject();
/*	**************************************************************************
	Destructor
*/
public:
	virtual ~CAGObject();

/*	**************************************************************************	*/
public:
	AGReturnCode SetError(	AGReturnCode		nError)		{	return (m_nError = nError);		}

	AGReturnCode SetError(	AGReturnCode		nError,
							AG_LAST_ERROR_TYPE	nLastError)	{	m_nLastError	= nLastError;
																return (m_nError = nError);		}

	AGReturnCode GetError()				const				{	return m_nError;				}
	AG_LAST_ERROR_TYPE _GetLastError()	const				{	return m_nLastError;			}

	BOOL HasNoError()					const				{	return (m_nError == agSuccess); }

	virtual int LinkerFunc();	/*	USELESS, just for correct linking	*/

/*	**************************************************************************
	Data Members	*/
private:
	AGReturnCode		m_nError;
	AG_LAST_ERROR_TYPE	m_nLastError;
};


/*////////////////////////////////////////////////////////////////	*/
////////////////////////////	CAGCriticalSection
class CAGCriticalSection
{
/*	**************************************************************************
	Constructor
*/
public:
	CAGCriticalSection()
	{
#if	defined(AG_USE_PTHREAD)
	pthread_mutex_init(&m_pMutex, NULL);
#elif	defined(AG_PF_WIN32)
	::InitializeCriticalSection(	&m_oCriticalSection);
#elif	defined(AG_PF_EPOC)
	m_oCriticalSection.CreateLocal();
#elif	defined(AG_PF_PALMOS)
#elif	defined(AG_PF_QNX)
#elif	defined(AG_PF_VXWORKS)
#elif	defined(AG_PF_LYNX)
#elif	defined(AG_PF_OS9)
#else
//#error no platform
#endif
	}
/*	**************************************************************************
	Destructor
*/
public:
	virtual ~CAGCriticalSection()
	{
#if	defined(AG_USE_PTHREAD)
	pthread_mutex_destroy(&m_pMutex);
#elif	defined(AG_PF_WIN32)
	::DeleteCriticalSection(		&m_oCriticalSection);
#elif	defined(AG_PF_EPOC)
	m_oCriticalSection.Close();
#elif	defined(AG_PF_PALMOS)
#elif	defined(AG_PF_QNX)
#elif	defined(AG_PF_VXWORKS)
#elif	defined(AG_PF_LYNX)
#elif	defined(AG_PF_OS9)
#else
//#error no platform
#endif
	}
public:
	void Lock()
	{
#if	defined(AG_USE_PTHREAD)
	pthread_mutex_lock(&m_pMutex);
#elif	defined(AG_PF_WIN32)
	::EnterCriticalSection(		&m_oCriticalSection);
#elif	defined(AG_PF_EPOC)
	m_oCriticalSection.Wait();
#elif	defined(AG_PF_PALMOS)
#elif	defined(AG_PF_QNX)
#elif	defined(AG_PF_VXWORKS)
#elif	defined(AG_PF_LYNX)
#elif	defined(AG_PF_OS9)
#else
//#error no platform
#endif
	}
	void Unlock()
	{
#if	defined(AG_USE_PTHREAD)
	pthread_mutex_unlock(&m_pMutex);
#elif	defined(AG_PF_WIN32)
	::LeaveCriticalSection(		&m_oCriticalSection);
#elif	defined(AG_PF_EPOC)
	m_oCriticalSection.Signal();
#elif	defined(AG_PF_PALMOS)
#elif	defined(AG_PF_QNX)
#elif	defined(AG_PF_VXWORKS)
#elif	defined(AG_PF_LYNX)
#elif	defined(AG_PF_OS9)
#else
//#error no platform
#endif
	}
/*	**************************************************************************
	Data Members	*/
private:
#if		defined(AG_USE_PTHREAD)
	pthread_mutex_t		m_pMutex;
#elif	defined(AG_PF_WIN32)
	CRITICAL_SECTION	m_oCriticalSection;
#elif	defined(AG_PF_EPOC)
	RCriticalSection	m_oCriticalSection;
#elif	defined(AG_PF_PALMOS)
#elif	defined(AG_PF_QNX)
#elif	defined(AG_PF_VXWORKS)
#elif	defined(AG_PF_LYNX)
#elif	defined(AG_PF_OS9)
#else
//#error no platform
#endif
};


//////////////////////////////////////////////////////////////////
////////////////////////////	CAGCriticalSectionLocker
class CAGCriticalSectionLocker : public CAGObject
{
/*	**************************************************************************
	Constructor
*/
public:
	CAGCriticalSectionLocker(CAGCriticalSection * pAGCriticalSection)
		:	m_pAGCriticalSection(pAGCriticalSection)
	{
		if (m_pAGCriticalSection)
		{
			m_pAGCriticalSection->Lock();
			return;
		}
		SetError(agInvalidParameter);
	}
/*	**************************************************************************
	Destructor
*/
public:
	virtual ~CAGCriticalSectionLocker()
	{
		if (m_pAGCriticalSection) m_pAGCriticalSection->Unlock();
	}
public:
	void	Unlock()
	{
		if (m_pAGCriticalSection)
		{
			m_pAGCriticalSection->Unlock();
			m_pAGCriticalSection = NULL;
		}
	}
private:
	CAGCriticalSection *	m_pAGCriticalSection;
};

#if		!defined(AG_PF_WIN32) && !defined(AG_PF_OS_400)
class CAGInterlocked : public CAGObject
{
/*	**************************************************************************
	Constructor
*/
public:
	CAGInterlocked(long nValue);
/*	**************************************************************************
	Destructor
*/
public:
	virtual ~CAGInterlocked();

public:
	long InterlockedIncrement();
	long InterlockedDecrement();

	long GetValue()								const;
	void SetValue(long nValue);
protected:
private:

public:
protected:
private:
	CAGCriticalSection	m_oCS;
	long				m_nValue;
};
#endif	/*	!defined(AG_PF_WIN32) && !defined(AG_PF_OS_400)	*/

#if		defined(AG_PF_OS_400)
long InterlockedIncrement(long*				pVal);
long InterlockedDecrement(long*				pVal);
#endif	//	defined(AG_PF_OS_400)


/***************************************************************************/
#if	defined(AG_PF_WIN32) || defined(AG_PF_OS_400)
struct SAGStringData
{
	LPTSTR	m_pString;
	long	m_nRefCount;
};
#else
class	SAGStringData
{
/*	**************************************************************************
	Constructor
*/
public:
	SAGStringData() : m_nRefCount(0) {};
	SAGStringData(	LPTSTR		pString,
					long		nRefCount)
		:	m_pString(pString)
			,m_nRefCount(nRefCount)
		{};
/*	**************************************************************************
	Destructor
*/
public:
	virtual ~SAGStringData() {};

public:
	LPTSTR			m_pString;
	CAGInterlocked	m_nRefCount;
};
#endif

class CAGString
{
/*	**************************************************************************
	Constructors
*/
public:
	CAGString();
	CAGString(const CAGString&	oAGString);
	CAGString(LPCTSTR			pString);
#ifdef _UNICODE
	CAGString(LPCSTR			pString);
#else /* _UNICODE	*/
	CAGString(LPCWSTR			pString);
#endif /* _UNICODE	*/
protected:
	CAGString(SAGStringData *	pSAGStringData);
/*	**************************************************************************
	Destructor
*/
public:
	virtual ~CAGString();

public:
	const CAGString & operator = (SAGStringData *	pSAGStringData);
	const CAGString & operator = (const CAGString & oAGString);
	const CAGString & operator = (LPCTSTR			pString);
#ifdef _UNICODE
	const CAGString & operator = (LPCSTR			pString);
#else /* _UNICODE	*/
	const CAGString & operator = (LPCWSTR			pString);
#endif /* _UNICODE	*/
	const CAGString & operator = (TCHAR				cChar);
#ifdef _UNICODE
	const CAGString & operator = (char				cChar)
		{ return operator=((TCHAR)cChar); }
#endif

	const CAGString & operator += (const CAGString&	oAGString);
	const CAGString & operator += (LPCTSTR			pString);
#ifdef _UNICODE
	const CAGString & operator += (LPCSTR			pString);
#else /* _UNICODE	*/
	const CAGString & operator += (LPCWSTR			pString);
#endif /* _UNICODE	*/

	const CAGString & operator += (	TCHAR			cChar);
#ifdef _UNICODE
	const CAGString & operator += (	char			cChar)
		{ return operator+=((TCHAR)cChar); }
#endif

#	ifdef AG_PF_WIN32
	BOOL LoadString(	UINT		nStringID,
						HINSTANCE	hInstance);
#	endif	/*	def AG_PF_WIN32	*/

	long	Find(LPCTSTR pSubString)				const;
#if defined(AG_PF_PALMOS)
/*	Not supported	*/
#else
	long	FindOneOf(LPCTSTR pCharSet)				const;
#endif	/*	platforms	*/
	CAGString Mid(		int			nFirst,
						int			nCount = -1)	const;

	long GetLength()								const;

	BOOL IsEmpty()									const;
	void Empty();

	operator LPCTSTR()								const;
	int Compare(LPCTSTR pString)					const;

	void Format(LPCTSTR lpszFormat, ...);

	CAGString Left(	long nCount)					const;
	CAGString Right(long nCount)					const;

	void MakeUpper();
	void MakeLower();

	TCHAR GetAt(long nIndex) const
	{
		return m_pSAGStringData->m_pString[nIndex];
	}
	TCHAR operator[](long nIndex) const
	{
		return m_pSAGStringData->m_pString[nIndex];
	}
	void SetAt(long nIndex, TCHAR cChar)
	{
		CopyBeforeWrite();
		m_pSAGStringData->m_pString[nIndex] = cChar;
	}

	LPTSTR GetBuffer()
	{
		CopyBeforeWrite();
		return m_pSAGStringData->m_pString;
	}

	void FormatV(LPCTSTR lpszFormat, va_list argList);

private:
	void Init(SAGStringData *	pSAGStringData);

	SAGStringData * AddReference(	SAGStringData *	pSAGStringData,
									BOOL			bSetDefaultEmptyString);
	void RemoveReference();
	void CopyBeforeWrite()
	{
#if	defined(AG_PF_WIN32) || defined(AG_PF_OS_400)
		if (m_pSAGStringData->m_nRefCount > 1)
#else
		if (m_pSAGStringData->m_nRefCount.GetValue() > 1)
#endif
		{
			CAGString sTmp(this->operator LPCTSTR());
			this->operator=(sTmp);
		}
	}

/*	**************************************************************************
	Data Members	*/
private:
	struct SAGStringData *	m_pSAGStringData;
/*	**************************************************************************	*/
//	STATIC MEMBERS
public:

/*	**************************************************************************	*/
//	FRIEND CLASSES AND FUNCTIONS
	friend class CAGSlot;
	friend class CAGCollection;
};

inline BOOL operator==(const CAGString& sString1, const CAGString& sString2)
	{ return sString1.Compare(sString2) == 0; }
inline BOOL operator==(const CAGString& sString1, LPCTSTR pString2)
	{ return sString1.Compare(pString2) == 0; }
inline BOOL operator==(LPCTSTR pString1, const CAGString& sString2)
	{ return sString2.Compare(pString1) == 0; }
inline BOOL operator!=(const CAGString& sString1, const CAGString& sString2)
	{ return sString1.Compare(sString2) != 0; }
inline BOOL operator!=(const CAGString& sString1, LPCTSTR pString2)
	{ return sString1.Compare(pString2) != 0; }
inline BOOL operator!=(LPCTSTR pString1, const CAGString& sString2)
	{ return sString2.Compare(pString1) != 0; }
inline BOOL operator<(const CAGString& sString1, const CAGString& sString2)
	{ return sString1.Compare(sString2) < 0; }
inline BOOL operator<(const CAGString& sString1, LPCTSTR pString2)
	{ return sString1.Compare(pString2) < 0; }
inline BOOL operator<(LPCTSTR pString1, const CAGString& sString2)
	{ return sString2.Compare(pString1) > 0; }
inline BOOL operator>(const CAGString& sString1, const CAGString& sString2)
	{ return sString1.Compare(sString2) > 0; }
inline BOOL operator>(const CAGString& sString1, LPCTSTR pString2)
	{ return sString1.Compare(pString2) > 0; }
inline BOOL operator>(LPCTSTR pString1, const CAGString& sString2)
	{ return sString2.Compare(pString1) < 0; }
inline BOOL operator<=(const CAGString& sString1, const CAGString& sString2)
	{ return sString1.Compare(sString2) <= 0; }
inline BOOL operator<=(const CAGString& sString1, LPCTSTR pString2)
	{ return sString1.Compare(pString2) <= 0; }
inline BOOL operator<=(LPCTSTR pString1, const CAGString& sString2)
	{ return sString2.Compare(pString1) >= 0; }
inline BOOL operator>=(const CAGString& sString1, const CAGString& sString2)
	{ return sString1.Compare(sString2) >= 0; }
inline BOOL operator>=(const CAGString& sString1, LPCTSTR pString2)
	{ return sString1.Compare(pString2) >= 0; }
inline BOOL operator>=(LPCTSTR pString1, const CAGString& sString2)
	{ return sString2.Compare(pString1) <= 0; }
/***************************************************************************/


//	****************************************************
//	Conversion from an AGReturnCode code to a string
//	This conversion is for developper only. It doesn't mean
//	anything to an end user.
CAGString	AGReturnCodeToString(long nError);

class CAGFrame;
void	AGFormatReturnCode(	CAGFrame&			oAGFrame,
							const AGReturnCode	nErrorCode,
							LPCTSTR				pErrorMessage	=	NULL,
							LPCTSTR				pErrorReason	=	NULL);

void	AGParseReturnCode(	CAGFrame&			oAGFrame,
							AGReturnCode&		nErrorCode,
							CAGString&			sErrorMessage,
							CAGString&			sErrorReason);


//	****************************************************
//	Exception class
//	Functions that throw an AGException will throw a
//	pointer to a CAGException.
//	When you catch a CAGException pointer, you have to
//	call his Delete() member function when you're done
//	with it. 
class CAGException
{
public:
/*	**************************************************************************
	Constructors
*/
	CAGException();
	CAGException(	const AGReturnCode	nErrorCode,
					LPCTSTR				pErrorMessage	=	NULL,
					LPCTSTR				pErrorReason	=	NULL);
/*	**************************************************************************
	Destructor
*/
public:
	virtual ~CAGException();
public:
	void	Delete();	/*	Destruction of the exception object.	*/
						/*	DO NOT access the deleted object after calling this function	*/
						/*	since it has been destroyed.	*/
	AGReturnCode	GetErrorCode()		const	{	return m_nErrorCode;}
	LPCTSTR			GetErrorMessage()	const	{	return m_pErrorMessage;}
	LPCTSTR			GetErrorReason()	const	{	return m_pErrorReason;}

	void SetErrorCode(		const AGReturnCode	nErrorCode);
	void SetErrorMessage(	LPCTSTR				pErrorMessage);
	void SetErrorReason(	LPCTSTR				pErrorReason);
/*	**************************************************************************
	Data Members	*/
protected:
	AGReturnCode	m_nErrorCode;		/*	Error code	*/
	LPTSTR			m_pErrorMessage;	/*	Error message	*/
	LPTSTR			m_pErrorReason;		/*	Error reason (complement the message)	*/
};

//	Macro usefull to handle exceptions of type CAGException
//	Try to use them. They'll keep consistency as versions evolve
#ifdef AG_USE_EXCEPTION

#ifdef AG_PF_EPOC
#	define AG_TRY_EXCEPTION					{TInt pExceptionInt = NULL;{TTrap __t;if (__t.Trap(pExceptionInt)==0){
#	define CATCH_AG_EXCEPTION				TTrap::UnTrap();}}if (pExceptionInt != 0){CAGException * pAGException = (CAGException *)pExceptionInt;

#	define DELETE_AG_EXCEPTION				delete pAGException;pAGException = NULL;
#	define RETHROW_AG_EXCEPTION				User::Leave(pExceptionInt);
#	define AG_RETURN_EMPTY_AG_SLOT
#	define END_CATCH_AG_EXCEPTION			}}
#	define GET_AG_EXCEPTION_ERROR			pAGException->GetErrorCode()
#	define GET_AG_EXCEPTION_ERROR_MESSAGE	pAGException->GetErrorMessage()
#	define GET_AG_EXCEPTION_ERROR_REASON	pAGException->GetErrorReason()
#else	/*	ifdef AG_PF_EPOC	*/
#	define AG_TRY_EXCEPTION					try {
#	define CATCH_AG_EXCEPTION				} catch (CAGException *    pAGException) {
#	define DELETE_AG_EXCEPTION				pAGException->Delete();pAGException = NULL;
#	define RETHROW_AG_EXCEPTION				throw pAGException;
#	define AG_RETURN_EMPTY_AG_SLOT
#	define END_CATCH_AG_EXCEPTION			}
#	define GET_AG_EXCEPTION_ERROR			pAGException->GetErrorCode()
#	define GET_AG_EXCEPTION_ERROR_MESSAGE	pAGException->GetErrorMessage()
#	define GET_AG_EXCEPTION_ERROR_REASON	pAGException->GetErrorReason()
#endif	/*	def else AG_PF_EPOC	*/


#endif	/*	def AG_USE_EXCEPTION	*/

void	AGThrowException(	AGReturnCode	nErrorCode		=	agGenericError,
							LPCTSTR			pErrorMessage	=	NULL,
							LPCTSTR			pErrorReason	=	NULL);

/*	****************************************************
	For encryption.
	Not implemented and not documented in the current release
*/
#define AG_MAX_LENGTH_KEY 10

/*	****************************************************
	Supported slot types
*/
enum agType
{
	agString		= 0,
//	agSymbol		= 1,
	agByte			= 2,
	agShort			= 3,
	agBool			= 4,		/*	boolean defined as an 'int'	*/
	agLong			= 5,
	agFloat			= 6,
	agDouble		= 7,
	agDateTime		= 8,
	agBuffer		= 9,
	agFrame			= 10,
	agArray			= 11,
	agUndefined		= 12,
	agException		= 13,
	agFileRef		= 14,
	agPointer		= 15,
	agLong64		= 16,
//	agDateTimeSpan	= 17
};

//	****************************************************
class CAGDateTime
{
public:
/*	**************************************************************************
	Constructors
*/
	CAGDateTime();
	CAGDateTime(	short	nYear,
					short	nMonth,
					short	nDay,
					short	nHour,
					short	nMinute,
					short	nSecond);
	CAGDateTime(	short	nYear,
					short	nMonth,
					short	nDayOfWeek,
					short	nDay,
					short	nHour,
					short	nMinute,
					short	nSecond);
	CAGDateTime(	const CAGDateTime&	oAGDateTime);

	CAGDateTime(const SYSTEMTIME&		oSysTimeVal);

/*	**************************************************************************	*/
public:
	/*	Overloaded operators	*/
	CAGDateTime& operator=(const CAGDateTime& oAGDateTime);
	operator CAGString()										const;
	/*	SYSTEMTIME (see stdport.h)	*/
	CAGDateTime& operator=(const SYSTEMTIME &		oSysTimeVal);
	operator SYSTEMTIME()										const;


/*	**************************************************************************	*/
public:		//	OPERATIONS
	long Compare(const CAGDateTime&	oAGDateTime)				const;
	void SetDateTime(	short	nYear,
						short	nMonth,
						short	nDay,
						short	nHour,
						short	nMinute,
						short	nSecond);

	void ValidateY2K(	short &	nYear);

/*	**************************************************************************
	Data Members	*/
public:
	short	m_nYear;
	short	m_nMonth;
	short	m_nDayOfWeek;	/*	Not supported. Used when constructing or copying	*/
							/*	from a SYSTEMTIME structure. Equal to zero otherwise.	*/
	short	m_nDay;
	short	m_nHour;
	short	m_nMinute;
	short	m_nSecond;
};

#ifdef AG_PF_WIN32
inline bool operator< (const CAGDateTime& oDT1, const CAGDateTime& oDT2)	{return (oDT1.Compare(oDT2) <  0);}
inline bool operator<=(const CAGDateTime& oDT1, const CAGDateTime& oDT2)	{return (oDT1.Compare(oDT2) <= 0);}
inline bool operator==(const CAGDateTime& oDT1, const CAGDateTime& oDT2)	{return (oDT1.Compare(oDT2) == 0);}
inline bool operator!=(const CAGDateTime& oDT1, const CAGDateTime& oDT2)	{return (oDT1.Compare(oDT2) != 0);}
inline bool operator>=(const CAGDateTime& oDT1, const CAGDateTime& oDT2)	{return (oDT1.Compare(oDT2) >= 0);}
inline bool operator> (const CAGDateTime& oDT1, const CAGDateTime& oDT2)	{return (oDT1.Compare(oDT2) >  0);}
#else
inline BOOL operator< (const CAGDateTime& oDT1, const CAGDateTime& oDT2)	{return (oDT1.Compare(oDT2) <  0);}
inline BOOL operator<=(const CAGDateTime& oDT1, const CAGDateTime& oDT2)	{return (oDT1.Compare(oDT2) <= 0);}
inline BOOL operator==(const CAGDateTime& oDT1, const CAGDateTime& oDT2)	{return (oDT1.Compare(oDT2) == 0);}
inline BOOL operator!=(const CAGDateTime& oDT1, const CAGDateTime& oDT2)	{return (oDT1.Compare(oDT2) != 0);}
inline BOOL operator>=(const CAGDateTime& oDT1, const CAGDateTime& oDT2)	{return (oDT1.Compare(oDT2) >= 0);}
inline BOOL operator> (const CAGDateTime& oDT1, const CAGDateTime& oDT2)	{return (oDT1.Compare(oDT2) >  0);}
#endif	//	def AG_PF_WIN32

/*	**************************************************************************	*/
//	CAGBuffer class
//	Memory buffer class
class CAGBuffData;	/*	PRIVATE CLASS	*/
class CAGBuffer : public CAGObject
{
public :
/*	**************************************************************************
	Constructors
*/
	CAGBuffer();
	CAGBuffer(	const void*	pBuff,
				long		nSize);
	CAGBuffer(	const CAGBuffer& oBuffer);

private:
	CAGBuffer(CAGBuffData *	pBuffData);

public:

/*	**************************************************************************
	Destructor
*/
public:
	virtual ~CAGBuffer();

public:
	void SetAutoRealloc(	long				nReallocBlockSize	= 1,	//	1 is the minimum value
							unsigned char		cDefaultValue		= 0);
	void GetAutoRealloc(	long&				nReallocBlockSize,
							unsigned char&		cDefaultValue)	const;
//
	void			SetAt(	long				nIndex,
							void *				pBuffer,
							long				nCount);
	void			SetAt(	long				nIndex,
							const CAGBuffer&	oBuffer);
	void			SetAt(	long				nIndex,
							const unsigned char	cChar);
	CAGBuffer		GetAt(	long				nIndex,
							long				nCount)			const;
	unsigned char	GetAt(	long				nIndex)			const;
//
	const CAGBuffer& operator=(		const CAGBuffer& oBuffer);
	const CAGBuffer& operator+=(	const CAGBuffer& oBuffer);
	const CAGBuffer& operator+=(	LPCTSTR pChaine);
	const CAGBuffer& operator+=(	unsigned char ucChar);

	void *	GetBuffer()											const;

	long	GetSize()											const;

	void ClearInstance();
	CAGBuffer Clone()											const;

	AGReturnCode Save(LPCTSTR	pFileName)						const;
	AGReturnCode Load(LPCTSTR	pFileName);

	void DoEncrypt( unsigned long nPublicKey);	/*	Not supported and not documented	*/
	void DoDecrypt(	unsigned long nPrivateKey);	/*	Not supported and not documented	*/

protected :
	const CAGBuffer& operator=(	CAGBuffData *	pBuffData);
private :

	CAGBuffData *	GetBuffData()								const;

	unsigned long Transcode(	unsigned long		nuValue,
								long				nPower,
								long				nCommon);
	void Free();

private :
	CAGBuffer(	const void*	pBuff,
				long		nSize,
				BOOL		bWantToCopy,
				BOOL		bWantToDelete);
/*	**************************************************************************
	Data Members	*/
private :
	CAGBuffData *	m_pBuffData;
/*	**************************************************************************	*/
/*	STATIC MEMBERS	*/
public:
	static void StaticIncrementVoidPtr(	void *&	pBuff,
										long	nIncrement);
	static void StaticBigLittleEndianConversion(	void *pSrcData,
													void *pDestData,
													long nSize);
#ifdef AG_ASCII_EBCDIC_CONVERSION
	static WCHAR	StaticASCIItoEBCDIC(WCHAR c);
	static WCHAR	StaticEBCDICtoASCII(WCHAR c);
	static CHAR		StaticASCIItoEBCDIC(unsigned CHAR c);
	static CHAR		StaticEBCDICtoASCII(unsigned CHAR c);
#endif	/*	def AG_ASCII_EBCDIC_CONVERSION	*/

/*	**************************************************************************	*/
//	FRIEND CLASSES AND FUNCTIONS

	friend class CAGArray;
	friend class CAGFrame;
	friend class CAGSlot;
	friend class CAGReceivingEndpoint;
	friend class CAGConvertFromBufferBlock;
	friend class CAGGenericGetBlock;
	friend class CAGGenericPutBlock;
	friend class CAGChannelSocket;
	friend class CAGLoadBlock;
	friend class CAGChannel;
	friend class CAGQueuesManager;
	friend class CAGCollection;
	friend CAGBuffer operator+(	const CAGBuffer& oBuffer1,
								const CAGBuffer& oBuffer2);
};

BOOL operator==(		const CAGBuffer& oBuffer1,
						const CAGBuffer& oBuffer2);

inline BOOL operator!=(	const CAGBuffer& oBuffer1,
						const CAGBuffer& oBuffer2)
	{ return !(oBuffer1 == oBuffer2);}

#if	defined(AG_PF_WIN32) || defined(AG_PF_OS_400)
struct	SAGFileRefData
{
	CAGString	m_sFileFullPath;
	CAGString	m_sFilePublicName;

	BOOL		m_bIsNamed;
	BOOL		m_bAutoDelete;
	long		m_nRefCount;
};
#else
class	SAGFileRefData
{
/*	**************************************************************************
	Constructor
*/
public:
	SAGFileRefData() : m_nRefCount(0) {};
/*	**************************************************************************
	Destructor
*/
public:
	virtual ~SAGFileRefData() {};

public:
	CAGString		m_sFileFullPath;
	CAGString		m_sFilePublicName;

	BOOL			m_bIsNamed;
	BOOL			m_bAutoDelete;
	CAGInterlocked	m_nRefCount;
};
#endif

class CAGFileRef : public CAGObject
{
/*	**************************************************************************
	Constructors
*/
public:
	CAGFileRef();
	CAGFileRef(	LPCTSTR		pFileFullPath,
				LPCTSTR		pFilePublicName,
				BOOL		bAutoDelete);

	CAGFileRef(	const CAGFileRef& oValue);

/*	**************************************************************************
	Destructor
*/
public:
	virtual ~CAGFileRef();

public:
	void			SetFileRef(	LPCTSTR		pFileFullPath,
								LPCTSTR		pFilePublicName,
								BOOL		bAutoDelete);
	LPCTSTR			SetFilePublicName(LPCTSTR pFilePublicName);
	CAGString		GetFilePublicName()						const;

	LPCTSTR			SetFileFullPath(LPCTSTR pFileFullPath);
	CAGString		GetFileFullPath()						const;

	BOOL			IsAutoDelete()							const;
	BOOL			SetAutoDelete(BOOL bAutoDelete);
	BOOL			IsNamed()								const;
	AGReturnCode	Name(LPCTSTR pFileName);

	const CAGFileRef& operator=(const CAGFileRef& oValue);

protected:
private:
	CAGFileRef(SAGFileRefData*	pSAGFileRefData);

	const CAGFileRef& operator=(SAGFileRefData*	pSAGFileRefData);

	AGReturnCode Init(	LPCTSTR		pFileFullPath,
						LPCTSTR		pFilePublicName,
						BOOL		bAutoDelete);

	void RemoveReference();

	static void StaticRemoveReference(SAGFileRefData*& pSAGFileRefData);

/*	**************************************************************************
	Data Members	*/
private:
	SAGFileRefData*	m_pSAGFileRefData;
#ifdef AG_PF_OS9
	u_int32 m_nOrigin;
#endif	// def AG_PF_OS9
/*	**************************************************************************	*/
//	FRIEND CLASSES AND FUNCTIONS
	friend class CAGSlot;
	friend class CAGCollection;
	friend class CAGGenericGetBlock;
};


/*	**************************************************************************	*/
#define AG_MAX_LEN_SLOT_NAME	1023			/*	The length of a slot name cannot be more than 1023 characters	*/
#define AG_CHAR_DOT				_T('.')
#define AG_STR_CHAR_DOT			_T(".")
#define AG_CHAR_END				_T('\0')

class CAGCollectionData;

/*	Short string representation of slot types a returned by CAGSlot::GetTypeStr()	*/
#define kStrString			_T("STR")
#define kStrByte			_T("BYT")
#define kStrShort			_T("SHR")
#define kStrBool			_T("BOO")
#define kStrLong			_T("LNG")
#define kStrFloat			_T("FLT")
#define kStrDouble			_T("DBL")
#define kStrDate			_T("DAT")
#define kStrBuff			_T("BUF")
#define kStrFrame			_T("FRA")
#define kStrArray			_T("ARR")
#define kStrUndefined		_T("UND")
#define kStrException		_T("EXC")
#define kStrFileRef			_T("FRF")
#define kStrPointer			_T("PTR")
#define kStrLong64			_T("L64")

/*	**************************************************************************	*/
// AGSlot class
/*	**************************************************************************	*/
class CAGSlot : public CAGObject
{
/*	**************************************************************************
	Constructors
*/
public:
	CAGSlot(const CAGSlot&		oAGSlot);
protected :
	CAGSlot(CAGCollectionData *	pAGCollectionData);
/*	**************************************************************************
	Destructor
*/
protected:
	virtual ~CAGSlot();

public :
	const CAGSlot& operator=(LPCTSTR				pValue);
#ifdef _UNICODE
	const CAGSlot& operator=(LPCSTR					pValue);
#else
	const CAGSlot& operator=(LPCWSTR				pValue);
#endif /* _UNICODE	*/
	const CAGSlot& operator=(const CAGString&		sValue);
	const CAGSlot& operator=(BOOL					bValue);
	const CAGSlot& operator=(unsigned char			nValue);
	const CAGSlot& operator=(short					nValue);
	const CAGSlot& operator=(long					nValue);
	const CAGSlot& operator=(float					fValue);
	const CAGSlot& operator=(double					fValue);
	const CAGSlot& operator=(const CAGFrame&		oValue);
	const CAGSlot& operator=(const CAGArray&		oValue);
	
	const CAGSlot& operator=(const CAGDateTime&	oValue);
	const CAGSlot& operator=(const CAGBuffer&		oValue);
#ifdef AG_USE_VARIANT
	const CAGSlot& operator=(const VARIANT&			oValue);
#endif	/*	def AG_USE_VARIANT	*/
	const CAGSlot& operator=(const CAGFileRef&		oValue);
	const CAGSlot& operator=(void*					pValue);
	const CAGSlot& operator=(const CAGSlot&			oValue);

	/*	Slot comparison. Beware, those functions throw an exception	*/
	/*	when the compared slots are not of the same type.	*/
	BOOL operator==(	const CAGSlot& oValue)	const	{return (Compare(oValue)==0);}
	BOOL operator!=(	const CAGSlot& oValue)	const	{return (Compare(oValue)!=0);}
	BOOL operator<(		const CAGSlot& oValue)	const	{return (Compare(oValue)<0);}
	BOOL operator<=(	const CAGSlot& oValue)	const	{return (Compare(oValue)<=0);}
	BOOL operator>(		const CAGSlot& oValue)	const	{return (Compare(oValue)>0);}
	BOOL operator>=(	const CAGSlot& oValue)	const	{return (Compare(oValue)>=0);}
	long Compare(		const CAGSlot& oValue)	const;

	agType		ClassOf()						const;
	CAGString	GetClassStr()					const;
	LPCTSTR		GetTypeStr()					const;

	AGReturnCode SetEmptyArray();	/*	Set a slot to an empty array	*/
	AGReturnCode SetEmptyFrame();	/*	Set a slot to an empty frame	*/
	/*	Boolean shortcuts. Should be use with IsNil and IsTrue.	*/
	AGReturnCode SetNil();
	AGReturnCode SetTrue();

	AGReturnCode IsString()						const;
	AGReturnCode IsByte()						const;
	AGReturnCode IsShort()						const;
	AGReturnCode IsFloat()						const;
	AGReturnCode IsDouble()						const;
	AGReturnCode IsLong()						const;
	AGReturnCode IsFrame()						const;
	AGReturnCode IsArray()						const;
	AGReturnCode IsNil()						const;
	AGReturnCode IsTrue()						const;
	AGReturnCode IsBuff()						const;
	AGReturnCode IsDateTime()					const;
	AGReturnCode IsBool()						const;
	AGReturnCode IsFileRef()					const;
	AGReturnCode IsPointer()					const;

	/* Cast operators overloading	*/
	operator CAGString()						const;	/*	agString	*/
	operator unsigned char()					const;	/*	agByte		*/
	operator short()							const;	/*	agShort		*/
	operator BOOL()								const;	/*	agBool		*/
	operator long()								const;	/*	agLong		*/
	operator float()							const;	/*	agFloat		*/
	operator double()							const;	/*	agDouble	*/
	operator CAGBuffer()						const;	/*	agBuffer	*/
	operator CAGFrame()							const;	/*	agFrame		*/
	operator CAGArray()							const;	/*	agArray		*/
	operator CAGFileRef()						const;	/*	agFileRef	*/
	operator CAGDateTime()						const;	/*	agDateTime	*/
	operator void*()							const;	/*	agPointer	*/

#ifdef AG_USE_VARIANT
	operator VARIANT()							const;
#endif	/*	def AG_USE_VARIANT	*/

	void GetValueStr(CAGString& sValue)			const;

/*	**************************************************************************	*/
protected :
	void Free();
	void TestValidSlot() const;

private:
	void Delete() const;

	void AssignFileRef(		SAGFileRefData *	pAGFileRefData);
	void AssignStringData(	SAGStringData *		pAGStringData,
							agType				eType);
	void AssignCollection(	CAGCollectionData *	pCollectionData,
							agType				eType);
	void AssignBuffer(		CAGBuffData *		pBuffData);
	void AssignDateTime(	CAGDateTime *		pAGDateTimeValue);

/*	**************************************************************************	*/
protected :
	union	{
				long				m_nLongValue;		/*	For byte, short, int and long values	*/
				double *			m_pDoubleValue;		/*	For float and double values				*/
				SAGStringData *		m_pAGStringData;	/*	For CAGString values					*/
				CAGDateTime *		m_pAGDateTimeValue;	/*	For CAGDateTime values					*/
				CAGCollectionData *	m_pCollectionData;	/*	For frame or array values				*/
				CAGBuffData *		m_pBuffData;		/*	For buffer values						*/
				SAGFileRefData *	m_pAGFileRefData;	/*	For file ref values						*/
				void*				m_pPointerValue;	/*	For pointer values						*/
			};

/*	**************************************************************************
	Data Members	*/
private:
	agType				m_eSlotType;					/*	The type of the slot	*/
	CAGCollectionData *	m_pOwnerCollectionData;
/*	**************************************************************************	*/
//	STATIC MEMBERS
public:
#ifdef AG_DO_NOT_USE_EXCEPTION
	static CAGSlot *	ms_pExceptionAGSlot;
	void StaticSetSlotException(CAGSlot * pAGSlot);
#endif	/*	def AG_DO_NOT_USE_EXCEPTION	*/
/*	**************************************************************************	*/
/*	FRIEND CLASSES AND FUNCTIONS	*/

	friend class CAGCollection;
	friend class CAGCollectionData;
	friend class CAGFrameData;
	friend class CAGArrayData;
	friend class CAGFrame;
	friend class CAGArray;
	friend class CAGRegistry;

#ifdef AG_DO_NOT_USE_EXCEPTION
	friend	CAGSlot * CreateExceptionAGSlot();
#endif	/*	def AG_DO_NOT_USE_EXCEPTION	*/
};


class CAGGenericPutBlock;
class CAGGenericGetBlock;

typedef AGReturnCode (*_AGActionProc)(	CAGSlot *	pSlot,
										LPCTSTR		pSlotName,
										void *		pParam);

typedef void *	AG_SLOT_ENTRY;


class CAGCollection : public CAGObject
{
public:
/*	**************************************************************************
	Constructors
*/
	CAGCollection();
	CAGCollection(const CAGCollection & oAGCollection);

private:
	CAGCollection(CAGCollectionData * pCollectionData);

public:
/*	**************************************************************************
	Destructor
*/
	virtual ~CAGCollection();

	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								LPCTSTR				pValue);
#ifdef _UNICODE
	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								LPCSTR				pValue);
#else
	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								LPCWSTR				pValue);
#endif /* _UNICODE	*/
	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								BOOL				boolValue);
	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								const CAGString &	sValue);
	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								unsigned char		bValue);
	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								short				iValue);
	AGReturnCode SetSlotValue(	LPCTSTR				pPath, 
								long				lValue);
	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								float				fltValue);
	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								double				dblValue);
	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								const CAGDateTime &	oSystemTimeValue);
	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								const CAGFrame &	oValue);
	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								const CAGArray &	oValue);
	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								const CAGBuffer &	oBuff);
	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								const CAGFileRef &	oAGFileRef);
	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								void *				pValue);
	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								const CAGSlot &		oAOV);
#ifdef AG_USE_VARIANT
	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								const VARIANT &		oValue);
#endif	/*	def AG_USE_VARIANT	*/

	AGReturnCode HasSlot(		LPCTSTR				pPath,
								CAGSlot **			pValue = NULL)	const;

	AGReturnCode IsByte(		LPCTSTR				pPath,
								unsigned char *		pValue = NULL)	const;
	AGReturnCode IsShort(		LPCTSTR				pPath,
								short *				pValue = NULL)	const;
	AGReturnCode IsFloat(		LPCTSTR				pPath,
								float *				pValue = NULL)	const;
	AGReturnCode IsDouble(		LPCTSTR				pPath,
								double *			pValue = NULL)	const;
	AGReturnCode IsDateTime(	LPCTSTR				pPath,
								CAGDateTime *		pValue = NULL)	const;
	AGReturnCode IsBool(		LPCTSTR				pPath,
								BOOL *				pValue = NULL)	const;
	AGReturnCode IsString(		LPCTSTR				pPath,
								CAGString *			pValue = NULL)	const;
	AGReturnCode IsLong(		LPCTSTR				pPath,
								long *				pValue = NULL)	const;
	AGReturnCode IsFrame(		LPCTSTR				pPath,
								CAGFrame *			pValue = NULL)	const;
	AGReturnCode IsArray(		LPCTSTR				pPath,
								CAGArray *			pValue = NULL)	const;
	AGReturnCode IsNil(			LPCTSTR				pPath)			const;
	AGReturnCode IsTrue(		LPCTSTR				pPath)			const;
	AGReturnCode IsBuff(		LPCTSTR				pPath,
								CAGBuffer *			pValue = NULL)	const;
	AGReturnCode IsFileRef(		LPCTSTR				pPath,
								CAGFileRef *		pValue = NULL)	const;
	AGReturnCode IsPointer(		LPCTSTR				pPath,
								void **				pValue = NULL)	const;

	AGReturnCode GetFileFromSlot(	LPCTSTR		pPath,
									LPCTSTR		pFileName)			const;
	AGReturnCode PutFileIntoSlot(	LPCTSTR		pPath,
									LPCTSTR		pFileName);

	AGReturnCode SetSlotEmptyArray(	LPCTSTR		pPath);
	AGReturnCode SetSlotEmptyFrame(	LPCTSTR		pPath);
	AGReturnCode SetSlotNil(		LPCTSTR		pPath);
	AGReturnCode SetSlotTrue(		LPCTSTR		pPath);

	AGReturnCode RemoveSlot(		LPCTSTR		pPath);

	CAGSlot& operator[](LPCTSTR		pPath);
	CAGSlot& operator[](CAGArray &	oArray);

	CAGString Dump(BOOL	bToDebugger = FALSE)						const;

	long Length()													const;
	void Reset();

	AGReturnCode Save(	LPCTSTR		pFileName)						const;	
	AGReturnCode Load(	LPCTSTR		pFileName);

	void	 SetTempDirectory(LPCTSTR pDirectory);
	LPCTSTR	 GetTempDirectory()										const;

	AGReturnCode ConvertToBuffer(				CAGBuffer &			oBuffer)	const;
	AGReturnCode ConvertToBufferWithFileRef(	CAGBuffer &			oBuffer)	const;
	AGReturnCode ConvertFromBuffer(				const CAGBuffer &	oBuffer);


	/* Reserved for AGBroker	*/
	AGReturnCode SaveWithFileRef(LPCTSTR pFileName)					const;

protected:

	AGReturnCode	Init();
	void			Free();

	virtual CAGCollectionData *	CreateData()								= 0;
	virtual char GetType()											const	= 0;
	virtual AGReturnCode CheckType(char cType)						const	= 0;
	virtual BOOL SlotNameIsValid(	LPCTSTR		pSlotName,
									long &		nValue)				const	= 0;

	AGReturnCode PutCollectionTo(				CAGGenericPutBlock &	oPutBlock) const;
	AGReturnCode GetCollectionFrom(				CAGGenericGetBlock &	oGetBlock);
	AGReturnCode PutCollectionToRecursive(		CAGGenericPutBlock &	oPutBlock,
												BOOL					bIsLastBlock,
												char &					cIsDirectlySended) const;
	AGReturnCode GetCollectionFromRecursive(	CAGGenericGetBlock &	oGetBlock);

	CAGCollectionData * GetCollectionData()							const	{ return m_pCollectionData; };

	const CAGCollection & operator = (CAGCollectionData *	pCollectionData);
	const CAGCollection & operator = (const CAGCollection &	oAGCollection);

	void Clone(		CAGCollection &	oDestCollection)				const;
	void DeepClone(	CAGCollection &	oDestCollection)				const;

	void DumpString(	CAGString &	sDump)							const;
	void DumpString2(	CAGString &	sDump,
						CAGString &	sTab)							const;

	AGReturnCode ScanFrame(	CAGArray &	oPathArray,
							CAGSlot *&	pAGSlot,
							long		iPos,
							BOOL		bCreate,
							BOOL		bWantRemoveSlot);

	AGReturnCode PathParsing(	LPCTSTR		pPath,
								CAGArray &	oArray)					const;

	AGReturnCode PathParsingAndScanFrame(	LPCTSTR		pPath,
											CAGSlot *&	pAGSlot,
											BOOL		bCreate = TRUE);

	AGReturnCode IsType(	LPCTSTR		pPath,
							agType		eType,
							void *		pValue,
							BOOL		bWantBool	= FALSE,
							BOOL		bTestBool	= FALSE)		const;

	AGReturnCode SimpleRemoveSlot(	LPCTSTR		pSlotName,
									long		nIndex);
	AGReturnCode SimpleAddSlot(		LPCTSTR		pSlotName,
									long		nIndex,
									CAGSlot *&	pAGSlot);
	AGReturnCode SimpleHasSlot(		LPCTSTR		pSlotName,
									long		nIndex,
									CAGSlot *&	pAGSlot)			const;
/*	**************************************************************************
	Data Members
*/
public:
	CAGString m_sErrorReason;
protected:
	CAGCollectionData *	m_pCollectionData;

/*	**************************************************************************
	FRIEND CLASSES AND FUNCTIONS
*/
	friend class CAGSlot;
	friend class CAGChannel;
	friend class CAGArray;
	friend class CAGFrame;
};


/*	**************************************************************************
	AGFrame class
*/

#ifdef	AG_PF_WINCE
#	define AG_DEFAULT_HASH_SIZE	23L
#else
#	define AG_DEFAULT_HASH_SIZE	113L
#endif	/* def AG_PF_WINCE */

#ifdef	AG_PF_WINCE
#	define AG_DEFAULT_BLOCK_SIZE	10L
#else
#	define AG_DEFAULT_BLOCK_SIZE	10L
#endif	/* def AG_PF_WINCE */

class CAGFrame : public CAGCollection
{
public:
	CAGFrame();
	CAGFrame(	unsigned long nHashSize,
				unsigned long nBlockSize);
	CAGFrame(const CAGFrame &oAGFrame);

private:
	CAGFrame(CAGCollectionData * pCollectionData);

public:
	virtual ~CAGFrame();

	CAGFrame Clone()											const;
	CAGFrame DeepClone()										const;

	AG_SLOT_ENTRY	GetStartSlot()								const;
	AGReturnCode	GetNextSlot(	AG_SLOT_ENTRY&	pNextSlot,
									CAGString &		sSlotName,
									CAGSlot *&		pAGSlot)	const;

	AGReturnCode PerformOnEachSlot(	_AGActionProc	pActionProc,
									void *			pParam = NULL);

	AGReturnCode MakeSlotArray(CAGArray & oArray)				const;

	static BOOL StaticSlotNameIsValid(LPCTSTR pSlotName);

private:
	virtual CAGCollectionData *	CreateData();
	virtual char GetType()										const;
	virtual AGReturnCode CheckType(char cType)					const;
	virtual BOOL SlotNameIsValid(	LPCTSTR	pSlotName,
									long &	nValue)				const;

	const CAGFrame & operator=(CAGCollectionData * pCollectionData);

private:
	unsigned long m_nHashSize;
	unsigned long m_nBlockSize;

/*	**************************************************************************	*/
/*	FRIEND CLASSES AND FUNCTIONS	*/
	
	friend class CAGCollection;
	friend class CAGSlot;
	friend class CAGRegistry;
};


/*	**************************************************************************
	AGArray class
*/
class CAGArray : public CAGCollection
{
public :
	CAGArray();
	CAGArray(const CAGArray &oArray);

private:
	CAGArray(CAGCollectionData * pCollectionData);

public:
	virtual ~CAGArray();

	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								LPCTSTR				pValue);
#ifdef _UNICODE
	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								LPCSTR				pValue);
#else
	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								LPCWSTR				pValue);
#endif /* _UNICODE	*/
	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								BOOL				boolValue);
	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								const CAGString &	sValue);
	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								unsigned char		bValue);
	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								short				iValue);
	AGReturnCode SetSlotValue(	LPCTSTR				pPath, 
								long				lValue);
	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								float				fltValue);
	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								double				dblValue);
	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								const CAGDateTime &	oSystemTimeValue);
	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								const CAGFrame &	oValue);
	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								const CAGArray &	oValue);
	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								const CAGBuffer &	oBuff);
	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								const CAGFileRef &	oAGFileRef);
	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								void *				pValue);
	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								const CAGSlot &		oAOV);
#ifdef AG_USE_VARIANT
	AGReturnCode SetSlotValue(	LPCTSTR				pPath,
								const VARIANT &		oValue);
#endif	/*	def AG_USE_VARIANT	*/

	AGReturnCode SetSlotValue(	long				nIndex,
								LPCTSTR				pValue);
#ifdef _UNICODE
	AGReturnCode SetSlotValue(	long				nIndex,
								LPCSTR				pValue);
#else
	AGReturnCode SetSlotValue(	long				nIndex,
								LPCWSTR				pValue);
#endif
	AGReturnCode SetSlotValue(	long				nIndex,
								BOOL				boolValue);
	AGReturnCode SetSlotValue(	long				nIndex,
								const CAGString &	sValue);
	AGReturnCode SetSlotValue(	long				nIndex,
								unsigned char		bValue);
	AGReturnCode SetSlotValue(	long				nIndex,
								short				iValue);
	AGReturnCode SetSlotValue(	long				nIndex, 
								long				lValue);
	AGReturnCode SetSlotValue(	long				nIndex,
								float				fltValue);
	AGReturnCode SetSlotValue(	long				nIndex,
								double				dblValue);
	AGReturnCode SetSlotValue(	long				nIndex,
								const CAGDateTime &	oSystemTimeValue);
	AGReturnCode SetSlotValue(	long				nIndex,
								const CAGFrame &	oValue);
	AGReturnCode SetSlotValue(	long				nIndex,
								const CAGArray &	oValue);
	AGReturnCode SetSlotValue(	long				nIndex,
								const CAGBuffer &	oBuff);
	AGReturnCode SetSlotValue(	long				nIndex,
								const CAGFileRef &	oAGFileRef);
	AGReturnCode SetSlotValue(	long				nIndex,
								void *				pValue);
	AGReturnCode SetSlotValue(	long				nIndex,
								const CAGSlot &		oAOV);
#ifdef AG_USE_VARIANT
	AGReturnCode SetSlotValue(	long				nIndex,
								const VARIANT &		oValue);
#endif

	AGReturnCode HasSlot(		LPCTSTR				pPath,
								CAGSlot **			pValue = NULL) const;
	AGReturnCode HasSlot(		long				nIndex,
								CAGSlot **			pValue = NULL) const;

	AGReturnCode IsByte(		LPCTSTR				pPath,
								unsigned char *		pValue = NULL) const;
	AGReturnCode IsShort(		LPCTSTR				pPath,
								short *				pValue = NULL) const;
	AGReturnCode IsFloat(		LPCTSTR				pPath,
								float *				pValue = NULL) const;
	AGReturnCode IsDouble(		LPCTSTR				pPath,
								double *			pValue = NULL) const;
	AGReturnCode IsDateTime(	LPCTSTR				pPath,
								CAGDateTime *		pValue = NULL) const;
	AGReturnCode IsBool(		LPCTSTR				pPath,
								BOOL *				pValue = NULL) const;
	AGReturnCode IsString(		LPCTSTR				pPath,
								CAGString *			pValue = NULL) const;
	AGReturnCode IsLong(		LPCTSTR				pPath,
								long *				pValue = NULL) const;
	AGReturnCode IsFrame(		LPCTSTR				pPath,
								CAGFrame *			pValue = NULL) const;
	AGReturnCode IsArray(		LPCTSTR				pPath,
								CAGArray *			pValue = NULL) const;
	AGReturnCode IsNil(			LPCTSTR				pPath) const;
	AGReturnCode IsTrue(		LPCTSTR				pPath) const;
	AGReturnCode IsBuff(		LPCTSTR				pPath,
								CAGBuffer *			pValue = NULL) const;
	AGReturnCode IsFileRef(		LPCTSTR				pPath,
								CAGFileRef *		pValue = NULL) const;
	AGReturnCode IsPointer(		LPCTSTR				pPath,
								void **				pValue = NULL) const;

	AGReturnCode IsByte(		long				nIndex,
								unsigned char *		pValue = NULL) const;
	AGReturnCode IsShort(		long				nIndex,
								short *				pValue = NULL) const;
	AGReturnCode IsFloat(		long				nIndex,
								float *				pValue = NULL) const;
	AGReturnCode IsDouble(		long				nIndex,
								double *			pValue = NULL) const;
	AGReturnCode IsDateTime(	long				nIndex,
								CAGDateTime *		pValue = NULL) const;
	AGReturnCode IsBool(		long				nIndex,
								BOOL *				pValue = NULL) const;
	AGReturnCode IsString(		long				nIndex,
								CAGString *			pValue = NULL) const;
	AGReturnCode IsLong(		long				nIndex,
								long *				pValue = NULL) const;
	AGReturnCode IsFrame(		long				nIndex,
								CAGFrame *			pValue = NULL) const;
	AGReturnCode IsArray(		long				nIndex,
								CAGArray *			pValue = NULL) const;
	AGReturnCode IsNil(			long				nIndex) const;
	AGReturnCode IsTrue(		long				nIndex) const;
	AGReturnCode IsBuff(		long				nIndex,
								CAGBuffer *			pValue = NULL) const;
	AGReturnCode IsFileRef(		long				nIndex,
								CAGFileRef *		pValue = NULL) const;
	AGReturnCode IsPointer(		long				nIndex,
								void **				pValue = NULL) const;

	AGReturnCode GetFileFromSlot(	LPCTSTR		pPath,
									LPCTSTR		pFileName)			const;
	AGReturnCode PutFileIntoSlot(	LPCTSTR		pPath,
									LPCTSTR		pFileName);

	AGReturnCode GetFileFromSlot(	long		nIndex,
									LPCTSTR		pFileName)			const;
	AGReturnCode PutFileIntoSlot(	long		nIndex,
									LPCTSTR		pFileName);

	AGReturnCode SetSlotEmptyArray(	LPCTSTR		pPath);
	AGReturnCode SetSlotEmptyFrame(	LPCTSTR		pPath);
	AGReturnCode SetSlotNil(		LPCTSTR		pPath);
	AGReturnCode SetSlotTrue(		LPCTSTR		pPath);

	AGReturnCode SetSlotEmptyArray(	long		nIndex);
	AGReturnCode SetSlotEmptyFrame(	long		nIndex);
	AGReturnCode SetSlotNil(		long		nIndex);
	AGReturnCode SetSlotTrue(		long		nIndex);

	AGReturnCode RemoveSlot(		LPCTSTR		pPath);
	AGReturnCode RemoveSlot(		long		nIndex);

	CAGSlot& operator[](LPCTSTR		pPath);
	CAGSlot& operator[](long		nIndex);
	CAGSlot& operator[](CAGArray&	oPathArray);

	AGReturnCode AddArraySlot(LPCTSTR				pString);
#ifdef _UNICODE
	AGReturnCode AddArraySlot(LPCSTR				pString);
#else
	AGReturnCode AddArraySlot(LPCWSTR				pString);
#endif
	AGReturnCode AddArraySlot(const CAGString&		sString);
	AGReturnCode AddArraySlot(unsigned char			nValue);
	AGReturnCode AddArraySlot(short					nValue);
	AGReturnCode AddArraySlot(BOOL					bValue);
	AGReturnCode AddArraySlot(long					nValue);
	AGReturnCode AddArraySlot(float					fValue);
	AGReturnCode AddArraySlot(double				fValue);
	AGReturnCode AddArraySlot(const CAGFrame&		oFrame);
	AGReturnCode AddArraySlot(const CAGSlot&		oSlot);
	AGReturnCode AddArraySlot(const CAGArray&		oArray);
	AGReturnCode AddArraySlot(const CAGBuffer&		oBuff);
	AGReturnCode AddArraySlot(const CAGFileRef&		oFileRef);
	AGReturnCode AddArraySlot(void*					pValue);
	AGReturnCode AddArraySlot(const CAGDateTime&	oSystemTime);
#ifdef AG_USE_VARIANT
	AGReturnCode AddArraySlot(const VARIANT&		oValue);
#endif

	AGReturnCode AddArraySlotAt(	long				nPos,
									LPCTSTR				pString);
#ifdef _UNICODE
	AGReturnCode AddArraySlotAt(	long				nPos,
									LPCSTR				pString);
#else
	AGReturnCode AddArraySlotAt(	long				nPos,
									LPCWSTR				pString);
#endif
	AGReturnCode AddArraySlotAt(	long				nPos,
									const CAGString&	sString);
	AGReturnCode AddArraySlotAt(	long				nPos,
									unsigned char		nValue);
	AGReturnCode AddArraySlotAt(	long				nPos,
									short				nValue);
	AGReturnCode AddArraySlotAt(	long				nPos,
									BOOL				bValue);
	AGReturnCode AddArraySlotAt(	long				nPos,
									long				nValue);
	AGReturnCode AddArraySlotAt(	long				nPos,
									float				fValue);
	AGReturnCode AddArraySlotAt(	long				nPos,
									double				fValue);
	AGReturnCode AddArraySlotAt(	long				nPos,
									const CAGFrame&		oFrame);
	AGReturnCode AddArraySlotAt(	long				nPos,
									const CAGSlot&		oSlot);
	AGReturnCode AddArraySlotAt(	long				nPos,
									const CAGArray&		oArray);
	AGReturnCode AddArraySlotAt(	long				nPos,
									const CAGBuffer&	oBuff);
	AGReturnCode AddArraySlotAt(	long				nPos,
									const CAGFileRef&	oFileRef);
	AGReturnCode AddArraySlotAt(	long				nPos,
									void*				pValue);
	AGReturnCode AddArraySlotAt(	long				nPos,
									const CAGDateTime&	oSystemTime);
#ifdef AG_USE_VARIANT
	AGReturnCode AddArraySlotAt(	long				nPos,
									const VARIANT&		oValue);
#endif

	AGReturnCode SetLength(long nLength);

	CAGArray Clone()											const;
	CAGArray DeepClone()										const;

	static BOOL StaticSlotNameIsValid(LPCTSTR pSlotName);

	AGReturnCode	ArrayMunger(	long		nDstStart,
									long		nDstCount,
									CAGArray&	oSrcArray,
									long		nSrcStart,
									long		nSrcCount);

	AGReturnCode RemoveElements(	long	nIndex,
									long	nCount = 1L);

private:
	virtual CAGCollectionData *	CreateData();
	virtual char GetType()										const;
	virtual AGReturnCode CheckType(char cType)					const;
	virtual BOOL SlotNameIsValid(	LPCTSTR		pSlotName,
									long &		nValue)			const;

	AGReturnCode InsertNewSlotAt(	long		nIndex,
									CAGSlot *&	pAGSlot);

	const CAGArray & operator=(CAGCollectionData * pCollectionData);

/*	**************************************************************************	*/
/*	FRIEND CLASSES AND FUNCTIONS	*/
	
	friend class CAGCollection;
	friend class CAGSlot;
};


//	**********************************************************************
#ifdef AG_USE_API_STRING
//	AGAPIString class
//	Used to provide ANSI strings (char *) to non Unicode API functions
//	in an Unicode build
class CAGAPIString
{
/*	**************************************************************************
	Constructor
*/
public :
	CAGAPIString(CAGString& sStringSource);
/*	**************************************************************************
	Destructor
*/
public:
	~CAGAPIString();
public:
	operator const char *();
private:
	const char * m_pString;
};

#else	/*	ifdef AG_USE_API_STRING	*/

/*	Unused in a non Unicode build	*/
#define CAGAPIString	CAGString

#endif	/*	def else AG_USE_API_STRING	*/


#ifdef AG_USE_UNICODE_STRING
//	**********************************************************************
class CAGUnicodeString
{
/*	**************************************************************************
	Constructor
*/
public :
	CAGUnicodeString();
	CAGUnicodeString(CAGString &	sStringSource);
	CAGUnicodeString(LPCTSTR		pStringSource);
/*	**************************************************************************
	Destructor
*/
public:
	~CAGUnicodeString();
public:
	const CAGUnicodeString & operator=(CAGString &	sStringSource);
	const CAGUnicodeString & operator=(LPCTSTR		pStringSource);
	operator const WCHAR *();
private:
	WCHAR * m_pString;
};
#else	/*	ifdef AG_USE_UNICODE_STRING	*/

#define CAGUnicodeString	CAGString

#endif	/*	def else AG_USE_UNICODE_STRING	*/


//////////////////////////////////////////////////////////////////
//////////////////////////////////////	CAGRegistry

//	**********************************************************************
//	Registry read/write class using extensivly the frames
#ifdef AG_USE_REGISTRY
class CAGRegistry : public CAGObject
{
#if	!defined(AG_PF_OS_400) && !defined(AG_PF_UNIX)
public:
	enum	arFlushMode	{	ar_fmAllowFlush					= 0,
							ar_fmDisallowFlush				= 1};
	enum	arOpenMode	{	ar_omCreateIfNotFound			= 0,
							ar_omDontCreateIfNotFound		= 1};
	enum	arReadMode	{	ar_rmEnumerateRegistryKey		= 0,
							ar_rmDontEnumerateRegistryKey	= 1};
/*	**************************************************************************
	Constructors
*/
public :
	CAGRegistry(	HKEY		hOpenKey,
					arFlushMode	eAllowFlush);
/*	**************************************************************************
	Destructor
*/
public:
	virtual ~CAGRegistry();

public:
	AGReturnCode GetRegistryFrame(				CAGString			sPath,
												CAGFrame&			oFrame,
												arOpenMode			eOpenMode,
												arReadMode			eReadMode	=	ar_rmDontEnumerateRegistryKey);
	AGReturnCode SetRegistryFrame(				CAGString			sPath,
												CAGFrame&			oFrame);
#endif	/* !defined(AG_PF_OS_400) && !defined(AG_PF_UNIX) */
public:

	static void StaticStringToArray(			const CAGString&	sChaine,
												const TCHAR			cChar,
												CAGArray&			oArray);
	static void StaticArrayToString(			CAGString&			sChaine,
												const TCHAR			cChar,
												CAGArray &			oArray);

	static void StaticStringArrayToBuff(		CAGBuffer&			oBuff,
												CAGArray&			oArray,
												LPCTSTR				pSubPath = NULL);
	static void StatiCAGBuffToStringArray(		CAGBuffer&			oBuff,
												CAGArray&			oArray,
												LPCTSTR				pSubPath = NULL);
#if	!defined(AG_PF_OS_400) && !defined(AG_PF_UNIX)
	AGReturnCode	DeleteSubKey(				LPCTSTR				pPath,
												LPCTSTR				pSubKey);
	AGReturnCode	DeleteAllSubKeys(			LPCTSTR				pPath);

	TCHAR		SetListCharacter(	const TCHAR	cListCharacter);
protected:
	AGReturnCode SetRegistryFrame(				CAGString			sPath,
												HKEY				hKey,
												CAGFrame&			oFrame);
	AGReturnCode GetValueEntry(					HKEY				hKey,
												CAGString			sEntry,
												CAGFrame&			oFrame,
												arOpenMode			eOpenMode,
												LPCTSTR				pSubPath);
	AGReturnCode SetValueEntry(					HKEY				hKey,
												CAGString			sEntry,
												CAGFrame&			oFrame,
												LPCTSTR				pSubPath);

	AGReturnCode OpenKey(						const CAGString&	sPath,
												HKEY&				hKey,
												arReadMode			eReadMode);
	AGReturnCode OpenCreateKey(					const CAGString&	sPath,
												HKEY&				hKey,
												DWORD&				dwDisposition,
												arReadMode			eReadMode);
	AGReturnCode	CloseKey(					HKEY&				hKey);
	AGReturnCode	FlushKey(					HKEY&				hKey);

	void	AddSlotsToFrame(					HKEY				hKey,
												CAGFrame&			oFrame);
	void	GetAllSubKeys(						LPCTSTR				pPath,
												CAGArray&			oSubKeyNamesArray);
/*	**************************************************************************
	Data Members	*/
private :
	HKEY		m_hOpenKey;
	arFlushMode	m_eAllowFlush;		/*	If set to ar_fmAllowFlush, every set operation calls a RegFlush.	*/
									/*	This can be time consuming when manipulating the registry	*/
									/*	frequently but also safer in a multi-task application.	*/
	TCHAR		m_cListCharacter;
#endif	//	!defined(AG_PF_OS_400) && !defined(AG_PF_UNIX)
};
#	endif	/*	def AG_USE_REGISTRY	*/

//////////////////////////////////////////////////////////////////
//////////////////////////////////////	CAGPath
class CAGPath
{
/*	**************************************************************************
	Constructors
*/
public:
	CAGPath(long	nIndex);
	CAGPath(TCHAR	tChar);
	CAGPath(const	CAGString & sPath);
	CAGPath(LPCTSTR	pPath);
	CAGPath(const	CAGPath & oPath);
/*	**************************************************************************
	Destructor
*/
public:
	virtual ~CAGPath();

	const CAGPath & operator=(const CAGPath&		oAGPath);
	operator LPCTSTR() const;
/*	**************************************************************************
	Data Members	*/
private:
	CAGString m_sPath;

/*	**************************************************************************	*/
//	FRIEND CLASSES AND FUNCTIONS
	friend CAGPath operator+(	const CAGPath&		oPath1,	const CAGPath&	oPath2);
	friend CAGPath operator+(	const CAGPath&		oPath,	const CAGString&sPath);
	friend CAGPath operator+(	const CAGString&	sPath,	const CAGPath&	oPath);
	friend CAGPath operator+(	const CAGPath&		oPath,	LPCTSTR			pPath);
	friend CAGPath operator+(	LPCTSTR				pPath,	const CAGPath&	oPath);
	friend CAGPath operator+(	const CAGPath&		oPath,	TCHAR			cPath);
	friend CAGPath operator+(	TCHAR				cPath,	const CAGPath&	oPath);
	friend CAGPath operator+(	const CAGPath&		oPath,	long			nIndex);
	friend CAGPath operator+(	long				nIndex,	const CAGPath&	oPath);
#ifdef _UNICODE
	friend CAGPath operator+(	const CAGPath&		oPath,	LPCSTR			pPath);
	friend CAGPath operator+(	LPCSTR				pPath,	const CAGPath&	oPath);
	friend CAGPath operator+(	const CAGPath&		oPath,	CHAR			cPath);
	friend CAGPath operator+(	CHAR				cPath,	const CAGPath&	oPath);
#else
	friend CAGPath operator+(	const CAGPath&		oPath,	LPCWSTR			pPath);
	friend CAGPath operator+(	LPCWSTR				pPath,	const CAGPath&	oPath);
	friend CAGPath operator+(	const CAGPath&		oPath,	WCHAR			cPath);
	friend CAGPath operator+(	WCHAR				cPath,	const CAGPath&	oPath);
#endif /* _UNICODE	*/
};


//////////////////////////////////////////////////////////////////
//////////////////////////////////////	AGFile
#if		defined(AG_PF_WIN32)
#	ifdef AG_PF_WINCE
#		define _O_RDONLY       0x0000  /* open for reading only */
#		define _O_WRONLY       0x0001  /* open for writing only */
#		define _O_RDWR         0x0002  /* open for reading and writing */
#		define _O_APPEND       0x0008  /* writes done at eof */

#		define _O_CREAT        0x0100  /* create and open file */
#		define _O_TRUNC        0x0200  /* open and truncate */
#		define _O_EXCL         0x0400  /* open only if file doesn't already exist */
#		define _O_TEXT         0x4000  /* file mode is text (translated) */
#		define _O_BINARY       0x8000  /* file mode is binary (untranslated) */
#		define _O_RAW		   _O_BINARY
#		define _O_NOINHERIT    0x0080  /* child process doesn't inherit file */
#		define _O_TEMPORARY    0x0040  /* temporary file bit */
#		define _O_SHORT_LIVED  0x1000  /* temporary storage file, try not to flush */
#		define _O_SEQUENTIAL   0x0020  /* file access is primarily sequential */
#		define _O_RANDOM       0x0010  /* file access is primarily random */

#		define _S_IREAD        0000400         /* read permission, owner */
#		define _S_IWRITE       0000200         /* write permission, owner */
#	endif	//	def AG_PF_WINCE

#define AG_FILE_O_APPEND		_O_APPEND
#define AG_FILE_O_BINARY		_O_BINARY
#define AG_FILE_O_CREAT			_O_CREAT
#define AG_FILE_O_EXCL			_O_EXCL
#define AG_FILE_O_RDONLY		_O_RDONLY
#define AG_FILE_O_RDWR			_O_RDWR
#if		!defined(AG_PF_WINCE)
#	define AG_FILE_O_TEXT			_O_TEXT
#endif	//	!defined(AG_PF_WINCE)
#define AG_FILE_O_TRUNC			_O_TRUNC
#define AG_FILE_O_WRONLY		_O_WRONLY

#define AG_FILE_S_IREAD			_S_IREAD
#define AG_FILE_S_IWRITE		_S_IWRITE

#define	AG_FILE_MAX_PATH		MAX_PATH

#if		defined(AG_PF_WINCE)
#	define	AG_FILE_INVALID_HANDLE	INVALID_HANDLE_VALUE
#	define	AG_SEEK_SET				FILE_BEGIN
#	define	AG_SEEK_CUR				FILE_CURRENT
#	define	AG_SEEK_END				FILE_END
#else
#	define	AG_FILE_INVALID_HANDLE	-1
#	define	AG_SEEK_SET				SEEK_SET
#	define	AG_SEEK_CUR				SEEK_CUR
#	define	AG_SEEK_END				SEEK_END
#endif	//	defined(AG_PF_WIN32)

#if		!defined(AG_PF_WINCE)
#	define	AG_FILE_DIR				DIR*
#	define	AG_FILE_DIR_ENTRY		struct dirent*
#endif	//	!defined(AG_PF_WINCE)

#define	AG_FILE_SEPARATOR_STR		_T("\\")
#define	AG_FILE_SEPARATOR_C			_T('\\')

#elif	defined(AG_PF_UNIX)

#define AG_FILE_O_APPEND		O_APPEND
#ifndef O_BINARY
#define AG_FILE_O_BINARY		0
#else
#define AG_FILE_O_BINARY		O_BINARY
#endif	//	ndef O_BINARY
#define AG_FILE_O_CREAT			O_CREAT
#define AG_FILE_O_EXCL			O_EXCL
#define AG_FILE_O_RDONLY		O_RDONLY
#define AG_FILE_O_RDWR			O_RDWR
#define AG_FILE_O_TEXT			O_TEXT
#define AG_FILE_O_TRUNC			O_TRUNC
#define AG_FILE_O_WRONLY		O_WRONLY

#ifdef 	AG_PF_VXWORKS
#define AG_FILE_S_IREAD			_FREAD
#define AG_FILE_S_IWRITE		_FWRITE
#else
#define AG_FILE_S_IREAD			S_IREAD
#define AG_FILE_S_IWRITE		S_IWRITE
#endif

#define	AG_FILE_MAX_PATH		255

#define	AG_FILE_INVALID_HANDLE	-1

#define	AG_FILE_DIR				DIR*
#define	AG_FILE_DIR_ENTRY		struct dirent*

#ifdef AG_PF_OS9
#define	AG_SEEK_SET				0
#define	AG_SEEK_CUR				1
#define	AG_SEEK_END				2
#else
#define	AG_SEEK_SET				SEEK_SET
#define	AG_SEEK_CUR				SEEK_CUR
#define	AG_SEEK_END				SEEK_END
#endif // def AG_PF_OS9

#define	AG_FILE_SEPARATOR_STR	_T("/")
#define	AG_FILE_SEPARATOR_C		_T('/')

#elif	defined(AG_PF_EPOC)

#define AG_FILE_O_APPEND		O_APPEND
#define AG_FILE_O_BINARY		O_BINARY
#define AG_FILE_O_CREAT			O_CREAT
#define AG_FILE_O_EXCL			O_EXCL
#define AG_FILE_O_RDONLY		O_RDONLY
#define AG_FILE_O_RDWR			O_RDWR
#define AG_FILE_O_TEXT			O_TEXT
#define AG_FILE_O_TRUNC			O_TRUNC
#define AG_FILE_O_WRONLY		O_WRONLY

#define AG_FILE_S_IREAD			S_IREAD
#define AG_FILE_S_IWRITE		S_IWRITE

#define	AG_FILE_MAX_PATH		255

#define	AG_FILE_INVALID_HANDLE	-1

#define	AG_SEEK_SET				SEEK_SET
#define	AG_SEEK_CUR				SEEK_CUR
#define	AG_SEEK_END				SEEK_END

#define	AG_FILE_SEPARATOR_STR		_T("\\")
#define	AG_FILE_SEPARATOR_C			_T('\\')

#elif	defined(AG_PF_OS_400)

#define AG_FILE_O_APPEND		O_APPEND
#define AG_FILE_O_BINARY		0			//	O_BINARY n'existe pas pour OS_400
#define AG_FILE_O_CREAT			O_CREAT
#define AG_FILE_O_EXCL			O_EXCL
#define AG_FILE_O_RDONLY		O_RDONLY
#define AG_FILE_O_RDWR			O_RDWR
#define AG_FILE_O_TEXT			O_TEXT
#define AG_FILE_O_TRUNC			O_TRUNC
#define AG_FILE_O_WRONLY		O_WRONLY

#define AG_FILE_S_IREAD			S_IRUSR		//	en lecture que pour l'owner du fichier
#define AG_FILE_S_IWRITE		S_IWUSR		//	en ecriture que pour l'owner du fichier

#define	AG_FILE_MAX_PATH		255

#define	AG_FILE_INVALID_HANDLE	-1

#define	AG_FILE_DIR				DIR*
#define	AG_FILE_DIR_ENTRY		struct dirent*


#define	AG_SEEK_SET				SEEK_SET
#define	AG_SEEK_CUR				SEEK_CUR
#define	AG_SEEK_END				SEEK_END

#define	AG_FILE_SEPARATOR_STR	_T("/")
#define	AG_FILE_SEPARATOR_C		_T('/')

#elif defined(AG_PF_PALMOS)

#	define _O_RDONLY       0x0000  /* open for reading only */
#	define _O_WRONLY       0x0001  /* open for writing only */
#	define _O_RDWR         0x0002  /* open for reading and writing */
#	define _O_APPEND       0x0008  /* writes done at eof */

#	define _O_CREAT        0x0100  /* create and open file */
#	define _O_TRUNC        0x0200  /* open and truncate */
#	define _O_EXCL         0x0400  /* open only if file doesn't already exist */
#	define _O_TEXT         0x4000  /* file mode is text (translated) */
#	define _O_BINARY       0x8000  /* file mode is binary (untranslated) */
#	define _O_RAW		   _O_BINARY
#	define _O_NOINHERIT    0x0080  /* child process doesn't inherit file */
#	define _O_TEMPORARY    0x0040  /* temporary file bit */
#	define _O_SHORT_LIVED  0x1000  /* temporary storage file, try not to flush */
#	define _O_SEQUENTIAL   0x0020  /* file access is primarily sequential */
#	define _O_RANDOM       0x0010  /* file access is primarily random */

#	define _S_IREAD        0000400         /* read permission, owner */
#	define _S_IWRITE       0000200         /* write permission, owner */

#define AG_FILE_O_APPEND		_O_APPEND
#define AG_FILE_O_BINARY		_O_BINARY
#define AG_FILE_O_CREAT			_O_CREAT
#define AG_FILE_O_EXCL			_O_EXCL
#define AG_FILE_O_RDONLY		_O_RDONLY
#define AG_FILE_O_RDWR			_O_RDWR

#define	AG_FILE_SEPARATOR_STR		_T("\\")
#define	AG_FILE_SEPARATOR_C			_T('\\')

#define	AG_SEEK_SET				fileOriginBeginning
#define	AG_SEEK_CUR				fileOriginCurrent
#define	AG_SEEK_END				fileOriginEnd

#define AG_FILE_O_TEXT			_O_TEXT
#define AG_FILE_O_TRUNC			_O_TRUNC
#define AG_FILE_O_WRONLY		_O_WRONLY

#define AG_FILE_S_IREAD			_S_IREAD
#define AG_FILE_S_IWRITE		_S_IWRITE

#define	AG_FILE_MAX_PATH		255

#define	AG_FILE_INVALID_HANDLE	0

#define	AG_FILE_DIR				DIR*
#define	AG_FILE_DIR_ENTRY		struct dirent*

#else

#error No platform

#endif	//	def WIN32

#define	AG_FILE_TEMPORARY_EXT	_T("tmp")


class CAGFile : public CAGObject  
{
public:
	CAGFile();
	virtual ~CAGFile();

	AGReturnCode Open(	LPCTSTR			pFileName,
						int				iOpenFlag,
						int				iPermissionMode);

	AGReturnCode Write(	const void *	pBuffer,
						unsigned long	iCount);

	AGReturnCode WriteAt(	long			lPos,
							const void *	pData,
							unsigned long	nSize);

	AGReturnCode Read(	void *			pBuffer,
						unsigned long	iCount);

	AGReturnCode Seek(	long	nOffset,
						int		nOrigin);

	AGReturnCode Close();

	BOOL IsOpen() { return m_bIsOpen; };

	AGReturnCode GetFileSize(unsigned long& lSize);

	CAGString GetFileName()	{ return m_sFilename; };

	static AGReturnCode	StaticErase(	LPCTSTR	pFileName);

	static AGReturnCode	StaticRename(	LPCTSTR pOldFileName,
										LPCTSTR pNewFileName);

	static AGReturnCode StaticGetFileSize(	LPCTSTR			pFileName,
											unsigned long&	lSize);

	static AGReturnCode StaticCopyFile(	LPCTSTR pSrcFileName,
										LPCTSTR pDestFileName);

	static CAGString StaticGetCurrentDirectory();

	static AGReturnCode StaticGetTemporaryFileName(	LPCTSTR			pDirectory,
													CAGString&		sFileName);

	static AGReturnCode StaticCreateDirectory(LPCTSTR pDirectory);

private:
#ifdef AG_PF_OS9
	u_int32 m_nOrigin;
#endif	// def AG_PF_OS9

	void Free();
#if	defined(AG_PF_WINCE)
	HANDLE	OpenWinCE(	LPCTSTR		path,
						int			oflag,
						int			iPermissionMode);
#endif	//	defined(AG_PF_WINCE)
private:
#if	defined(AG_PF_WINCE)
	HANDLE		m_iFileHandle;
#elif defined(AG_PF_PALMOS)
	FileHand	m_iFileHandle;
#elif defined(AG_PF_OS9)
	path_id		m_iFileHandle;
#else
	int			m_iFileHandle;
#endif	//	defined(AG_PF_WINCE)
	BOOL		m_bIsOpen;

	CAGString	m_sFilename;
};


//////////////////////////////////////////////////////////////////
//////////////////////////////////////	OS Manager
#ifndef VER_PLATFORM_WIN32s
#	define VER_PLATFORM_WIN32s             0
#endif	/*	ndef VER_PLATFORM_WIN32s	*/

#ifndef VER_PLATFORM_WIN32_WINDOWS
#	define VER_PLATFORM_WIN32_WINDOWS      1
#endif	/*	ndef VER_PLATFORM_WIN32_WINDOWS	*/

#ifndef VER_PLATFORM_WIN32_NT
#	define VER_PLATFORM_WIN32_NT           2
#endif	/*	ndef VER_PLATFORM_WIN32_NT	*/

#ifndef VER_PLATFORM_WIN32_CE
#	define VER_PLATFORM_WIN32_CE           3
#endif	/*	ndef VER_PLATFORM_WIN32_HH	*/

#ifndef VER_PLATFORM_LINUX
#	define VER_PLATFORM_LINUX              0x0100
#endif	/*	ndef VER_PLATFORM_LINUX	*/

#ifndef VER_PLATFORM_SUN_OS
#	define VER_PLATFORM_SUN_OS             0x0150
#endif	/*	ndef VER_PLATFORM_SUN_OS	*/

#ifndef VER_PLATFORM_OS400
#	define VER_PLATFORM_OS400              0x0200
#endif	/*	ndef VER_PLATFORM_OS400	*/

#ifndef VER_PLATFORM_EPOC
#	define VER_PLATFORM_EPOC               0x0300
#endif	/*	ndef VER_PLATFORM_EPOC16	*/

#ifndef VER_PLATFORM_EPOC16
#	define VER_PLATFORM_EPOC16             (VER_PLATFORM_EPOC | 0x01)
#endif	/*	ndef VER_PLATFORM_EPOC16	*/

#ifndef VER_PLATFORM_EPOC32
#	define VER_PLATFORM_EPOC32             (VER_PLATFORM_EPOC | 0x02)
#endif	/*	ndef VER_PLATFORM_EPOC32	*/

#ifndef VER_PLATFORM_PALMOS
#	define VER_PLATFORM_PALMOS             0x0400
#endif	/*	ndef VER_PLATFORM_PALMOS	*/

#ifndef VER_PLATFORM_PALMOSV1
#	define VER_PLATFORM_PALMOSV1           (VER_PLATFORM_PALMOS | 0x01)
#endif	/*	ndef VER_PLATFORM_PALMOSV1	*/

#ifndef VER_PLATFORM_PALMOSV2
#	define VER_PLATFORM_PALMOSV2           (VER_PLATFORM_PALMOS | 0x02)
#endif	/*	ndef VER_PLATFORM_PALMOSV2	*/

#ifndef VER_PLATFORM_PALMOSV3
#	define VER_PLATFORM_PALMOSV3           (VER_PLATFORM_PALMOS | 0x03)
#endif	/*	ndef VER_PLATFORM_PALMOSV3	*/

#ifndef VER_PLATFORM_QNX
#	define VER_PLATFORM_QNX					0x0500
#endif	/*	ndef VER_PLATFORM_QNX		*/

#ifndef VER_PLATFORM_VXWORKS
#	define VER_PLATFORM_VXWORKS				0x0600
#endif	/*	ndef VER_PLATFORM_VXWORKS		*/

#ifndef VER_PLATFORM_LYNX
#	define VER_PLATFORM_LYNX				0x0700
#endif	/*	ndef VER_PLATFORM_LYNX		*/

#ifndef VER_PLATFORM_OS9
#	define VER_PLATFORM_OS9					0x0800
#endif	/*	ndef VER_PLATFORM_OS9		*/

#ifndef VER_PLATFORM_HP_UX
#	define VER_PLATFORM_HP_UX				0x0900
#endif	/*	ndef VER_PLATFORM_HP_UX		*/

#ifndef VER_PLATFORM_DIGITAL_UNIX
#	define VER_PLATFORM_DIGITAL_UNIX		0x1000
#endif	/*	ndef VER_PLATFORM_DIGITAL_UNIX		*/


#ifndef _WINNT_
#define _WINNT_

#define LANG_NEUTRAL                     0x00

#define LANG_ALBANIAN                    0x1c
#define LANG_ARABIC                      0x01
#define LANG_BAHASA                      0x21
#define LANG_BULGARIAN                   0x02
#define LANG_CATALAN                     0x03
#define LANG_CHINESE                     0x04
#define LANG_CZECH                       0x05
#define LANG_DANISH                      0x06
#define LANG_DUTCH                       0x13
#define LANG_ENGLISH                     0x09
#define LANG_FINNISH                     0x0b
#define LANG_FRENCH                      0x0c
#define LANG_GERMAN                      0x07
#define LANG_GREEK                       0x08
#define LANG_HEBREW                      0x0d
#define LANG_HUNGARIAN                   0x0e
#define LANG_ICELANDIC                   0x0f
#define LANG_ITALIAN                     0x10
#define LANG_JAPANESE                    0x11
#define LANG_KOREAN                      0x12
#define LANG_NORWEGIAN                   0x14
#define LANG_POLISH                      0x15
#define LANG_PORTUGUESE                  0x16
#define LANG_RHAETO_ROMAN                0x17
#define LANG_ROMANIAN                    0x18
#define LANG_RUSSIAN                     0x19
#define LANG_SERBO_CROATIAN              0x1a
#define LANG_SLOVAK                      0x1b
#define LANG_SPANISH                     0x0a
#define LANG_SWEDISH                     0x1d
#define LANG_THAI                        0x1e
#define LANG_TURKISH                     0x1f
#define LANG_URDU                        0x20

#define MAKELANGID(p, s)       ((((unsigned short)(s)) << 10) | (unsigned short)(p))
#define PRIMARYLANGID(lgid)    ((unsigned short)(lgid) & 0x3ff)
#define SUBLANGID(lgid)        ((unsigned short)(lgid) >> 10)

#endif	/*	ndef _WINNT_	*/


class CAGOSManager : public CAGObject
{
/*	**************************************************************************
	Constructor
*/
public:
	CAGOSManager();
/*	**************************************************************************
	Destructor
*/
public:
	virtual ~CAGOSManager();
public:
/*	OS	*/
	DWORD GetPlatform()					const	{ return m_dwPlatform;}
	BOOL IsUnderWin32s()				const	{ return m_dwPlatform == VER_PLATFORM_WIN32s;}
	BOOL IsUnderWin95()					const	{ return m_dwPlatform == VER_PLATFORM_WIN32_WINDOWS;}
	BOOL IsUnderWinNT()					const	{ return m_dwPlatform == VER_PLATFORM_WIN32_NT;}
	BOOL IsUnderWin32()					const	{ return (m_dwPlatform == VER_PLATFORM_WIN32_WINDOWS) || (m_dwPlatform == VER_PLATFORM_WIN32_NT) || (m_dwPlatform == VER_PLATFORM_WIN32_CE);}
	BOOL IsUnderWinNTServer()			const	{ return m_bWinNTServer;}
	BOOL IsUnderWinCE()					const	{ return m_dwPlatform == VER_PLATFORM_WIN32_CE;}
	BOOL IsUnderUnix()					const	{ return (m_dwPlatform == VER_PLATFORM_LINUX) || (m_dwPlatform == VER_PLATFORM_SUN_OS);}
	BOOL IsUnderLinux()					const	{ return m_dwPlatform == VER_PLATFORM_LINUX;}
	BOOL IsUnderSunOS()					const	{ return m_dwPlatform == VER_PLATFORM_SUN_OS;}
	BOOL IsUnderHPUX()					const	{ return m_dwPlatform == VER_PLATFORM_HP_UX;}
	BOOL IsUnderDigitalUNIX()			const	{ return m_dwPlatform == VER_PLATFORM_DIGITAL_UNIX;}
	BOOL IsUnderOS400()					const	{ return m_dwPlatform == VER_PLATFORM_OS400;}
	BOOL IsUnderEPOC()					const	{ return m_dwPlatform && VER_PLATFORM_EPOC;}
	BOOL IsUnderEPOC16()				const	{ return m_dwPlatform == VER_PLATFORM_EPOC16;}
	BOOL IsUnderEPOC32()				const	{ return m_dwPlatform == VER_PLATFORM_EPOC32;}
	BOOL IsUnderPalmOS()				const	{ return m_dwPlatform && VER_PLATFORM_PALMOS;}
	BOOL IsUnderPalmOSV1()				const	{ return m_dwPlatform == VER_PLATFORM_PALMOSV1;}
	BOOL IsUnderPalmOSV2()				const	{ return m_dwPlatform == VER_PLATFORM_PALMOSV2;}
	BOOL IsUnderPalmOSV3()				const	{ return m_dwPlatform == VER_PLATFORM_PALMOSV3;}
	BOOL IsUnderQNX()					const	{ return m_dwPlatform == VER_PLATFORM_QNX;}
	BOOL IsUnderVxWorks()				const	{ return m_dwPlatform == VER_PLATFORM_VXWORKS;}
	CAGString GetPlatformString()		const;
/*	OS Version	*/
	DWORD	GetOSMajorVersion()			const	{ return m_dwMajorVersion;}
	DWORD	GetOSMinorVersion()			const	{ return m_dwMajorVersion;}
	DWORD	GetOSBuildNumber()			const	{ return m_dwBuildNumber;}
	CAGString GetVersionString()		const;
/*	System Language	*/
	DWORD	GetSystemLanguageCode()		const	{ return m_nSystemLanguageCode;}
	BOOL SystemUsesFrenchLanguage()		const	{ return (PRIMARYLANGID(m_nSystemLanguageCode)==LANG_FRENCH);}
	BOOL SystemUsesEnglishLanguage()	const	{ return (PRIMARYLANGID(m_nSystemLanguageCode)==LANG_ENGLISH);}
	BOOL SystemUsesGermanLanguage()		const	{ return (PRIMARYLANGID(m_nSystemLanguageCode)==LANG_GERMAN);}
	BOOL SystemUsesItalianLanguage()	const	{ return (PRIMARYLANGID(m_nSystemLanguageCode)==LANG_ITALIAN);}
	BOOL SystemUsesPortugueseLanguage()	const	{ return (PRIMARYLANGID(m_nSystemLanguageCode)==LANG_PORTUGUESE);}
	BOOL SystemUsesSpanishLanguage()	const	{ return (PRIMARYLANGID(m_nSystemLanguageCode)==LANG_SPANISH);}
	CAGString GetSystemLanguageCodeString()	const;
/*	User Language	*/
	DWORD	GetUserLanguageCode()		const	{ return m_nUserLanguageCode;}
	BOOL UserUsesFrenchLanguage()		const	{ return (PRIMARYLANGID(m_nUserLanguageCode)==LANG_FRENCH);}
	BOOL UserUsesEnglishLanguage()		const	{ return (PRIMARYLANGID(m_nUserLanguageCode)==LANG_ENGLISH);}
	BOOL UserUsesGermanLanguage()		const	{ return (PRIMARYLANGID(m_nUserLanguageCode)==LANG_GERMAN);}
	BOOL UserUsesItalianLanguage()		const	{ return (PRIMARYLANGID(m_nUserLanguageCode)==LANG_ITALIAN);}
	BOOL UserUsesPortugueseLanguage()	const	{ return (PRIMARYLANGID(m_nUserLanguageCode)==LANG_PORTUGUESE);}
	BOOL UserUsesSpanishLanguage()		const	{ return (PRIMARYLANGID(m_nUserLanguageCode)==LANG_SPANISH);}
	CAGString GetUserLanguageCodeString()	const;
/*	**************************************************************************
	Data Members	*/
private:
	DWORD	m_dwPlatform;
	DWORD	m_dwMajorVersion;
	DWORD	m_dwMinorVersion;
	DWORD	m_dwBuildNumber;
	BOOL	m_bWinNTServer;
	long	m_nSystemLanguageCode;
	long	m_nUserLanguageCode;
	BOOL	m_bServer;
};

#endif /* _ACTIVE_GATEWAY_CORE_H_	*/

