//	Copyright 1996-2000 Netsize Corporation. All Rights reserved.
//	e-mail	:	support@netsize.com
//				info@netsize.com
//	web		:	http://www.netsize.com/

//	DO NOT MODIFY

#ifndef _ACTIVE_GATEWAY_ENDPOINT_H_
#define _ACTIVE_GATEWAY_ENDPOINT_H_

#include <AGCore.h>

#define AG_DEFAULT_PIPE_PORT_STR		_T("Default^Broker^AG")
#define AG_DEFAULT_SOCKET_PORT_STR		_T("23789")
#define AG_DEFAULT_SOCKET_PORT_LONG		23789

#define AG_DEFAULT_SMTP_PORT_STR		_T("25")
#define AG_DEFAULT_SMTP_PORT_LONG		25

#define AG_DEFAULT_POP3_PORT_STR		_T("110")
#define AG_DEFAULT_POP3_PORT_LONG		110

#define AG_DEFAULT_HTTP_PORT_STR		_T("80")
#define AG_DEFAULT_HTTP_PORT_LONG		80

#define AG_DEFAULT_FTP_PORT_STR			_T("21")
#define AG_DEFAULT_FTP_PORT_LONG		21

#define AG_DEFAULT_TIMEOUT				5000L
#define AG_DEFAULT_ENDPOINT_NAME		_T("$$ag$default$endpoint$name$$")
#define AG_DEFAULT_PEER_NAME			_T("$$ag$default$peer$name$$")
#define AG_DEFAULT_BROKER_ADDRESS		_T("$$ag$default$broker$address$$")

#if		defined(AG_PF_PALMOS)
AGReturnCode InitializeEndpoint();
#else	//	platforms
#endif	//	platforms
// Active Gateway define to use with AGComEndpoint event
#define AG_SLOT_DATA_IS_PRESENT			_T("dataispresent")

enum	agChannelType		{	ag_ctTCPIPSocket		= 0,
								ag_ctPipe				= 1,	//	Only available with a broker running on WinNT Server or Workstation
								ag_ctInfrared			= 2,
								ag_ctSMTP				= 3,
								ag_ctPOP3				= 4,	//	Not yet supported
								ag_ctHTTP				= 5,
								ag_ctFTP				= 6		//	Not yet supported
							};
enum	agCommunicationMode	{	ag_cmSync	= 0,
								ag_cmAsync	= 1
							};

class CAGChannel;			//	PRIVATE CLASS
class CAGWorkerThreadTask;	//	PRIVATE CLASS
//	**********************************************************************
//	Base class for all endpoint classes
class CAGEndpoint : public CAGObject
{
protected:
// **********************************************************************
// Constructor
	CAGEndpoint();
	CAGEndpoint(	CAGChannel *			pChannel,
					CAGFrame &				oParamFrame,
					CAGWorkerThreadTask *	pAGWorkerThreadTask = NULL);
// **********************************************************************
// Destructor
	virtual ~CAGEndpoint();

public :
	virtual void Close()	= 0;

	BOOL					IsOpen(BOOL bCheck);
	LPCTSTR					GetAGPort()					const;
	LPCTSTR					GetAGBroker()				const;

	LPCTSTR					GetProxyPort()				const;
	LPCTSTR					GetProxy()					const;

	AGReturnCode			SetPeerName(LPCTSTR	pPeerName);
	LPCTSTR					GetPeerName()				const	{ return m_sPeerName; }
	agCommunicationMode		GetCommunicationMode()		const	{ return m_eCommunicationMode; }

	CAGString				GetHostName();
	CAGString				GetHostAddress();
	long					SetTimeout(const long nTimeout);
	long					GetTimeout()				const;

	LPCTSTR					GetEndpointName()			const	{ return m_sName; }

	long					GetEndpointBytesIn()		const;
	long					GetEndpointBytesOut()		const;
	long					GetPeerBytesIn()			const;
	long					GetPeerBytesOut()			const;

	LPCTSTR					GetPassword()
							{ return m_sPassword;					}
	LPCTSTR					GetEndpointVersion()
							{ return m_sEndpointVersion;			}
	long					GetEndpointProtocolVersion()
							{ return m_nEndpointProtocolVersion;	}
	LPCTSTR					GetEndpointIPAddr()
							{ return m_sEndpointIPAddr;				}
	LPCTSTR					GetEndpointDNSName()
							{ return m_sEndpointDNSName;			}
	LPCTSTR					GetEndpointPlatform()
							{ return m_sEndpointPlatform;			}
	LPCTSTR					GetEndpointPlatformVersion()
							{ return m_sEndpointPlatformVersion;	}
	LPCTSTR					GetEndpointSystemLanguageCode()
							{ return m_sEndpointSystemLanguageCode; }
	LPCTSTR					GetEndpointUserLanguageCode()
							{ return m_sEndpointUserLanguageCode;	}
	long					GetEndpointCharacterCode()
							{ return m_nEndpointCharacterCode;		}

	LPCTSTR					GetErrorReason()
							{ return m_sErrorReason;				}

protected :
	AGReturnCode			SetNameAnyway(		LPCTSTR		pEndpointName);
	AGReturnCode			SetPeerNameAnyway(	LPCTSTR		pPeerName);
	AGReturnCode			SetName(			LPCTSTR		pEndpointName);
	AGReturnCode			SetPassword(		LPCTSTR		pEndpointPassword);
	void					SetAGPort(			LPCTSTR		pAGBrokerPort);
	void					SetAGBroker(		LPCTSTR		pAGBroker);

	void					SetProxyPort(		LPCTSTR		pProxyPort);
	void					SetProxy(			LPCTSTR		pProxy);

	CAGString				GetChannelName()			const;
	void					Idle();
	void					SetAGWorkerThreadTask(	CAGWorkerThreadTask *	pAGWorkerThreadTask);
	CAGWorkerThreadTask *	GetAGWorkerThreadTask()		const	{ return m_pAGWorkerThreadTask; }
	CAGChannel *			GetChannel()				const	{ return m_pChannel; }
protected :
	CAGChannel *			m_pChannel;
	agCommunicationMode		m_eCommunicationMode;
	CAGWorkerThreadTask *	m_pAGWorkerThreadTask;

	CAGString				m_sPeerName;
	CAGString				m_sName;
	CAGString				m_sPassword;

	CAGString				m_sEndpointVersion;
	long					m_nEndpointProtocolVersion;
	CAGString				m_sEndpointIPAddr;
	CAGString				m_sEndpointDNSName;

	CAGString				m_sEndpointPlatform;
	CAGString				m_sEndpointPlatformVersion;
	CAGString				m_sEndpointSystemLanguageCode;
	CAGString				m_sEndpointUserLanguageCode;
	long					m_nEndpointCharacterCode;

	CAGString				m_sErrorReason;

// **********************************************************************
//	FRIEND CLASS AND FUNCTIONS
	friend class CAGReceivingEndpoint;		//	PRIVATE CLASS
	friend class CAGWTTListening;			//	PRIVATE CLASS
	friend class CAGWTTConnection;			//	PRIVATE CLASS
	friend class CAGKernel;					//	PRIVATE CLASS
	friend class CAGEndpointKernelData;		//	PRIVATE CLASS
	friend class CAGbAPIBroker;				//	PRIVATE CLASS
	friend class CAGBrokerExtensionHelper;	//	PRIVATE CLASS
};

// **********************************************************************
class CAGCallingEndpoint : public CAGEndpoint
{
protected:
// **********************************************************************
// Constructor
	CAGCallingEndpoint();
	CAGCallingEndpoint(					CAGFrame &			oParamFrame);
// **********************************************************************
// Destructor
	virtual ~CAGCallingEndpoint();
public :

	virtual AGReturnCode Open(		CAGFrame &			oParamFrame) = 0;
	virtual AGReturnCode Send(		CAGFrame &			oFrame,
									CAGFrame &			oParamFrame) = 0;
	virtual AGReturnCode Get(		CAGFrame &			oFrame,
									CAGFrame &			oParamFrame) = 0;

	agChannelType GetChannelType()				const	{ return m_eChannelType; };
protected:
	AGReturnCode	CreateChannel(	agChannelType	eChannelType,
									CAGString &		sBrokerAddress,
									CAGString &		sBrokerPort,
									CAGString &		sProxyAddress,
									CAGString &		sProxyPort);

protected:
	agChannelType	m_eChannelType;
};

// **********************************************************************
class CAGCppEndpoint : public CAGCallingEndpoint
{
public :
// **********************************************************************
// Constructor
	CAGCppEndpoint();
	CAGCppEndpoint(CAGFrame &	oParamFrame);
// **********************************************************************
// Destructor
	virtual ~CAGCppEndpoint();

public:
	virtual void Close();
	virtual AGReturnCode Open(	CAGFrame &		oParamFrame);

	AGReturnCode Ping(			long&			nTime);
	virtual AGReturnCode Send(	CAGFrame &		oFrame,
								CAGFrame &		oParamFrame);
	virtual AGReturnCode Get(	CAGFrame &		oFrame,
								CAGFrame &		oParamFrame);
private:
	void Init();

	AGReturnCode DoSendAsync(	CAGFrame&		oFrame,
								LPCTSTR			pPeerPath,
								CAGFrame&		oParamFrame);
	AGReturnCode DoGetAsync(	CAGFrame&		oFrame,
								LPCTSTR			pPeerPath,
								CAGFrame&		oParamFrame);

	AGReturnCode DoSendSync(	CAGFrame&		oFrame);
	AGReturnCode DoGetSync(		CAGFrame&		oFrame);

private:
	CAGBuffer	m_oSendBuffer;
	CAGBuffer	m_oGetBuffer;
	CAGBuffer	m_oGetSuccessBuffer;
	CAGBuffer	m_oGetTimeoutBuffer;
};

#ifdef AG_USE_REMOTE_ACCESS
//////////////////////////////////////	CAGRasConnection

////////////////////////////////////////////////////////////////
#include "RAS.h"
//////////////////////////////////////////////////////////////////
class CAGRasConnection;
class CAGRasConnectionData;
typedef void (*_AGDialResultCallbackProc)(	CAGRasConnection * pAGRasConnection, AGReturnCode	nError);
typedef void (*_AGDialProgressCallbackProc)(CAGRasConnection * pAGRasConnection);

////////////////////////////////////////////////////////////////
class CAGRasConnection
{
public:
	CAGRasConnection(	HINSTANCE hInstance = NULL);
							//	hInstance is only used under Windows CE (AG_PF_WINCE defined)
	virtual ~CAGRasConnection();
public:
	HINSTANCE SetInstance(	HINSTANCE hInstance);
	HINSTANCE GetInstance() const;
////////////////////	Dialing and Hanging up Ras Communications
	AGReturnCode	Dial(					CAGString					sEntryName,
											CAGString					sUserName	= _T(""),
											CAGString					sPassword	= _T(""),
											CAGString					sDomain		= _T(""));
	AGReturnCode	HangUp();
////////////////////	Notification
	AGReturnCode	SetNotificationWindow(	HWND						hNotificationWindow);
	AGReturnCode	SetDialResultProc(		_AGDialResultCallbackProc	pAGDialResultProc);
	AGReturnCode	SetDialProgressProc(	_AGDialProgressCallbackProc	pAGDialProgressProc);
public:
	RASCONNSTATE	GetConnectionState()						const;
	DWORD			GetDialError()								const;
	CAGString		GetDialErrorString()						const;
	AGReturnCode	IsConnected();
	AGReturnCode	GetDeviceType(	CAGString& sDeviceType);
	AGReturnCode	GetDeviceName(	CAGString& sDeviceName);
private:
	CAGRasConnectionData *		m_pAGRasConnectionData;

// **********************************************************************
//	STATIC MEMBERS
public:
	static BOOL			StaticIsRasAvailable();
	static UINT			StaticGetEventID();
	static AGReturnCode	StaticGetRasEntries(		CAGArray& oRasEntries);
	static AGReturnCode	StaticGetRasConnections(	CAGArray& oRasConnections);
private:
	static CAGArray				ms_oRasConnectionArray;
	static CAGCriticalSection	ms_oAGCriticalSection;

// **********************************************************************
//	FRIEND CLASS AND FUNCTIONS
	friend class CAGRasConnectionData;
#ifdef AG_PF_WINCE
	friend LRESULT CALLBACK WinCEProxyWndProc(HWND, UINT uiID, WPARAM wParam, LPARAM lParam);
#endif	//	def AG_PF_WINCE
};

#endif	//	def AG_USE_REMOTE_ACCESS

#endif // _ACTIVE_GATEWAY_ENDPOINT_H_
