//	Copyright 1996-2000 Netsize Corporation. All Rights reserved.
//	e-mail	:	support@netsize.com
//				info@netsize.com
//	web		:	http://www.netsize.com/

//	DO NOT MODIFY

#ifndef _ACTIVE_GATEWAY_EXTENSION_H_
#define _ACTIVE_GATEWAY_EXTENSION_H_


#define AG_SESSION_PREFERENCES_OBJECT		_T("PreferencesObject")
#define AG_SESSION_PREFERENCES_FORMAT		_T("PreferencesFormat")


class CAGbAPI : public CAGObject
{
public:
	enum	agExtensionMode	{	ag_emBrokerSession		= 0,
								ag_emEndpointSession	= 1,
								ag_emAdminSession		= 2,
								ag_emAgentSession		= 3};
public:
// **********************************************************************
	CAGbAPI(											CAGFrame&			oSessionParams);
	virtual ~CAGbAPI();
public:
/*	*****************************************************************************************************/
// **********************************************************************
//	Initialization of a session
//	TO BE OVERRIDEN (OPTIONALY)
//	For better error handling, you should perform all initialization
//	tasks (memory allocation, opening database connections,...) in
//	this function rather than in the constructor
//	If the return code is different from agSuccess, an error will be logged
//	and the session will prematurately be ended
	virtual AGReturnCode	InitSession()										{ return agSuccess;}
	virtual AGReturnCode	InitSessionEx(		CAGFrame&	oParams)			{ oParams=oParams;return agSuccess;}

// **********************************************************************
//	Deinitialization of a session
//	TO BE OVERRIDEN (OPTIONALY)
//	For better error handling, you should perform all deinitialization
//	tasks (memory deallocation, closing database connections,...) in
//	this function rather than in the destructor
	virtual void			DeinitSession()										{}
	virtual void			DeinitSessionEx(	CAGFrame&	oParams)			{ oParams=oParams;}

// **********************************************************************
//	Message processing
//	TO BE OVERRIDEN (REQUIRED)
//	Handles all the message processing operation
	virtual AGReturnCode	Process(					CAGFrame&			oInMessage,
														CAGFrame&			oInParams,
														CAGFrame&			oOutMessage,
														CAGFrame&			oOutParams)	= 0;

// **********************************************************************
//	Information
//	TO BE OVERRIDEN (REQUIRED)
//	Provide the broker with all the required and optional information about
//	the extension (ID, version, ...)
	virtual AGReturnCode	Info(						CAGFrame&			oInformation,
														CAGFrame&			oParams)	= 0;

// **********************************************************************
//	Action performed at idle time
//	TO BE OVERRIDEN (OPTIONALY)
	virtual AGReturnCode	Idle()											{ return agSuccess;}
																			
/*	*****************************************************************************************************/
//	HELPER FUNCTIONS														
			BOOL			IsBrokerSession()								{ return (m_eExtensionMode == ag_emBrokerSession);	}
			BOOL			IsEndpointSession()								{ return (m_eExtensionMode == ag_emEndpointSession);}
			BOOL			IsAdminSession()								{ return (m_eExtensionMode == ag_emAdminSession);}
			BOOL			IsAgentSession()								{ return (m_eExtensionMode == ag_emAgentSession);}
			BOOL			IsBeingKilled()									{ return (m_bIsBeingKilled);}
			BOOL			IsDemo()										{ return (m_bDemo);}
			AGReturnCode	IsExtensionLoaded(			LPCTSTR				pExtensionName);
			AGReturnCode	ProcessByAnotherExtension(	CAGFrame&			oInMessage,
														CAGFrame&			oInParams,
														CAGFrame&			oOutMessage,
														CAGFrame&			oOutParams,
														LPCTSTR				pExtensionName);
			AGReturnCode	GetInfo(					CAGFrame&			oInformation);
			AGReturnCode	Send(						CAGFrame&			oMessage,
														CAGFrame&			oParams);
private:																	
	virtual AGReturnCode	_IsExtensionLoaded(			LPCTSTR				pExtensionName);
	virtual AGReturnCode	_ProcessByAnotherExtension(	CAGFrame&			oInMessage,
														CAGFrame&			oInParams,
														CAGFrame&			oOutMessage,
														CAGFrame&			oOutParams,
														LPCTSTR				pExtensionName);
	virtual AGReturnCode	_GetInfo(					CAGFrame&			oFrame);
	virtual AGReturnCode	_Send(						CAGFrame&			oMessage,
														CAGFrame&			oParams);
	virtual AGReturnCode	_Get(						CAGFrame&			oMessage,
														CAGFrame&			oParams,
														const CAGString&	sPeerPath);

	void		SetPreferencesData(						const CAGFrame&		oFrame)
	{ m_oPreferencesData = oFrame; }
	CAGFrame	GetPreferencesFrame()
	{ return m_oPreferencesData; }
// **********************************************************************
//	DATA MEMBERS
private:
	agExtensionMode	m_eExtensionMode;
	CAGbAPI *		m_pAGbAPIBroker;
	BOOL			m_bIsBeingKilled;
	BOOL			m_bDemo;
protected:
	CAGFrame		m_oPreferencesData;
public:
	CAGString		m_sInitErrorInfo;

// **********************************************************************
//	STATIC MEMBERS
public:
#if	defined(AG_PF_WIN32)
	static	HINSTANCE	StaticGetInstanceHandle();
#endif	//	defined(AG_PF_WIN32)
	static	CAGString	StaticGetAppName();
private:
#if	defined(AG_PF_WIN32)
	static	HINSTANCE	StaticSetInstanceHandle(		HINSTANCE			hInstance);
#endif	//	defined(AG_PF_WIN32)											
	static	CAGString	StaticSetAppName(				LPCTSTR				pAppName);
private:
#if	defined(AG_PF_WIN32)
	static	HINSTANCE	ms_hInstance;
#endif	//	defined(AG_PF_WIN32)
	static	CAGString	ms_bAppName;

// **********************************************************************
	friend class CAGBrokerExtensionHelper;
	friend class CAGLibraryExtensionServer;
};


/*	*****************************************************************************************************/
//	AG_DECLARE_AGB_EXTENSION
//	AG_EXPORT_AGB_EXTENSION_CLASS

#define AG_DECLARE_AGB_EXTENSION(UserEAPIClass)\
public:\
	static UserEAPIClass * StaticGetBrokerSession()\
		{\
			return UserEAPIClass::ms_pBrokerSession;\
		};\
	static void StaticSetBrokerSession(UserEAPIClass * pUserEAPIClass)\
		{\
			UserEAPIClass::ms_pBrokerSession = pUserEAPIClass;\
		};\
private:\
	static UserEAPIClass * ms_pBrokerSession;

#ifndef	AG_AGBAPI_EXPORT_DECLARATION
#	if	defined(AG_PF_WIN32)
#		define AG_AGBAPI_EXPORT_DECLARATION				__declspec(dllexport)
#	else
#		define AG_AGBAPI_EXPORT_DECLARATION
#	endif	//	defined(AG_PF_WIN32)
#endif	//	ndef	AG_AGBAPI_EXPORT_DECLARATION

#ifdef AG_PF_WIN32
#define AG_EXPORT_AGB_EXTENSION_CLASS(UserEAPIClass) \
/*static*/ UserEAPIClass * UserEAPIClass::ms_pBrokerSession = NULL;\
AG_AGBAPI_EXPORT_DECLARATION	CAGbAPI *	AGB_CreateObject(	CAGFrame&			oSessionParams)\
{ \
	UserEAPIClass * pUserEAPIClass = new UserEAPIClass(	oSessionParams);\
	if ((pUserEAPIClass)&&(pUserEAPIClass->IsBrokerSession()))\
	{\
		UserEAPIClass::StaticSetBrokerSession(pUserEAPIClass);\
	}\
	return (CAGbAPI *)pUserEAPIClass;\
}\
AG_AGBAPI_EXPORT_DECLARATION	void	AGB_DeleteObject(		CAGbAPI *&					pAGbAPI)\
{ \
	if (pAGbAPI)\
	{\
		delete pAGbAPI;\
		pAGbAPI = NULL;\
	}\
}
#else
#define AG_EXPORT_AGB_EXTENSION_CLASS(UserEAPIClass) \
/*static*/ UserEAPIClass * UserEAPIClass::ms_pBrokerSession = NULL;
#endif	//	ndef AG_PF_WIN32

#endif	//	ndef _ACTIVE_GATEWAY_EXTENSION_H_

